/*
 * Decompiled with CFR 0.152.
 */
package capsule.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Serialization {
    protected static final Logger LOGGER = LogManager.getLogger(Serialization.class);

    public static List<Block> deserializeBlockList(List<? extends String> blockIds) {
        ArrayList<Block> states = new ArrayList<Block>();
        ArrayList<String> notfound = new ArrayList<String>();
        for (String string : blockIds) {
            ResourceLocation excludedLocation = new ResourceLocation(string);
            if (StringUtil.m_14408_((String)excludedLocation.m_135815_())) {
                List blockIdsList = ForgeRegistries.BLOCKS.getValues().stream().filter(block -> {
                    ResourceLocation registryName = block.getRegistryName();
                    if (registryName == null) {
                        return false;
                    }
                    return registryName.toString().toLowerCase().contains(blockId.toLowerCase());
                }).collect(Collectors.toList());
                if (blockIdsList.size() > 0) {
                    states.addAll(blockIdsList);
                    continue;
                }
                notfound.add(string);
                continue;
            }
            Block b = (Block)ForgeRegistries.BLOCKS.getValue(excludedLocation);
            if (b != null) {
                states.add(b);
                continue;
            }
            Optional<TagKey> tag = ForgeRegistries.BLOCKS.tags().getTagNames().filter(t -> excludedLocation.equals((Object)t.f_203868_())).findFirst();
            if (tag.isPresent()) {
                List blockIdsList = ForgeRegistries.BLOCKS.getValues().stream().filter(block -> block.m_204297_().m_203656_((TagKey)tag.get())).collect(Collectors.toList());
                states.addAll(blockIdsList);
                continue;
            }
            notfound.add(excludedLocation.toString());
        }
        if (notfound.size() > 0) {
            LOGGER.info(String.format("Blocks couldn't be resolved as Block or Tag from config name : %s. Those blocks won't be considered in the overridable or excluded blocks list when capturing with capsule.", String.join((CharSequence)", ", notfound.toArray(new CharSequence[0]))));
        }
        Block[] output = new Block[states.size()];
        return states;
    }

    public static String[] serializeBlockArray(Block[] states) {
        String[] blocksNames = new String[states.length];
        for (int i = 0; i < states.length; ++i) {
            ResourceLocation registryName = states[i].getRegistryName();
            blocksNames[i] = registryName == null ? null : registryName.toString();
        }
        return blocksNames;
    }
}

