/*
 * Decompiled with CFR 0.152.
 */
package capsule.helpers;

import capsule.blocks.BlockCapsuleMarker;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Spacial {
    public static final float MAX_BLOCKS_PER_TICK_THROW = 1.2f;
    protected static final Logger LOGGER = LogManager.getLogger(Spacial.class);

    public static BlockPos findBottomBlock(ItemEntity ItemEntity2) {
        return Spacial.findBottomBlock(ItemEntity2.m_20185_(), ItemEntity2.m_20186_(), ItemEntity2.m_20189_());
    }

    public static BlockPos findBottomBlock(double x, double y, double z) {
        return BlockPos.m_121990_((BlockPos)new BlockPos(x, y - 1.0, z), (BlockPos)new BlockPos(x + 1.0, y + 1.0, z + 1.0)).min(Comparator.comparingDouble(pos -> pos.m_203202_(x, y, z))).orElse(null);
    }

    public static boolean isImmergedInLiquid(Entity entity) {
        if (entity == null) {
            return false;
        }
        return !entity.m_20229_(0.0, 1.5, 0.0);
    }

    public static BlockHitResult clientRayTracePreview(Player thePlayer, float partialTicks, int size) {
        int blockReachDistance = 18 + size;
        Vec3 vec3d = thePlayer.m_20299_(partialTicks);
        Vec3 vec3d1 = thePlayer.m_20252_(partialTicks);
        Vec3 vec3d2 = vec3d.m_82520_(vec3d1.f_82479_ * (double)blockReachDistance, vec3d1.f_82480_ * (double)blockReachDistance, vec3d1.f_82481_ * (double)blockReachDistance);
        boolean stopOnLiquid = !Spacial.isImmergedInLiquid((Entity)thePlayer);
        return thePlayer.m_20193_().m_45547_(new ClipContext(vec3d, vec3d2, ClipContext.Block.OUTLINE, stopOnLiquid ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, (Entity)thePlayer));
    }

    @Nullable
    public static BlockPos findSpecificBlock(ItemEntity ItemEntity2, int maxRange, Class<? extends Block> searchedBlock) {
        if (searchedBlock == null) {
            return null;
        }
        double i = ItemEntity2.m_20185_();
        double j = ItemEntity2.m_20186_();
        double k = ItemEntity2.m_20189_();
        for (int range = 1; range < maxRange; ++range) {
            Iterable blockPoss = BlockPos.m_121940_((BlockPos)new BlockPos(i - (double)range, j - (double)range, k - (double)range), (BlockPos)new BlockPos(i + (double)range, j + (double)range, k + (double)range));
            for (BlockPos pos : blockPoss) {
                Block block = ItemEntity2.m_20193_().m_46805_(pos) ? ItemEntity2.m_20193_().m_8055_(pos).m_60734_() : null;
                if (block == null || !block.getClass().equals(searchedBlock)) continue;
                return new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            }
        }
        return null;
    }

    public static BlockPos getAnchor(BlockPos captureBasePosition, BlockState captureBaseState, int size) {
        Direction direction = null;
        try {
            direction = (Direction)captureBaseState.m_61143_((Property)BlockCapsuleMarker.f_52659_);
        }
        catch (Exception e) {
            LOGGER.error("Could not get BlockCapsuleMarker.FACING in blockstate at " + captureBasePosition);
            return captureBasePosition;
        }
        return new BlockPos((double)captureBasePosition.m_123341_() + (double)direction.m_122429_() * (0.5 + (double)size * 0.5), (double)captureBasePosition.m_123342_() + (double)direction.m_122430_() + (double)(direction.m_122430_() < 0 ? -size : -1), (double)captureBasePosition.m_123343_() + (double)direction.m_122431_() * (0.5 + (double)size * 0.5));
    }

    public static List<AABB> mergeVoxels(List<StructureTemplate.StructureBlockInfo> blocks) {
        HashMap blocksByPos = new HashMap();
        HashMap bbByPos = new HashMap();
        blocks.forEach(b -> blocksByPos.put(b.f_74675_, b));
        blocks.forEach(block -> {
            BlockPos destPos = block.f_74675_;
            BlockPos below = block.f_74675_.m_142082_(0, -1, 0);
            if (bbByPos.containsKey(below) && blocksByPos.containsKey(below) && ((StructureTemplate.StructureBlockInfo)blocksByPos.get((Object)below)).f_74676_.m_60734_() == block.f_74676_.m_60734_()) {
                BoundingBox bb = (BoundingBox)bbByPos.get(below);
                bbByPos.put(destPos, new BoundingBox(bb.m_162395_(), bb.m_162396_(), bb.m_162398_(), bb.m_162399_(), bb.m_162400_() + 1, bb.m_162401_()));
            } else {
                BoundingBox column = new BoundingBox(block.f_74675_);
                bbByPos.put(destPos, column);
            }
        });
        List<BoundingBox> allBB = bbByPos.values().stream().distinct().collect(Collectors.toList());
        ArrayList toRemove = new ArrayList();
        allBB.forEach(bb -> {
            if (!toRemove.contains(bb)) {
                BoundingBox matchingBB = Spacial.findMatchingExpandingX(bb, allBB);
                while (matchingBB != null) {
                    toRemove.add(matchingBB);
                    bb.m_162386_(matchingBB);
                    matchingBB = Spacial.findMatchingExpandingX(bb, allBB);
                }
            }
        });
        allBB.removeAll(toRemove);
        toRemove.clear();
        allBB.forEach(bb -> {
            if (!toRemove.contains(bb)) {
                BoundingBox matchingBB = Spacial.findMatchingExpandingZ(bb, allBB);
                while (matchingBB != null) {
                    toRemove.add(matchingBB);
                    bb.m_162386_(matchingBB);
                    matchingBB = Spacial.findMatchingExpandingZ(bb, allBB);
                }
            }
        });
        allBB.removeAll(toRemove);
        return allBB.stream().map(bb -> new AABB((double)bb.m_162395_(), (double)bb.m_162396_(), (double)bb.m_162398_(), (double)bb.m_162399_(), (double)bb.m_162400_(), (double)bb.m_162401_())).collect(Collectors.toList());
    }

    private static BoundingBox findMatchingExpandingX(BoundingBox bb, List<BoundingBox> allBB) {
        return allBB.stream().filter(candidate -> candidate != bb && candidate.m_162396_() == bb.m_162396_() && candidate.m_162400_() == bb.m_162400_() && candidate.m_162398_() == bb.m_162398_() && candidate.m_162401_() == bb.m_162401_() && candidate.m_162395_() == bb.m_162399_() + 1).findFirst().orElse(null);
    }

    private static BoundingBox findMatchingExpandingZ(BoundingBox bb, List<BoundingBox> allBB) {
        return allBB.stream().filter(candidate -> candidate != bb && candidate.m_162396_() == bb.m_162396_() && candidate.m_162400_() == bb.m_162400_() && candidate.m_162395_() == bb.m_162395_() && candidate.m_162399_() == bb.m_162399_() && candidate.m_162398_() == bb.m_162401_() + 1).findFirst().orElse(null);
    }

    public static boolean isThrowerUnderLiquid(ItemEntity ItemEntity2) {
        UUID thrower = ItemEntity2.m_32057_();
        if (thrower == null) {
            return false;
        }
        Player player = ItemEntity2.m_20193_().m_46003_(thrower);
        boolean underLiquid = Spacial.isImmergedInLiquid((Entity)player);
        return underLiquid;
    }

    public static boolean isEntityCollidingLiquid(ItemEntity ItemEntity2) {
        return !ItemEntity2.m_20229_(0.0, -0.1, 0.0);
    }

    public static boolean ItemEntityShouldAndCollideLiquid(ItemEntity ItemEntity2) {
        boolean throwerInLiquid = Spacial.isThrowerUnderLiquid(ItemEntity2);
        boolean entityInLiquid = Spacial.isEntityCollidingLiquid(ItemEntity2);
        return !throwerInLiquid && entityInLiquid;
    }

    public static void moveItemEntityToDeployPos(ItemEntity ItemEntity2, ItemStack capsule, boolean keepMomentum) {
        if (capsule.m_41783_() == null) {
            return;
        }
        BlockPos dest = BlockPos.m_122022_((long)capsule.m_41783_().m_128454_("deployAt"));
        double diffX = (double)dest.m_123341_() + 0.5 - ItemEntity2.m_20185_();
        double diffZ = (double)dest.m_123343_() + 0.5 - ItemEntity2.m_20189_();
        double distance = Math.sqrt(diffX * diffX + diffZ * diffZ);
        double requiredVelocity = distance / 10.0;
        double velocity = Math.min(requiredVelocity, (double)1.2f);
        double normalizedDiffX = diffX / distance;
        double normalizedDiffZ = diffZ / distance;
        Vec3 motion = ItemEntity2.m_20184_();
        ItemEntity2.m_20334_(keepMomentum ? 0.9 * motion.f_82479_ + 0.1 * normalizedDiffX * velocity : normalizedDiffX * velocity, motion.f_82480_, keepMomentum ? 0.9 * motion.f_82481_ + 0.1 * normalizedDiffZ * velocity : normalizedDiffZ * velocity);
    }

    public static AABB getBB(double relativeX, double relativeY, double relativeZ, int size, int extendSize) {
        AABB boundingBox = new AABB((double)(-extendSize) - 0.01 + relativeX, 1.01 + relativeY, (double)(-extendSize) - 0.01 + relativeZ, (double)extendSize + 1.01 + relativeX, (double)size + 1.01 + relativeY, (double)extendSize + 1.01 + relativeZ);
        return boundingBox;
    }
}

