/*
 * Decompiled with CFR 0.152.
 */
package capsule.items;

import capsule.CapsuleMod;
import capsule.Config;
import capsule.StructureSaver;
import capsule.client.CapsulePreviewHandler;
import capsule.helpers.Capsule;
import capsule.helpers.MinecraftNBT;
import capsule.helpers.Spacial;
import capsule.items.CapsuleItems;
import capsule.network.CapsuleContentPreviewQueryToServer;
import capsule.network.CapsuleLeftClickQueryToServer;
import capsule.network.CapsuleNetwork;
import capsule.network.CapsuleThrowQueryToServer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="capsule", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CapsuleItem
extends Item {
    public static final int CAPSULE_MAX_CAPTURE_SIZE = 255;
    protected static final Logger LOGGER = LogManager.getLogger(CapsuleItem.class);
    public static final float TO_RAD = (float)Math.PI / 180;
    public static final float GRAVITY_PER_TICK = 0.04f;
    public static long lastRotationTime = 0L;

    public CapsuleItem() {
        super(new Item.Properties().m_41491_(CapsuleMod.tabCapsule).m_41487_(1).m_41503_(0).setNoRepair());
    }

    public static boolean isOneUse(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41782_() && stack.m_41783_().m_128441_("oneUse") && stack.m_41783_().m_128471_("oneUse");
    }

    public static void setOneUse(ItemStack capsule) {
        CapsuleItem.setState(capsule, CapsuleState.ONE_USE);
        capsule.m_41784_().m_128379_("oneUse", true);
    }

    public static boolean isBlueprint(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41720_() instanceof CapsuleItem && stack.m_41782_() && stack.m_41783_().m_128441_("sourceInventory");
    }

    public static void setBlueprint(ItemStack capsule) {
        CapsuleItem.saveSourceInventory(capsule, null, null);
    }

    public static boolean isReward(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41782_() && stack.m_41783_().m_128441_("isReward") && stack.m_41783_().m_128471_("isReward") && CapsuleItem.isOneUse(stack);
    }

    public static void setIsReward(ItemStack capsule) {
        capsule.m_41784_().m_128379_("isReward", true);
        CapsuleItem.setOneUse(capsule);
    }

    public static boolean isInstantAndUndeployed(ItemStack capsule) {
        return CapsuleItem.hasState(capsule, CapsuleState.BLUEPRINT) || CapsuleItem.getSize(capsule) == 1 && !CapsuleItem.hasState(capsule, CapsuleState.DEPLOYED);
    }

    public static boolean hasStructureLink(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41782_() && stack.m_41783_().m_128441_("structureName");
    }

    public static boolean isLinkedStateCapsule(ItemStack itemstack) {
        return !itemstack.m_41619_() && itemstack.m_41720_() instanceof CapsuleItem && CapsuleItem.hasState(itemstack, CapsuleState.LINKED);
    }

    public static Component getLabel(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        if (!CapsuleItem.hasStructureLink(stack) && !CapsuleItem.hasState(stack, CapsuleState.LINKED)) {
            return new TranslatableComponent("items.capsule.content_empty");
        }
        if (stack.m_41782_() && stack.m_41783_().m_128441_("label") && !"".equals(stack.m_41783_().m_128461_("label"))) {
            return new TextComponent("\u00ab").m_7220_((Component)new TextComponent(stack.m_41783_().m_128461_("label")).m_130940_(ChatFormatting.ITALIC)).m_130946_("\u00bb");
        }
        return new TranslatableComponent("items.capsule.content_unlabeled");
    }

    public static void setLabel(ItemStack capsule, String label) {
        capsule.m_41784_().m_128359_("label", label);
    }

    public static int getSize(ItemStack capsule) {
        int size = 1;
        if (!capsule.m_41619_() && capsule.m_41782_() && capsule.m_41783_().m_128441_("size")) {
            size = capsule.m_41783_().m_128451_("size");
        }
        if (size > 255) {
            size = 255;
            capsule.m_41783_().m_128405_("size", size);
            LOGGER.error("Capsule sizes are capped to 255. Resized to : " + size);
        } else if (size % 2 == 0) {
            capsule.m_41783_().m_128405_("size", ++size);
            LOGGER.error("Capsule size must be an odd number to achieve consistency on deployment. Resized to : " + size);
        }
        return size;
    }

    public static void setSize(ItemStack capsule, int size) {
        if (size > 255) {
            size = 255;
            LOGGER.warn("Capsule sizes are capped to 255. Resized to : " + size);
        } else if (size % 2 == 0) {
            LOGGER.warn("Capsule size must be an odd number to achieve consistency on deployment. Resized to : " + ++size);
        }
        capsule.m_41784_().m_128405_("size", size);
    }

    public static int getYOffset(ItemStack capsule) {
        int yOffset = 0;
        if (!capsule.m_41619_() && capsule.m_41782_() && capsule.m_41783_().m_128441_("yOffset")) {
            yOffset = capsule.m_41783_().m_128451_("yOffset");
        }
        return yOffset;
    }

    public static void setYOffset(ItemStack capsule, int yOffset) {
        capsule.m_41784_().m_128405_("yOffset", yOffset);
    }

    public static String getStructureName(ItemStack capsule) {
        String name = null;
        if (capsule != null && capsule.m_41782_() && capsule.m_41783_().m_128441_("structureName")) {
            name = capsule.m_41783_().m_128461_("structureName");
        }
        return name;
    }

    public static void setStructureName(ItemStack capsule, String structureName) {
        if (!capsule.m_41782_()) {
            capsule.m_41751_(new CompoundTag());
        }
        capsule.m_41783_().m_128359_("structureName", structureName);
    }

    public static String getAuthor(ItemStack capsule) {
        String name = null;
        if (capsule != null && capsule.m_41782_() && capsule.m_41783_().m_128441_("author")) {
            name = capsule.m_41783_().m_128461_("author");
        }
        return name;
    }

    public static void setAuthor(ItemStack capsule, String author) {
        if (!capsule.m_41782_()) {
            capsule.m_41751_(new CompoundTag());
        }
        if (!StringUtil.m_14408_((String)author)) {
            capsule.m_41783_().m_128359_("author", author);
        }
    }

    public static int getBaseColor(ItemStack capsule) {
        return MinecraftNBT.getColor(capsule);
    }

    public static void setBaseColor(ItemStack capsule, int color) {
        MinecraftNBT.setColor(capsule, color);
    }

    public static int getMaterialColor(ItemStack capsule) {
        int color = 0;
        if (capsule != null && capsule.m_41782_() && capsule.m_41783_().m_128441_("color")) {
            color = capsule.m_41783_().m_128451_("color");
        }
        return color;
    }

    public static void setMaterialColor(ItemStack capsule, int color) {
        if (!capsule.m_41782_()) {
            capsule.m_41751_(new CompoundTag());
        }
        capsule.m_41783_().m_128405_("color", color);
    }

    public static int getUpgradeLevel(ItemStack stack) {
        int upgradeLevel = 0;
        if (stack.m_41782_() && stack.m_41783_().m_128441_("upgraded")) {
            upgradeLevel = stack.m_41783_().m_128451_("upgraded");
        }
        return upgradeLevel;
    }

    public static void setUpgradeLevel(ItemStack capsule, int upgrades) {
        if (!capsule.m_41782_()) {
            capsule.m_41751_(new CompoundTag());
        }
        capsule.m_41783_().m_128405_("upgraded", upgrades);
    }

    public static ResourceKey<Level> getDimension(ItemStack capsule) {
        ResourceKey dim = null;
        if (capsule != null && capsule.m_41782_() && capsule.m_41783_().m_128441_("spawnPosition")) {
            dim = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(capsule.m_41783_().m_128469_("spawnPosition").m_128461_("dim")));
        }
        return dim;
    }

    public static void setState(ItemStack stack, CapsuleState state) {
        stack.m_41784_().m_128405_("state", state.getValue());
    }

    public static boolean isOverpowered(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("overpowered") && stack.m_41783_().m_128445_("overpowered") == 1;
    }

    private static boolean isActivated(ItemStack capsule) {
        return CapsuleItem.hasState(capsule, CapsuleState.ACTIVATED) || CapsuleItem.hasState(capsule, CapsuleState.EMPTY_ACTIVATED) || CapsuleItem.hasState(capsule, CapsuleState.ONE_USE_ACTIVATED);
    }

    public static void setCanRotate(ItemStack capsule, boolean canRotate) {
        if (!capsule.m_41782_()) {
            capsule.m_41751_(new CompoundTag());
        }
        capsule.m_41783_().m_128379_("canRotate", canRotate);
    }

    public static boolean canRotate(ItemStack capsule) {
        return CapsuleItem.isBlueprint(capsule) || !CapsuleItem.hasState(capsule, CapsuleState.DEPLOYED) && capsule.m_41782_() && capsule.m_41783_().m_128441_("canRotate") && capsule.m_41783_().m_128471_("canRotate");
    }

    public static void revertStateFromActivated(ItemStack capsule) {
        if (CapsuleItem.isBlueprint(capsule)) {
            CapsuleItem.setState(capsule, CapsuleState.BLUEPRINT);
        } else if (CapsuleItem.isOneUse(capsule)) {
            CapsuleItem.setState(capsule, CapsuleState.ONE_USE);
        } else if (CapsuleItem.hasStructureLink(capsule)) {
            CapsuleItem.setState(capsule, CapsuleState.LINKED);
        } else {
            CapsuleItem.setState(capsule, CapsuleState.EMPTY);
        }
        if (capsule.m_41782_()) {
            capsule.m_41783_().m_128473_("activetimer");
        }
    }

    public static CapsuleState getState(ItemStack stack) {
        if (!stack.m_41782_()) {
            return CapsuleState.valueOf(0);
        }
        if (stack.m_41783_().m_128441_("state")) {
            return CapsuleState.valueOf(stack.m_41783_().m_128451_("state"));
        }
        return CapsuleState.valueOf(stack.m_41783_().m_128451_("Damage"));
    }

    public static boolean hasState(ItemStack stack, CapsuleState state) {
        return stack.m_41782_() && stack.m_41783_().m_128451_("state") == state.getValue();
    }

    @MethodsReturnNonnullByDefault
    public Component m_7626_(ItemStack stack) {
        TranslatableComponent name = new TranslatableComponent("items.capsule.name");
        MutableComponent state = null;
        switch (CapsuleItem.getState(stack)) {
            case ACTIVATED: 
            case EMPTY_ACTIVATED: 
            case ONE_USE_ACTIVATED: {
                state = new TranslatableComponent("items.capsule.state_activated").m_130940_(ChatFormatting.DARK_GREEN);
                break;
            }
            case LINKED: {
                state = null;
                break;
            }
            case DEPLOYED: {
                if (CapsuleItem.isBlueprint(stack)) {
                    name = new TranslatableComponent("items.capsule.state_blueprint");
                    break;
                }
                state = new TranslatableComponent("items.capsule.state_deployed");
                break;
            }
            case ONE_USE: {
                if (CapsuleItem.isReward(stack)) {
                    state = new TranslatableComponent("items.capsule.state_one_use");
                    break;
                }
                state = new TranslatableComponent("items.capsule.state_recovery");
                break;
            }
            case BLUEPRINT: {
                name = new TranslatableComponent("items.capsule.state_blueprint");
            }
        }
        Component content = CapsuleItem.getLabel(stack);
        TextComponent output = new TextComponent("");
        if (state != null) {
            output = output.m_7220_((Component)state).m_130946_(" ");
        }
        if (content != null) {
            output = output.m_7220_(content).m_130946_(" ");
        }
        output = output.m_7220_((Component)name);
        return output;
    }

    public int m_6473_() {
        return 5;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.m_6473_();
    }

    public boolean m_8120_(ItemStack stack) {
        return !CapsuleItem.hasState(stack, CapsuleState.ONE_USE);
    }

    public boolean m_5812_(ItemStack stack) {
        return CapsuleItem.isOverpowered(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack capsule, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        String author = CapsuleItem.getAuthor(capsule);
        if (author != null) {
            tooltip.add((Component)new TextComponent(ChatFormatting.DARK_AQUA + ChatFormatting.ITALIC + I18n.m_118938_((String)"capsule.tooltip.author", (Object[])new Object[0]) + " " + author + ChatFormatting.RESET));
        }
        if (CapsuleItem.hasState(capsule, CapsuleState.ONE_USE)) {
            tooltip.add((Component)new TextComponent(I18n.m_118938_((String)"capsule.tooltip.one_use", (Object[])new Object[0]).trim()));
        }
        if (CapsuleItem.isOverpowered(capsule)) {
            tooltip.add((Component)new TextComponent(ChatFormatting.DARK_PURPLE + I18n.m_118938_((String)"capsule.tooltip.overpowered", (Object[])new Object[0]) + ChatFormatting.RESET));
        }
        int size = CapsuleItem.getSize(capsule);
        int upgradeLevel = CapsuleItem.getUpgradeLevel(capsule);
        String sizeTxt = size + "\u00d7" + size + "\u00d7" + size;
        if (upgradeLevel > 0) {
            sizeTxt = sizeTxt + " (" + upgradeLevel + "/" + Config.upgradeLimit + " " + I18n.m_118938_((String)"capsule.tooltip.upgraded", (Object[])new Object[0]) + ")";
        }
        if (CapsuleItem.isInstantAndUndeployed(capsule) || CapsuleItem.isBlueprint(capsule)) {
            sizeTxt = sizeTxt + " (" + I18n.m_118938_((String)"capsule.tooltip.instant", (Object[])new Object[0]).trim() + ")";
        }
        tooltip.add((Component)new TextComponent(I18n.m_118938_((String)"capsule.tooltip.size", (Object[])new Object[0]) + ": " + sizeTxt));
        if (CapsuleItem.isBlueprint(capsule)) {
            if (CapsuleItem.hasState(capsule, CapsuleState.DEPLOYED)) {
                this.tooltipAddMultiline(tooltip, "capsule.tooltip.blueprintUseUncharged", ChatFormatting.WHITE);
            } else {
                this.tooltipAddMultiline(tooltip, "capsule.tooltip.canRotate", ChatFormatting.WHITE);
                this.tooltipAddMultiline(tooltip, "capsule.tooltip.blueprintUseCharged", ChatFormatting.WHITE);
            }
        } else if (CapsuleItem.canRotate(capsule)) {
            this.tooltipAddMultiline(tooltip, "capsule.tooltip.canRotate", ChatFormatting.WHITE);
        } else if (capsule.m_41782_() && capsule.m_41783_().m_128441_("canRotate")) {
            this.tooltipAddMultiline(tooltip, "capsule.tooltip.cannotRotate", ChatFormatting.DARK_GRAY);
        }
        if (flagIn == TooltipFlag.Default.ADVANCED) {
            tooltip.add((Component)new TextComponent(ChatFormatting.GOLD + "structureName: " + CapsuleItem.getStructureName(capsule)));
            tooltip.add((Component)new TextComponent(ChatFormatting.GOLD + "oneUse: " + CapsuleItem.isOneUse(capsule)));
            tooltip.add((Component)new TextComponent(ChatFormatting.GOLD + "isReward: " + CapsuleItem.isReward(capsule)));
            if (CapsuleItem.isBlueprint(capsule)) {
                tooltip.add((Component)new TextComponent(ChatFormatting.GOLD + "sourceInventory: " + CapsuleItem.getSourceInventoryLocation(capsule) + " in dimension " + CapsuleItem.getSourceInventoryDimension(capsule)));
            }
            tooltip.add((Component)new TextComponent(ChatFormatting.GOLD + "color (material): " + Integer.toHexString(CapsuleItem.getMaterialColor(capsule))));
            StructurePlaceSettings p = CapsuleItem.getPlacement(capsule);
            tooltip.add((Component)new TextComponent(ChatFormatting.GOLD + "\u232f Symmetry: " + Capsule.getMirrorLabel(p)));
            tooltip.add((Component)new TextComponent(ChatFormatting.GOLD + "\u27f3 Rotation: " + Capsule.getRotationLabel(p)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tooltipAddMultiline(List<Component> tooltip, String key, ChatFormatting formatting) {
        for (String s : I18n.m_118938_((String)key, (Object[])new Object[0]).trim().split("\\\\n")) {
            tooltip.add((Component)new TextComponent((String)(formatting == null ? s : formatting + s)));
        }
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> subItems) {
        if (this.m_41389_(tab)) {
            subItems.addAll(CapsuleItems.capsuleList.keySet());
            subItems.addAll(CapsuleItems.opCapsuleList.keySet());
            if (CapsuleItems.unlabelledCapsule != null) {
                subItems.add((Object)((ItemStack)CapsuleItems.unlabelledCapsule.getKey()));
            }
            if (CapsuleItems.deployedCapsule != null) {
                subItems.add((Object)((ItemStack)CapsuleItems.deployedCapsule.getKey()));
            }
            if (CapsuleItems.recoveryCapsule != null) {
                subItems.add((Object)((ItemStack)CapsuleItems.recoveryCapsule.getKey()));
            }
            if (CapsuleItems.blueprintChangedCapsule != null) {
                subItems.add((Object)((ItemStack)CapsuleItems.blueprintChangedCapsule.getKey()));
            }
            for (Pair<ItemStack, CraftingRecipe> blueprintCapsule : CapsuleItems.blueprintCapsules) {
                subItems.add((Object)((ItemStack)blueprintCapsule.getKey()));
            }
            for (Pair<ItemStack, CraftingRecipe> blueprintCapsule : CapsuleItems.blueprintPrefabs) {
                subItems.add((Object)((ItemStack)blueprintCapsule.getKey()));
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack stack = event.getPlayer().m_21205_();
        if (event.getWorld().f_46443_ && stack.m_41720_() instanceof CapsuleItem && (CapsuleItem.isBlueprint(stack) || CapsuleItem.canRotate(stack) && !CapsuleItem.hasState(stack, CapsuleState.EMPTY))) {
            CapsuleNetwork.wrapper.sendToServer((Object)new CapsuleLeftClickQueryToServer());
            CapsuleItem.askPreviewIfNeeded(stack);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack stack;
        if (!event.isCanceled() && (stack = event.getPlayer().m_21205_()).m_41720_() instanceof CapsuleItem) {
            event.setCanceled(true);
            if (event.getWorld().f_46443_) {
                if (CapsuleItem.canRotate(stack)) {
                    if (lastRotationTime + 60L < Util.m_137550_()) {
                        lastRotationTime = Util.m_137550_();
                        CapsuleNetwork.wrapper.sendToServer((Object)new CapsuleLeftClickQueryToServer());
                        CapsuleItem.askPreviewIfNeeded(stack);
                    }
                } else if (!CapsuleItem.hasState(stack, CapsuleState.DEPLOYED)) {
                    event.getPlayer().m_6352_((Component)new TranslatableComponent("capsule.tooltip.cannotRotate"), Util.f_137441_);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void askPreviewIfNeeded(ItemStack stack) {
        if (!CapsulePreviewHandler.currentPreview.containsKey(CapsuleItem.getStructureName(stack)) && Minecraft.m_91087_().m_91403_() != null) {
            CapsuleNetwork.wrapper.sendToServer((Object)new CapsuleContentPreviewQueryToServer(CapsuleItem.getStructureName(stack)));
        }
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockEntity te;
        InteractionHand hand = context.m_43724_();
        if (context.m_43724_() == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        ItemStack capsule = player.m_21120_(hand);
        if (player.m_6144_() && CapsuleItem.isBlueprint(capsule) && (te = world.m_7702_(pos)) != null && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).isPresent()) {
            if (CapsuleItem.hasSourceInventory(capsule) && pos.equals((Object)CapsuleItem.getSourceInventoryLocation(capsule)) && CapsuleItem.getSourceInventoryDimension(capsule).equals((Object)world.m_46472_())) {
                CapsuleItem.saveSourceInventory(capsule, null, null);
            } else {
                CapsuleItem.saveSourceInventory(capsule, pos, (ResourceKey<Level>)world.m_46472_());
            }
            return InteractionResult.SUCCESS;
        }
        return super.onItemUseFirst(stack, context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack capsule = playerIn.m_21120_(handIn);
        if (handIn == InteractionHand.OFF_HAND) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)capsule);
        }
        if (playerIn.m_6144_() && (CapsuleItem.hasState(capsule, CapsuleState.LINKED) || CapsuleItem.hasState(capsule, CapsuleState.DEPLOYED) || CapsuleItem.hasState(capsule, CapsuleState.ONE_USE) || CapsuleItem.hasState(capsule, CapsuleState.BLUEPRINT))) {
            CapsuleMod.openGuiScreenCommon.accept(playerIn);
        } else if (!worldIn.f_46443_) {
            if (!CapsuleItem.isInstantAndUndeployed(capsule)) {
                this.activateCapsule(capsule, (ServerLevel)worldIn, playerIn);
            }
        } else if (worldIn.f_46443_) {
            BlockPos dest;
            BlockHitResult rtr;
            if (!CapsuleItem.isInstantAndUndeployed(capsule) && (CapsuleItem.hasState(capsule, CapsuleState.LINKED) || CapsuleItem.hasState(capsule, CapsuleState.ONE_USE))) {
                rtr = CapsuleItem.hasStructureLink(capsule) ? Spacial.clientRayTracePreview(playerIn, 0.0f, CapsuleItem.getSize(capsule)) : null;
                BlockPos blockPos = dest = rtr != null && rtr.m_6662_() == HitResult.Type.BLOCK ? rtr.m_82425_().m_141952_(rtr.m_82434_().m_122436_()).m_142082_(0, CapsuleItem.getYOffset(capsule), 0) : null;
                if (dest != null) {
                    CapsuleNetwork.wrapper.sendToServer((Object)new CapsuleContentPreviewQueryToServer(capsule.m_41783_().m_128461_("structureName")));
                }
            }
            if (CapsuleItem.isInstantAndUndeployed(capsule)) {
                rtr = Spacial.clientRayTracePreview(playerIn, 0.0f, CapsuleItem.getSize(capsule));
                dest = null;
                if (rtr != null && rtr.m_6662_() == HitResult.Type.BLOCK) {
                    dest = CapsuleItem.hasState(capsule, CapsuleState.EMPTY) ? rtr.m_82425_() : rtr.m_82425_().m_141952_(rtr.m_82434_().m_122436_());
                    dest = dest.m_142082_(0, CapsuleItem.getYOffset(capsule), 0);
                }
                if (dest != null) {
                    CapsuleNetwork.wrapper.sendToServer((Object)new CapsuleThrowQueryToServer(dest, true));
                }
            } else if (CapsuleItem.isActivated(capsule)) {
                rtr = CapsuleItem.hasStructureLink(capsule) ? Spacial.clientRayTracePreview(playerIn, 0.0f, CapsuleItem.getSize(capsule)) : null;
                dest = rtr != null && rtr.m_6662_() == HitResult.Type.BLOCK ? rtr.m_82425_().m_141952_(rtr.m_82434_().m_122436_()).m_142082_(0, CapsuleItem.getYOffset(capsule), 0) : null;
                CapsuleNetwork.wrapper.sendToServer((Object)new CapsuleThrowQueryToServer(dest, false));
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)capsule);
    }

    public void activateCapsule(ItemStack capsule, ServerLevel worldIn, Player playerIn) {
        if (CapsuleItem.hasState(capsule, CapsuleState.EMPTY)) {
            CapsuleItem.setState(capsule, CapsuleState.EMPTY_ACTIVATED);
            this.startTimer((Level)worldIn, playerIn, capsule);
        } else if (CapsuleItem.hasState(capsule, CapsuleState.LINKED)) {
            CapsuleItem.setState(capsule, CapsuleState.ACTIVATED);
            this.startTimer((Level)worldIn, playerIn, capsule);
        } else if (CapsuleItem.hasState(capsule, CapsuleState.ONE_USE)) {
            CapsuleItem.setState(capsule, CapsuleState.ONE_USE_ACTIVATED);
            this.startTimer((Level)worldIn, playerIn, capsule);
        } else if (CapsuleItem.hasState(capsule, CapsuleState.DEPLOYED) && CapsuleItem.getDimension(capsule) != null) {
            try {
                Capsule.resentToCapsule(capsule, worldIn, playerIn);
                worldIn.m_5594_(null, playerIn.m_142538_(), SoundEvents.f_12443_, SoundSource.BLOCKS, 0.2f, 0.4f);
            }
            catch (Exception e) {
                LOGGER.error("Couldn't resend the content into the capsule", (Throwable)e);
            }
        }
    }

    private void startTimer(Level worldIn, Player playerIn, ItemStack capsule) {
        CompoundTag timer = capsule.m_41698_("activetimer");
        timer.m_128405_("starttime", playerIn.f_19797_);
        worldIn.m_5594_(null, playerIn.m_142538_(), SoundEvents.f_12444_, SoundSource.BLOCKS, 0.2f, 0.9f);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.f_46443_) {
            CompoundTag timer = stack.m_41737_("activetimer");
            if (timer != null && CapsuleItem.isActivated(stack) && timer.m_128441_("starttime") && entityIn.f_19797_ >= timer.m_128451_("starttime") + Config.previewDisplayDuration) {
                CapsuleItem.revertStateFromActivated(stack);
                worldIn.m_5594_(null, entityIn.m_142538_(), SoundEvents.f_12443_, SoundSource.BLOCKS, 0.2f, 0.4f);
            }
            if (CapsuleItem.isActivated(stack) && !timer.m_128441_("starttime")) {
                CapsuleItem.revertStateFromActivated(stack);
            }
        }
    }

    public boolean onEntityItemUpdate(ItemStack capsule, ItemEntity entity) {
        super.onEntityItemUpdate(capsule, entity);
        if (capsule == null) {
            return false;
        }
        if (!entity.m_20193_().f_46443_ && entity.f_19797_ > 2 && CapsuleItem.isActivated(capsule) && (entity.f_19863_ || entity.f_19862_ || Spacial.ItemEntityShouldAndCollideLiquid(entity))) {
            Capsule.handleItemEntityOnGround(entity, capsule);
        }
        if (!entity.m_20193_().f_46443_ && CapsuleItem.isActivated(capsule) && capsule.m_41782_() && capsule.m_41783_().m_128441_("deployAt") && !entity.f_19863_ || entity.f_19862_ && !Spacial.ItemEntityShouldAndCollideLiquid(entity)) {
            Spacial.moveItemEntityToDeployPos(entity, capsule, true);
        }
        return false;
    }

    @SubscribeEvent
    public static void onTickPlayerEvent(TickEvent.PlayerTickEvent event) {
        if (!event.player.f_19853_.f_46443_) {
            for (int i = 0; i < event.player.m_150109_().m_6643_(); ++i) {
                ItemStack itemstack = event.player.m_150109_().m_8020_(i);
                if (!itemstack.m_41782_() || !itemstack.m_41783_().m_128441_("templateShouldBeCopied")) continue;
                CapsuleItem.duplicateBlueprintTemplate(itemstack, event.player.f_19853_, event.player);
            }
        }
    }

    public void m_7836_(ItemStack capsule, Level worldIn, Player playerIn) {
        CapsuleItem.duplicateBlueprintTemplate(capsule, worldIn, playerIn);
    }

    public static void duplicateBlueprintTemplate(ItemStack capsule, Level worldIn, Player playerIn) {
        String srcStructurePath;
        if (!worldIn.f_46443_ && capsule.m_41720_() instanceof CapsuleItem && CapsuleItem.isBlueprint(capsule) && (srcStructurePath = CapsuleItem.getStructureName(capsule)) != null) {
            String templateName = StructureSaver.createBlueprintTemplate(srcStructurePath, capsule, (ServerLevel)worldIn, playerIn);
            CapsuleItem.setStructureName(capsule, templateName);
            if (capsule.m_41783_() != null) {
                capsule.m_41783_().m_128473_("templateShouldBeCopied");
            }
        }
    }

    public static Map<BlockPos, Block> getOccupiedSourcePos(ItemStack capsule) {
        HashMap<BlockPos, Block> occupiedSources = null;
        if (capsule.m_41782_() && capsule.m_41783_().m_128441_("occupiedSpawnPositions")) {
            occupiedSources = new HashMap<BlockPos, Block>();
            ListTag list = capsule.m_41783_().m_128437_("occupiedSpawnPositions", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag entry = list.m_128728_(i);
                occupiedSources.put(BlockPos.m_122022_((long)entry.m_128454_("pos")), Block.m_49803_((int)entry.m_128451_("blockId")).m_60734_());
            }
        }
        return occupiedSources;
    }

    public static void cleanDeploymentTags(ItemStack capsule) {
        capsule.m_41783_().m_128473_("spawnPosition");
        capsule.m_41783_().m_128473_("occupiedSpawnPositions");
    }

    public static List<Block> getExcludedBlocs(ItemStack stack) {
        List<Block> excludedBlocks = Config.excludedBlocks;
        if (CapsuleItem.isOverpowered(stack)) {
            excludedBlocks = Config.opExcludedBlocks;
        }
        return excludedBlocks;
    }

    public static int getColorFromItemstack(ItemStack stack, int renderPass) {
        int color = 0xFFFFFF;
        if (renderPass == 0) {
            color = MinecraftNBT.getColor(stack);
        } else if (renderPass == 1) {
            if (CapsuleItem.isBlueprint(stack) && CapsuleItem.hasState(stack, CapsuleState.DEPLOYED)) {
                color = 8176874;
            } else if (stack.m_41782_() && stack.m_41783_().m_128441_("color")) {
                color = stack.m_41783_().m_128451_("color");
            }
        } else if (renderPass == 2) {
            color = CapsuleItem.isBlueprint(stack) ? 3912700 : 0xFFFFFF;
        }
        return color;
    }

    public static void saveSpawnPosition(ItemStack capsule, BlockPos dest, String dimID) {
        CompoundTag pos = new CompoundTag();
        pos.m_128405_("x", dest.m_123341_());
        pos.m_128405_("y", dest.m_123342_());
        pos.m_128405_("z", dest.m_123343_());
        pos.m_128359_("dim", dimID);
        capsule.m_41784_().m_128365_("spawnPosition", (Tag)pos);
    }

    public static void saveSourceInventory(ItemStack capsule, BlockPos dest, ResourceKey<Level> dimID) {
        CompoundTag pos = new CompoundTag();
        if (dest != null) {
            pos.m_128405_("x", dest.m_123341_());
            pos.m_128405_("y", dest.m_123342_());
            pos.m_128405_("z", dest.m_123343_());
            pos.m_128359_("dim", dimID.m_135782_().toString());
        }
        capsule.m_41784_().m_128365_("sourceInventory", (Tag)pos);
    }

    public static boolean hasSourceInventory(ItemStack capsule) {
        return capsule.m_41782_() && capsule.m_41783_().m_128441_("sourceInventory") && capsule.m_41783_().m_128469_("sourceInventory").m_128441_("x");
    }

    @Nullable
    public static BlockPos getSourceInventoryLocation(ItemStack capsule) {
        if (CapsuleItem.hasSourceInventory(capsule)) {
            CompoundTag sourceInventory = capsule.m_41783_().m_128469_("sourceInventory");
            return new BlockPos(sourceInventory.m_128451_("x"), sourceInventory.m_128451_("y"), sourceInventory.m_128451_("z"));
        }
        return null;
    }

    @Nullable
    public static ResourceKey<Level> getSourceInventoryDimension(ItemStack capsule) {
        if (CapsuleItem.hasSourceInventory(capsule)) {
            return ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(capsule.m_41783_().m_128469_("sourceInventory").m_128461_("dim")));
        }
        return null;
    }

    @Nullable
    public static IItemHandler getSourceInventory(ItemStack blueprint, ServerLevel w) {
        BlockPos location = CapsuleItem.getSourceInventoryLocation(blueprint);
        ResourceKey<Level> dimension = CapsuleItem.getSourceInventoryDimension(blueprint);
        if (location == null || dimension == null) {
            return null;
        }
        ServerLevel inventoryWorld = w.m_142572_().m_129880_(dimension);
        BlockEntity te = inventoryWorld.m_7702_(location);
        if (te != null) {
            return (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null);
        }
        return null;
    }

    public static void setPlacement(ItemStack blueprint, StructurePlaceSettings placementSettings) {
        if (!blueprint.m_41782_()) {
            blueprint.m_41751_(new CompoundTag());
        }
        blueprint.m_41783_().m_128359_("rotation", placementSettings == null ? Rotation.NONE.name() : placementSettings.m_74404_().name());
        blueprint.m_41783_().m_128359_("mirror", placementSettings == null ? Mirror.NONE.name() : placementSettings.m_74401_().name());
    }

    public static StructurePlaceSettings getPlacement(ItemStack capsule) {
        if (CapsuleItem.hasPlacement(capsule)) {
            StructurePlaceSettings placementSettings = new StructurePlaceSettings().m_74377_(Mirror.valueOf((String)capsule.m_41783_().m_128461_("mirror"))).m_74379_(Rotation.valueOf((String)capsule.m_41783_().m_128461_("rotation"))).m_74392_(false);
            return placementSettings;
        }
        return new StructurePlaceSettings();
    }

    public static boolean hasPlacement(ItemStack blueprint) {
        if (!blueprint.m_41782_()) {
            blueprint.m_41751_(new CompoundTag());
        }
        return blueprint.m_41783_().m_128441_("mirror") && blueprint.m_41783_().m_128441_("rotation");
    }

    public static void clearCapsule(ItemStack capsule) {
        CapsuleItem.setState(capsule, CapsuleState.EMPTY);
        if (!capsule.m_41782_()) {
            return;
        }
        capsule.m_41783_().m_128473_("structureName");
        capsule.m_41783_().m_128473_("sourceInventory");
        capsule.m_41783_().m_128473_("canRotate");
    }

    public static enum CapsuleState {
        EMPTY(0),
        EMPTY_ACTIVATED(4),
        ACTIVATED(1),
        LINKED(2),
        DEPLOYED(3),
        ONE_USE(5),
        ONE_USE_ACTIVATED(6),
        BLUEPRINT(7);

        private final int value;
        private static final Map<Integer, CapsuleState> map;

        private CapsuleState(int value) {
            this.value = value;
        }

        public static CapsuleState valueOf(int state) {
            if (map.containsKey(state)) {
                return map.get(state);
            }
            LOGGER.error("Capsule with state " + state + " should not exist. The item you are using is corrupted!");
            return DEPLOYED;
        }

        public int getValue() {
            return this.value;
        }

        static {
            map = new HashMap<Integer, CapsuleState>();
            for (CapsuleState state : CapsuleState.values()) {
                map.put(state.value, state);
            }
        }
    }
}

