/*
 * Decompiled with CFR 0.152.
 */
package capsule.plugins.jei;

import capsule.Config;
import capsule.blocks.CapsuleBlocks;
import capsule.items.CapsuleItem;
import capsule.items.CapsuleItems;
import capsule.recipes.RecoveryCapsuleRecipe;
import capsule.recipes.UpgradeCapsuleRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@JeiPlugin
public class CapsulePlugin
implements IModPlugin {
    protected static final Logger LOGGER = LogManager.getLogger(CapsulePlugin.class);

    public void registerItemSubtypes(ISubtypeRegistration subtypeRegistry) {
        subtypeRegistry.registerSubtypeInterpreter((Item)CapsuleItems.CAPSULE, (IIngredientSubtypeInterpreter)new CapsuleSubtypeInterpreter());
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registry) {
        ArrayList<Object> recipes = new ArrayList<Object>();
        Ingredient upgradeIngredient = ((UpgradeCapsuleRecipe)CapsuleItems.upgradedCapsule.getValue()).upgradeIngredient;
        for (ItemStack capsule : CapsuleItems.capsuleList.keySet()) {
            for (int upLevel = 1; upLevel < Math.min(8, Config.upgradeLimit); ++upLevel) {
                ItemStack capsuleUp = CapsuleItems.getUpgradedCapsule(capsule, upLevel);
                NonNullList ingredients = NonNullList.m_122780_((int)(upLevel + 1), (Object)upgradeIngredient);
                ingredients.set(0, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{capsule}));
                recipes.add(new ShapelessRecipe(new ResourceLocation("capsule", "capsule"), "capsule", capsuleUp, ingredients));
            }
            recipes.add(new ShapelessRecipe(new ResourceLocation("capsule", "capsule"), "capsule", capsule, NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{CapsuleItems.getUnlabelledCapsule(capsule)})})));
        }
        if (CapsuleItems.recoveryCapsule == null || CapsuleItems.unlabelledCapsule == null || CapsuleItems.deployedCapsule == null || CapsuleItems.blueprintChangedCapsule == null) {
            LOGGER.error("Some required capsule recipe is missing (recovery, regular capsules or blueprintChanged recipe). The datapack might be corrupted for capsule or the recipe have been remove. JEI won't display the items and capsule might break at some points.");
            return;
        }
        ItemStack recoveryCapsule = (ItemStack)CapsuleItems.recoveryCapsule.getKey();
        ItemStack unlabelled = (ItemStack)CapsuleItems.unlabelledCapsule.getKey();
        ItemStack unlabelledDeployed = (ItemStack)CapsuleItems.deployedCapsule.getKey();
        CapsuleItem.setState(unlabelledDeployed, CapsuleItem.CapsuleState.DEPLOYED);
        Ingredient anyBlueprint = Ingredient.m_43927_((ItemStack[])((ItemStack[])CapsuleItems.blueprintCapsules.stream().map(Pair::getKey).toArray(ItemStack[]::new)));
        Ingredient unlabelledIng = Ingredient.merge(Arrays.asList(Ingredient.m_43927_((ItemStack[])new ItemStack[]{unlabelled}), anyBlueprint, Ingredient.m_43927_((ItemStack[])new ItemStack[]{recoveryCapsule})));
        recipes.add(((RecoveryCapsuleRecipe)CapsuleItems.recoveryCapsule.getValue()).recipe);
        for (Pair<ItemStack, CraftingRecipe> pair : CapsuleItems.blueprintCapsules) {
            recipes.add((CraftingRecipe)pair.getValue());
        }
        for (Pair<ItemStack, CraftingRecipe> pair : CapsuleItems.blueprintPrefabs) {
            recipes.add((CraftingRecipe)pair.getValue());
        }
        ItemStack withNewTemplate = (ItemStack)CapsuleItems.blueprintChangedCapsule.getKey();
        CapsuleItem.setStructureName(withNewTemplate, "newTemplate");
        CapsuleItem.setLabel(withNewTemplate, "Changed Template");
        recipes.add(new ShapelessRecipe(new ResourceLocation("capsule", "capsule"), "capsule", withNewTemplate, NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{anyBlueprint, unlabelledIng})));
        registry.addRecipes(RecipeTypes.CRAFTING, recipes);
        registry.addIngredientInfo(new ArrayList<ItemStack>(CapsuleItems.capsuleList.keySet()), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("jei.capsule.desc.capsule")});
        registry.addIngredientInfo((Object)((ItemStack)CapsuleItems.blueprintChangedCapsule.getKey()), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("jei.capsule.desc.blueprintCapsule")});
        registry.addIngredientInfo((Object)((ItemStack)CapsuleItems.unlabelledCapsule.getKey()), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("jei.capsule.desc.linkedCapsule")});
        registry.addIngredientInfo((Object)((ItemStack)CapsuleItems.deployedCapsule.getKey()), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("jei.capsule.desc.linkedCapsule")});
        registry.addIngredientInfo((Object)((ItemStack)CapsuleItems.recoveryCapsule.getKey()), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("jei.capsule.desc.recoveryCapsule")});
        for (Pair<ItemStack, CraftingRecipe> pair : CapsuleItems.blueprintCapsules) {
            registry.addIngredientInfo((Object)((ItemStack)pair.getKey()), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("jei.capsule.desc.blueprintCapsule")});
        }
        for (Pair<ItemStack, CraftingRecipe> pair : CapsuleItems.blueprintPrefabs) {
            registry.addIngredientInfo((Object)((ItemStack)pair.getKey()), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("jei.capsule.desc.blueprintCapsule")});
        }
        ItemStack itemStack = CapsuleItems.withState(CapsuleItem.CapsuleState.EMPTY);
        itemStack.m_41700_("overpowered", (Tag)ByteTag.m_128273_((boolean)true));
        registry.addIngredientInfo((Object)itemStack, VanillaTypes.ITEM, new Component[]{new TranslatableComponent("jei.capsule.desc.opCapsule")});
        registry.addIngredientInfo((Object)new ItemStack((ItemLike)CapsuleBlocks.CAPSULE_MARKER), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("jei.capsule.desc.capsuleMarker")});
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("capsule", "main");
    }

    private static class CapsuleSubtypeInterpreter
    implements IIngredientSubtypeInterpreter<ItemStack> {
        private CapsuleSubtypeInterpreter() {
        }

        public String apply(ItemStack itemStack, UidContext context) {
            if (!(itemStack.m_41720_() instanceof CapsuleItem)) {
                return null;
            }
            String isOP = String.valueOf(itemStack.m_41782_() && itemStack.m_41783_().m_128471_("overpowered"));
            String capsuleState = String.valueOf((Object)CapsuleItem.getState(itemStack));
            String capsuleColor = String.valueOf(CapsuleItem.getMaterialColor(itemStack));
            String capsuleBlueprint = String.valueOf(CapsuleItem.isBlueprint(itemStack));
            Component labelComp = CapsuleItem.getLabel(itemStack);
            String label = labelComp == null ? "" : labelComp.getString();
            return capsuleState + capsuleColor + isOP + capsuleBlueprint + label;
        }
    }
}

