/*
 * Decompiled with CFR 0.152.
 */
package capsule.recipes;

import capsule.helpers.MinecraftNBT;
import capsule.items.CapsuleItem;
import capsule.items.CapsuleItems;
import capsule.recipes.CapsuleRecipes;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;

public class DyeCapsuleRecipe
extends CustomRecipe {
    public DyeCapsuleRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public RecipeSerializer<?> m_7707_() {
        return CapsuleRecipes.DYE_CAPSULE_SERIALIZER;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        ItemStack itemstack = ItemStack.f_41583_;
        ArrayList arraylist = Lists.newArrayList();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack itemstack1 = inv.m_8020_(i);
            if (itemstack1.m_41619_()) continue;
            if (itemstack1.m_41720_() instanceof CapsuleItem) {
                itemstack = itemstack1;
                continue;
            }
            if (!(itemstack1.m_41720_() instanceof DyeItem)) {
                return false;
            }
            arraylist.add(itemstack1);
        }
        return !itemstack.m_41619_() && !arraylist.isEmpty();
    }

    public ItemStack assemble(CraftingContainer inv) {
        ArrayList dyes = Lists.newArrayList();
        ItemStack itemstack = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack itemstack1 = inv.m_8020_(i);
            if (itemstack1.m_41619_()) continue;
            Item item = itemstack1.m_41720_();
            if (item instanceof CapsuleItem) {
                if (!itemstack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                itemstack = itemstack1.m_41777_();
                continue;
            }
            if (!(item instanceof DyeItem)) {
                return ItemStack.f_41583_;
            }
            dyes.add((DyeItem)item);
        }
        return !itemstack.m_41619_() && !dyes.isEmpty() ? DyeCapsuleRecipe.dyeItem(itemstack, dyes) : ItemStack.f_41583_;
    }

    static ItemStack dyeItem(ItemStack stack, List<DyeItem> dyes) {
        ItemStack itemstack = ItemStack.f_41583_;
        int[] aint = new int[3];
        int i = 0;
        int j = 0;
        CapsuleItem idyeablearmoritem = null;
        Item item = stack.m_41720_();
        if (item instanceof CapsuleItem) {
            idyeablearmoritem = (CapsuleItem)item;
            itemstack = stack.m_41777_();
            itemstack.m_41764_(1);
            if (MinecraftNBT.hasColor(stack)) {
                int k = MinecraftNBT.getColor(itemstack);
                float f = (float)(k >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(k & 0xFF) / 255.0f;
                i = (int)((float)i + Math.max(f, Math.max(f1, f2)) * 255.0f);
                aint[0] = (int)((float)aint[0] + f * 255.0f);
                aint[1] = (int)((float)aint[1] + f1 * 255.0f);
                aint[2] = (int)((float)aint[2] + f2 * 255.0f);
                ++j;
            }
            for (DyeItem dyeitem : dyes) {
                float[] afloat = dyeitem.m_41089_().m_41068_();
                int i2 = (int)(afloat[0] * 255.0f);
                int l = (int)(afloat[1] * 255.0f);
                int i1 = (int)(afloat[2] * 255.0f);
                i += Math.max(i2, Math.max(l, i1));
                aint[0] = aint[0] + i2;
                aint[1] = aint[1] + l;
                aint[2] = aint[2] + i1;
                ++j;
            }
        }
        if (idyeablearmoritem == null) {
            return ItemStack.f_41583_;
        }
        int j1 = aint[0] / j;
        int k1 = aint[1] / j;
        int l1 = aint[2] / j;
        float f3 = (float)i / (float)j;
        float f4 = Math.max(j1, Math.max(k1, l1));
        j1 = (int)((float)j1 * f3 / f4);
        k1 = (int)((float)k1 * f3 / f4);
        l1 = (int)((float)l1 * f3 / f4);
        int j2 = (j1 << 8) + k1;
        j2 = (j2 << 8) + l1;
        MinecraftNBT.setColor(itemstack, j2);
        return itemstack;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack m_8043_() {
        return CapsuleItems.withState(CapsuleItem.CapsuleState.EMPTY);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.m_8020_(i);
            nonnulllist.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return nonnulllist;
    }
}

