package de.larsensmods.mctrains.mixin;

import de.larsensmods.mctrains.interfaces.IChainable;
import de.larsensmods.mctrains.networking.ClientboundSyncMinecartTrainPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1688;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import io.netty.buffer.Unpooled;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3231.class)
public abstract class EntityTrackerEntryMixin {

    @Shadow
    @Final
    private class_1297 entity;

    @Inject(method = "startTracking(Lnet/minecraft/server/network/ServerPlayerEntity;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/Entity;onStartedTrackingBy(Lnet/minecraft/server/network/ServerPlayerEntity;)V"))
    public void minecarttweaks$sendLinkingInitData(class_3222 player, CallbackInfo ci) {
        if(this.entity instanceof class_1688 minecart) {
            // parent -> child
            class_2540 buf1 = new class_2540(Unpooled.buffer());
            new ClientboundSyncMinecartTrainPacket(
                ((IChainable)(Object)minecart).getChainedParent() != null ? ((IChainable)(Object)minecart).getChainedParent().method_5628() : -1,
                entity.method_5628()
            ).write(buf1);
            ServerPlayNetworking.send(player, ClientboundSyncMinecartTrainPacket.ID, buf1);

            // child -> parent
            class_2540 buf2 = new class_2540(Unpooled.buffer());
            new ClientboundSyncMinecartTrainPacket(
                entity.method_5628(),
                ((IChainable)(Object)minecart).getChainedChild() != null ? ((IChainable)(Object)minecart).getChainedChild().method_5628() : -1
            ).write(buf2);
            ServerPlayNetworking.send(player, ClientboundSyncMinecartTrainPacket.ID, buf2);
        }
    }
}