package de.larsensmods.mctrains.mixin;

import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import de.larsensmods.mctrains.interfaces.IChainable;
import net.minecraft.class_1688;
import net.minecraft.class_2398;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_638;
import net.minecraft.class_897;
import net.minecraft.class_925;

@Debug(export = false)
@Mixin(class_925.class)
public abstract class MinecartEntityRendererMixin<T extends class_1688> extends class_897<T> {

    @Unique
    private class_1688 childCart = null;

    protected MinecartEntityRendererMixin(class_5617.class_5618 context) {
        super(context);
    }

    @Inject(method = "render(Lnet/minecraft/entity/vehicle/AbstractMinecartEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V",
            at= @At("HEAD"))
    public void mctrains_updateRenderState(
        T entity,
        float yaw,
        float tickDelta,
        class_4587 matrices,
        class_4597 vertexConsumers,
        int light,
        CallbackInfo ci
    ) {
        try {
            if (entity == null) return;
            class_1688 child = entity;
            class_1688 parent = ((IChainable)(Object)child).getChainedParent();
            if (parent == null) return;
            if (!(child.method_5770() instanceof class_638)) return;
            class_638 world = (class_638) child.method_5770();

            final int FRAME_SKIP = 40;
            final int MAX_STEPS = 6;
            long ticks = class_310.method_1551().field_1705.method_1738();
            if (ticks % FRAME_SKIP != 0) return;

            double sx = parent.method_23317();
            double sy = parent.method_23318() + 0.6;
            double sz = parent.method_23321();
            double ex = child.method_23317();
            double ey = child.method_23318() + 0.6;
            double ez = child.method_23321();

            double dx = ex - sx, dy = ey - sy, dz = ez - sz;
            double distSq = dx*dx + dy*dy + dz*dz;
            if (distSq < 1e-6) return;
            double dist = Math.sqrt(distSq);

            double spacing = Math.max(0.25, dist / MAX_STEPS);
            int steps = Math.min(MAX_STEPS, Math.max(1, (int)Math.ceil(dist / spacing)));

            for (int i = 0; i <= steps; i++) {
                double t = (double)i / (double)steps;
                double px = sx + dx * t;
                double py = sy + dy * t;
                double pz = sz + dz * t;
                try {
                    world.method_8406(class_2398.field_22246, px, py, pz, 0.0, 0.0, 0.0);
                } catch (Throwable e) {
                    world.method_8406(class_2398.field_11240, px, py, pz, 0.0, 0.0, 0.0);
                }
            }
        } catch (Throwable ex) {
            System.out.println("mctrains: updateRenderState particle error: " + ex);
        }
    }

    @Inject(method = "render(Lnet/minecraft/entity/vehicle/AbstractMinecartEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V",
            at = @At("HEAD"))
    public void mctrains_renderHeadParticles(
        T entity,
        float yaw,
        float tickDelta,
        class_4587 matrices,
        class_4597 vertexConsumers,
        int light,
        CallbackInfo ci
    ) {
        try {
            if (entity == null || ((IChainable)(Object)entity).getChainedParent() != null) return;
            if (!(entity.method_5770() instanceof class_638)) return;
            class_638 world = (class_638) entity.method_5770();

            final int FRAME_SKIP_HEAD = 40;
            final int MAX_HEAD_PARTICLES = 6;
            long ticks = class_310.method_1551().field_1705.method_1738();
            if (ticks % FRAME_SKIP_HEAD != 0) return;

            double baseX = entity.method_23317();
            double baseY = entity.method_23318() + 0.8;
            double baseZ = entity.method_23321();

            for (int i = 0; i < MAX_HEAD_PARTICLES; i++) {
                double offsetX = (Math.random() - 0.5) * 0.4;
                double offsetY = (Math.random() - 0.5) * 0.2;
                double offsetZ = (Math.random() - 0.5) * 0.4;
                double px = baseX + offsetX;
                double py = baseY + offsetY;
                double pz = baseZ + offsetZ;

                try {
                    world.method_8406(class_2398.field_17741, px, py, pz, 0.0, 0.0, 0.0);
                } catch (Throwable e) {
                    world.method_8406(class_2398.field_11240, px, py, pz, 0.0, 0.0, 0.0);
                }
            }
        } catch (Throwable ex) {
            System.out.println("mctrains: head particle error: " + ex);
        }
    }
}