/*
 * Decompiled with CFR 0.152.
 */
package de.larsensmods.mctrains;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import de.larsensmods.mctrains.config.MCTConfig;
import de.larsensmods.mctrains.interfaces.IChainable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinecartTrains
implements ModInitializer {
    public static final String MOD_ID = "minecart-trains";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"minecart-trains");
    public static MCTConfig CONFIG;
    private static final String NBT_PARENT_KEY = "minecart_trains:parent_id";
    private static final File FALLBACKS_FILE;
    private static final Gson FALLBACKS_GSON;
    private static final ConcurrentMap<UUID, UUID> PLAYER_PARENT_FALLBACK;

    public void onInitialize() {
        MinecartTrains.loadPersistentFallbacks();
        this.loadOrCreateConfig();
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            if (!(entity instanceof class_1688)) {
                return class_1269.field_5811;
            }
            class_1688 cart = (class_1688)entity;
            class_1799 stack = player.method_5998(hand);
            if (!(player.method_5715() && stack.method_31574(class_1802.field_23983) && CONFIG != null && CONFIG.enableCartChaining())) {
                return class_1269.field_5811;
            }
            if (!(world instanceof class_3218)) {
                return class_1269.field_5812;
            }
            class_3218 server = (class_3218)world;
            UUID stored = MinecartTrains.getStackParent(stack, player);
            if (stored != null && !cart.method_5667().equals(stored)) {
                class_1297 patt2859$temp = server.method_14190(stored);
                if (patt2859$temp instanceof class_1688) {
                    class_1688 nextChainedParent;
                    class_1688 parent = (class_1688)patt2859$temp;
                    HashSet<class_1688> train = new HashSet<class_1688>();
                    train.add(parent);
                    while ((nextChainedParent = parent.getChainedParent()) != null && !train.contains(nextChainedParent)) {
                        train.add(nextChainedParent);
                    }
                    if (train.contains(cart) || parent.getChainedChild() != null) {
                        player.method_7353((class_2561)class_2561.method_43471((String)"minecart-trains.invalid_chaining").method_27692(class_124.field_1061), true);
                    } else {
                        if (cart.getChainedParent() != null) {
                            IChainable.unsetChainedParentChild((IChainable)cart, (IChainable)cart.getChainedParent());
                        }
                        IChainable.setChainedParentChild((IChainable)parent, (IChainable)cart);
                    }
                } else {
                    MinecartTrains.removeStackParent(stack, player);
                }
                world.method_43128(null, cart.method_23317(), cart.method_23318(), cart.method_23321(), class_3417.field_24063, class_3419.field_15254, 1.0f, 1.1f);
                if (!player.method_7337()) {
                    stack.method_7934(1);
                }
                MinecartTrains.removeStackParent(stack, player);
            } else {
                MinecartTrains.setStackParent(stack, cart.method_5667(), player);
                world.method_43128(null, cart.method_23317(), cart.method_23318(), cart.method_23321(), class_3417.field_24062, class_3419.field_15254, 1.0f, 1.1f);
            }
            return class_1269.field_5812;
        });
    }

    private void loadOrCreateConfig() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File configFile = new File("config", "minecart-trains.json");
        boolean createNewConfig = false;
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                CONFIG = (MCTConfig)gson.fromJson((Reader)reader, MCTConfig.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (JsonIOException | JsonSyntaxException e) {
                LOGGER.warn("Error reading config file", e);
                if (!configFile.renameTo(new File("config", "minecart-trains.json.bak"))) {
                    throw new RuntimeException("Couldn't access broken config file, aborting...", e);
                }
                createNewConfig = true;
            }
        } else {
            createNewConfig = true;
        }
        if (createNewConfig) {
            CONFIG = new MCTConfig();
            configFile.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(configFile);){
                gson.toJson((Object)CONFIG, (Appendable)writer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void setStackParent(class_1799 stack, UUID uuid, class_1657 player) {
        class_2487 n;
        if (stack != null && (n = ItemStackNbtRuntime.getOrCreateTag(stack)) != null) {
            n.method_25927(NBT_PARENT_KEY, uuid);
            ItemStackNbtRuntime.setTag(stack, n);
            MinecartTrains.clearPlayerFallback(player);
            System.out.println("mctrains: setStackParent wrote uuid=" + String.valueOf(uuid) + " nbt=" + n.toString());
            return;
        }
        if (player != null) {
            MinecartTrains.savePlayerFallback(player, uuid);
        } else {
            System.out.println("mctrains: setStackParent failed: no stack nbt and no player fallback");
        }
    }

    private static UUID getStackParent(class_1799 stack, class_1657 player) {
        class_2487 n;
        if (stack != null && (n = ItemStackNbtRuntime.getTag(stack)) != null && n.method_10545(NBT_PARENT_KEY)) {
            try {
                return n.method_25926(NBT_PARENT_KEY);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (player != null) {
            UUID mem = (UUID)PLAYER_PARENT_FALLBACK.get(player.method_5667());
            if (mem != null) {
                System.out.println("mctrains: getStackParent returned from memory fallback " + String.valueOf(mem) + " for player " + String.valueOf(player.method_5667()));
                return mem;
            }
            UUID loaded = MinecartTrains.loadPlayerFallback(player);
            if (loaded != null) {
                System.out.println("mctrains: getStackParent returned from persistent fallback " + String.valueOf(loaded) + " for player " + String.valueOf(player.method_5667()));
                return loaded;
            }
        }
        return null;
    }

    private static void removeStackParent(class_1799 stack, class_1657 player) {
        UUID prev;
        class_2487 n;
        boolean removed = false;
        if (stack != null && (n = ItemStackNbtRuntime.getTag(stack)) != null && n.method_10545(NBT_PARENT_KEY)) {
            n.method_10551(NBT_PARENT_KEY);
            if (n.method_33133()) {
                ItemStackNbtRuntime.removeTag(stack);
            } else {
                ItemStackNbtRuntime.setTag(stack, n);
            }
            removed = true;
            System.out.println("mctrains: removeStackParent removed from item");
        }
        if (player != null && (prev = (UUID)PLAYER_PARENT_FALLBACK.remove(player.method_5667())) != null) {
            removed = true;
            MinecartTrains.clearPlayerFallback(player);
            System.out.println("mctrains: removeStackParent removed fallback for player " + String.valueOf(player.method_5667()));
        }
        if (!removed) {
            System.out.println("mctrains: removeStackParent nothing removed");
        }
    }

    private static void loadPersistentFallbacks() {
        block11: {
            try {
                if (!FALLBACKS_FILE.exists()) break block11;
                try (FileReader r = new FileReader(FALLBACKS_FILE);){
                    Type t = new TypeToken<Map<String, String>>(){}.getType();
                    Map m = (Map)FALLBACKS_GSON.fromJson((Reader)r, t);
                    if (m != null) {
                        PLAYER_PARENT_FALLBACK.clear();
                        for (Map.Entry e : m.entrySet()) {
                            try {
                                UUID playerId = UUID.fromString((String)e.getKey());
                                UUID parentId = UUID.fromString((String)e.getValue());
                                PLAYER_PARENT_FALLBACK.put(playerId, parentId);
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
            }
            catch (Throwable ex) {
                LOGGER.warn("mctrains: failed to load fallbacks file", ex);
            }
        }
    }

    private static synchronized void persistFallbacks() {
        try {
            FALLBACKS_FILE.getParentFile().mkdirs();
            try (FileWriter w = new FileWriter(FALLBACKS_FILE);){
                HashMap<String, String> out = new HashMap<String, String>();
                for (Map.Entry e : PLAYER_PARENT_FALLBACK.entrySet()) {
                    out.put(((UUID)e.getKey()).toString(), ((UUID)e.getValue()).toString());
                }
                FALLBACKS_GSON.toJson(out, (Appendable)w);
            }
        }
        catch (Throwable ex) {
            LOGGER.warn("mctrains: failed to persist fallbacks file", ex);
        }
    }

    private static void savePlayerFallback(class_1657 player, UUID parent) {
        PLAYER_PARENT_FALLBACK.put(player.method_5667(), parent);
        MinecartTrains.persistFallbacks();
        LOGGER.debug("mctrains: saved fallback to memory+file for player {} -> {}", (Object)player.method_5667(), (Object)parent);
    }

    private static UUID loadPlayerFallback(class_1657 player) {
        return (UUID)PLAYER_PARENT_FALLBACK.get(player.method_5667());
    }

    private static void clearPlayerFallback(class_1657 player) {
        PLAYER_PARENT_FALLBACK.remove(player.method_5667());
        MinecartTrains.persistFallbacks();
        LOGGER.debug("mctrains: cleared fallback for player {}", (Object)player.method_5667());
    }

    static {
        FALLBACKS_FILE = new File("config", "minecart-trains-fallbacks.json");
        FALLBACKS_GSON = new GsonBuilder().create();
        PLAYER_PARENT_FALLBACK = new ConcurrentHashMap<UUID, UUID>();
    }

    private static final class ItemStackNbtRuntime {
        private static Method methodGetOrCreate = null;
        private static Method methodGet = null;
        private static Method methodHas = null;
        private static Method methodSet = null;
        private static Method methodRemove = null;
        private static boolean initialized = false;

        private ItemStackNbtRuntime() {
        }

        private static void ensureInit() {
            Method[] methods;
            if (initialized) {
                return;
            }
            initialized = true;
            Class<class_1799> cls = class_1799.class;
            for (Method m : methods = cls.getMethods()) {
                try {
                    String name = m.getName().toLowerCase();
                    if (m.getParameterCount() == 0 && m.getReturnType() == class_2487.class) {
                        if (name.contains("getorcreate")) {
                            methodGetOrCreate = m;
                        } else if (methodGet == null && name.contains("get") && (name.contains("tag") || name.contains("nbt") || name.equals("get"))) {
                            methodGet = m;
                        }
                    }
                    if (m.getParameterCount() == 0 && (m.getReturnType() == Boolean.TYPE || m.getReturnType() == Boolean.class) && (name.contains("has") || name.contains("hastag") || name.contains("hasnbt"))) {
                        methodHas = m;
                    }
                    if (m.getParameterCount() == 1 && m.getParameterTypes()[0] == class_2487.class && (name.contains("set") || name.contains("settag") || name.contains("setnbt"))) {
                        methodSet = m;
                    }
                    if (m.getParameterCount() != 0 || m.getReturnType() != Void.TYPE || !name.contains("remove") || !name.contains("nbt") && !name.contains("tag") && !name.equals("remove")) continue;
                    methodRemove = m;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                Method d;
                if (methodSet == null) {
                    d = class_1799.class.getDeclaredMethod("setTag", class_2487.class);
                    d.setAccessible(true);
                    methodSet = d;
                }
                if (methodGetOrCreate == null) {
                    d = class_1799.class.getDeclaredMethod("getOrCreateTag", new Class[0]);
                    d.setAccessible(true);
                    methodGetOrCreate = d;
                }
                if (methodGet == null) {
                    d = class_1799.class.getDeclaredMethod("getTag", new Class[0]);
                    d.setAccessible(true);
                    methodGet = d;
                }
                if (methodHas == null) {
                    d = class_1799.class.getDeclaredMethod("hasTag", new Class[0]);
                    d.setAccessible(true);
                    methodHas = d;
                }
                if (methodRemove == null) {
                    d = class_1799.class.getDeclaredMethod("removeTag", new Class[0]);
                    d.setAccessible(true);
                    methodRemove = d;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public static class_2487 getOrCreateTag(class_1799 stack) {
            ItemStackNbtRuntime.ensureInit();
            try {
                Object r;
                if (methodGetOrCreate != null && (r = methodGetOrCreate.invoke((Object)stack, new Object[0])) instanceof class_2487) {
                    return (class_2487)r;
                }
                if (methodGet != null && (r = methodGet.invoke((Object)stack, new Object[0])) instanceof class_2487) {
                    return (class_2487)r;
                }
                class_2487 n = new class_2487();
                if (methodSet != null) {
                    methodSet.invoke((Object)stack, n);
                    return n;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return null;
        }

        public static class_2487 getTag(class_1799 stack) {
            ItemStackNbtRuntime.ensureInit();
            try {
                Object r;
                if (methodGet != null && (r = methodGet.invoke((Object)stack, new Object[0])) instanceof class_2487) {
                    return (class_2487)r;
                }
                if (methodGetOrCreate != null && (r = methodGetOrCreate.invoke((Object)stack, new Object[0])) instanceof class_2487) {
                    return (class_2487)r;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }

        public static boolean hasTag(class_1799 stack) {
            ItemStackNbtRuntime.ensureInit();
            try {
                Object r;
                if (methodHas != null && (r = methodHas.invoke((Object)stack, new Object[0])) instanceof Boolean) {
                    return (Boolean)r;
                }
                return ItemStackNbtRuntime.getTag(stack) != null;
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        public static void setTag(class_1799 stack, class_2487 tag) {
            ItemStackNbtRuntime.ensureInit();
            try {
                if (methodSet != null) {
                    methodSet.invoke((Object)stack, tag);
                    return;
                }
                try {
                    Method fallback = class_1799.class.getDeclaredMethod("setTag", class_2487.class);
                    fallback.setAccessible(true);
                    fallback.invoke((Object)stack, tag);
                }
                catch (Throwable fallback) {}
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        public static void removeTag(class_1799 stack) {
            ItemStackNbtRuntime.ensureInit();
            try {
                if (methodRemove != null) {
                    methodRemove.invoke((Object)stack, new Object[0]);
                    return;
                }
                if (methodSet != null) {
                    methodSet.invoke((Object)stack, new Object[]{null});
                    return;
                }
                try {
                    Method fallback = class_1799.class.getDeclaredMethod("setTag", class_2487.class);
                    fallback.setAccessible(true);
                    fallback.invoke((Object)stack, new Object[]{null});
                }
                catch (Throwable fallback) {}
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

