package de.larsensmods.mctrains.interfaces;

import net.minecraft.class_1688;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IChainable {
    default @Nullable class_1688 getChainedParent(){
        return null;
    }
    default void setChainedParent(@Nullable class_1688 newParent){}
    default void setClientChainedParent(int entityId){}

    default @Nullable class_1688 getChainedChild(){
        return null;
    }
    default void setChainedChild(@Nullable class_1688 newChild){}
    default void setClientChainedChild(int entityId){}

    default class_1688 getAsAbstractMinecartEntity(){
        return (class_1688) this;
    }

    static void setChainedParentChild(@NotNull IChainable parent, @NotNull IChainable child){
        unsetChainedParentChild(parent, parent.getChainedChild());
        unsetChainedParentChild(child, child.getChainedParent());
        parent.setChainedChild(child.getAsAbstractMinecartEntity());
        child.setChainedParent(parent.getAsAbstractMinecartEntity());
    }

    static void unsetChainedParentChild(@Nullable IChainable parent, @Nullable IChainable child){
        if(parent != null){
            parent.setChainedChild(null);
        }
        if(child != null){
            child.setChainedParent(null);
        }
    }

}
