package de.larsensmods.mctrains.mixin;

import de.larsensmods.mctrains.interfaces.IChainable;
import de.larsensmods.mctrains.networking.ClientboundSyncMinecartTrainPacket;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1688;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_8836;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.UUID;

@Debug(export = false)
@Mixin(class_1688.class)
public abstract class AbstractMinecartEntityMixin extends class_8836 implements IChainable {

    @Unique private @Nullable UUID parentUUID;
    @Unique private @Nullable UUID childUUID;
    @Unique private int parentClientID;
    @Unique private int childClientID;

    public AbstractMinecartEntityMixin(class_1299<?> entityType, class_1937 world) {super(entityType, world);}

    @Inject(method = "tick", at = @At("HEAD"))
    private void mctrains$tick(CallbackInfo info) {
        if (!method_73183().method_8608()) {
            if(getChainedParent() != null) {
                double distance = getChainedParent().method_5739(this) - 1;

                if(distance <= 4) {
                    class_243 directionToParent = getChainedParent().method_73189().method_1020(method_73189()).method_1029();

                    if(distance > 1) {
                        class_243 parentVelocity = getChainedParent().method_18798();

                        if(parentVelocity.method_1033() == 0) {
                            method_18799(directionToParent.method_1021(0.05));
                        } else {
                            method_18799(directionToParent.method_1021(parentVelocity.method_1033()));
                            method_18799(method_18798().method_1021(distance));
                        }
                    } else if(distance < 0.8) {
                        method_18799(directionToParent.method_1021(-0.05));
                    }else {
                        method_18799(class_243.field_1353);
                    }
                } else {
                    IChainable.unsetChainedParentChild(getChainedParent(), this);
                    method_5775((class_3218) method_73183(), new class_1799(class_1802.field_23983));
                    return;
                }

                if(getChainedParent().method_31481()) {
                    IChainable.unsetChainedParentChild(getChainedParent(), this);
                }
            }

            if(getChainedChild() != null && getChainedChild().method_31481()) {
                IChainable.unsetChainedParentChild(this, getChainedChild());
            }

            for(class_1297 otherEntity : method_73183().method_8333(this, method_5829().method_1014(0.1), this::method_30949)) {
                if(otherEntity instanceof class_1688 otherCart && getChainedParent() != null && !otherCart.equals(getChainedChild())) {
                    otherCart.method_18799(method_18798());
                }
            }
        }
    }

    @Override
    public @Nullable class_1688 getChainedParent() {
        class_1297 entity = this.method_73183() instanceof class_3218 sWorld && this.parentUUID != null ? sWorld.method_66347(this.parentUUID) : this.method_73183().method_8469(this.parentClientID);
        return entity instanceof class_1688 minecart ? minecart : null;
    }

    @Override
    public void setChainedParent(@Nullable class_1688 newParent) {
        if(newParent != null) {
            this.parentUUID = newParent.method_5667();
            this.parentClientID = newParent.method_5628();
        } else {
            this.parentUUID = null;
            this.parentClientID = -1;
        }
        if(!this.method_73183().method_8608()) {
            PlayerLookup.tracking(this).forEach(player -> ServerPlayNetworking.send(player, new ClientboundSyncMinecartTrainPacket(getChainedParent() != null ? getChainedParent().method_5628() : -1, method_5628())));
        }
    }

    @Override
    public void setClientChainedParent(int entityId) {
        this.parentClientID = entityId;
    }

    @Override
    public @Nullable class_1688 getChainedChild() {
        class_1297 entity = this.method_73183() instanceof class_3218 sWorld && this.childUUID != null ? sWorld.method_66347(this.childUUID) : this.method_73183().method_8469(this.childClientID);
        return entity instanceof class_1688 minecart ? minecart : null;
    }

    @Override
    public void setChainedChild(@Nullable class_1688 newChild) {
        if(newChild != null) {
            this.childUUID = newChild.method_5667();
            this.childClientID = newChild.method_5628();
        } else {
            this.childUUID = null;
            this.childClientID = -1;
        }
    }

    @Override
    public void setClientChainedChild(int entityId) {
        this.childClientID = entityId;
    }

    //DATA STORAGE NBT
    @Inject(method = "writeCustomData", at = @At("TAIL"))
    public void mctrains$writeData(class_11372 writeView, CallbackInfo ci) {
        writeView.method_71466("ParentUUIDMost", parentUUID != null ? parentUUID.getMostSignificantBits() : 0L);
        writeView.method_71466("ParentUUIDLeast", parentUUID != null ? parentUUID.getLeastSignificantBits() : 0L);

        writeView.method_71466("ChildUUIDMost", childUUID != null ? childUUID.getMostSignificantBits() : 0L);
        writeView.method_71466("ChildUUIDLeast", childUUID != null ? childUUID.getLeastSignificantBits() : 0L);

        writeView.method_71465("ParentClientID", parentClientID);
        writeView.method_71465("ChildClientID", childClientID);
    }

    @Inject(method="readCustomData", at = @At("TAIL"))
    public void mctrains$readData(class_11368 readView, CallbackInfo ci) {
        long parentMost = readView.method_71425("ParentUUIDMost", 0L);
        long parentLeast = readView.method_71425("ParentUUIDLeast", 0L);
        this.parentUUID = (parentMost != 0L || parentLeast != 0L) ? new UUID(parentMost, parentLeast) : null;

        long childMost = readView.method_71425("ChildUUIDMost", 0L);
        long childLeast = readView.method_71425("ChildUUIDLeast", 0L);
        this.childUUID = (childMost != 0L || childLeast != 0L) ? new UUID(childMost, childLeast) : null;

        this.parentClientID = readView.method_71424("ParentClientID", -1);
        this.childClientID = readView.method_71424("ChildClientID", -1);
    }

}
