package de.larsensmods.mctrains.mixin.client;

import net.minecraft.class_10045;
import net.minecraft.class_1688;
import net.minecraft.class_2398;
import net.minecraft.class_310;
import net.minecraft.class_5617;
import net.minecraft.class_638;
import net.minecraft.class_897;
import net.minecraft.class_925;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Debug(export = false)
@Mixin(class_925.class)
public abstract class AbstractMinecartEntityRendererMixin<T extends class_1688, S extends class_10045> extends class_897<T, S> {

    @Unique
    private class_1688 childCart = null;

    protected AbstractMinecartEntityRendererMixin(class_5617.class_5618 context) {super(context);}

    @Inject(method = "Lnet/minecraft/client/render/entity/AbstractMinecartEntityRenderer;updateRenderState(Lnet/minecraft/entity/vehicle/AbstractMinecartEntity;Lnet/minecraft/client/render/entity/state/MinecartEntityRenderState;F)V", at= @At("TAIL"))
    public void mctrains(T abstractMinecartEntity, S minecartEntityRenderState, float f, CallbackInfo ci){
        childCart = abstractMinecartEntity;
    }

    // 此方法放在已验证可命中的 updateRenderState 注入，矿车之间的粒子渲染
    @Inject(method = "Lnet/minecraft/client/render/entity/AbstractMinecartEntityRenderer;updateRenderState(Lnet/minecraft/entity/vehicle/AbstractMinecartEntity;Lnet/minecraft/client/render/entity/state/MinecartEntityRenderState;F)V", at = @At("TAIL"))
    public void mctrains$updateRenderState(
        class_1688 entity,
        class_10045 state,
        float tickDelta,
        CallbackInfo ci
    ) {
        try {
            if (entity == null) return;
            class_1688 child = entity;
            class_1688 parent = child.getChainedParent();
            if (parent == null) return;
            if (!(child.method_73183() instanceof class_638)) return;
            class_638 world = (class_638) child.method_73183();
            
            // 速度与最大数量
            final int FRAME_SKIP = 40;
            final int MAX_STEPS = 6;
            long ticks = class_310.method_1551().field_1705.method_1738();
            if (ticks % FRAME_SKIP != 0) return;

            // 粒子位置
            double sx = parent.method_23317();
            double sy = parent.method_23318() + 0.6;
            double sz = parent.method_23321();
            double ex = child.method_23317();
            double ey = child.method_23318() + 0.6;
            double ez = child.method_23321();

            double dx = ex - sx, dy = ey - sy, dz = ez - sz;
            double distSq = dx*dx + dy*dy + dz*dz;
            if (distSq < 1e-6) return;
            double dist = Math.sqrt(distSq);

            double spacing = Math.max(0.25, dist / MAX_STEPS);
            int steps = Math.min(MAX_STEPS, Math.max(1, (int)Math.ceil(dist / spacing)));

            // 使用 MC 自带的 粒子
            for (int i = 0; i <= steps; i++) {
                double t = (double)i / (double)steps;
                double px = sx + dx * t;
                double py = sy + dy * t;
                double pz = sz + dz * t;
                try {
                    world.method_8406(class_2398.field_22246, px, py, pz, 0.0, 0.0, 0.0);
                } catch (Throwable e) {
                    // 退回到 FLAME 以防某些 mappings 签名不匹配
                    try { world.method_8406(class_2398.field_11240, px, py, pz, 0.0, 0.0, 0.0); }
                    catch (Throwable ignored) { break; }
                }
            }
        } catch (Throwable ex) {
            System.out.println("mctrains: updateRenderState particle error: " + ex);
        }
    }

    // 头车渲染粒子
    @Inject(method = "Lnet/minecraft/client/render/entity/AbstractMinecartEntityRenderer;updateRenderState(Lnet/minecraft/entity/vehicle/AbstractMinecartEntity;Lnet/minecraft/client/render/entity/state/MinecartEntityRenderState;F)V", at = @At("TAIL"))
    public void mctrains$renderHeadParticles(
        class_1688 entity,
        class_10045 state,
        float tickDelta,
        CallbackInfo ci
    ) {
        try {
            if (entity == null || entity.getChainedParent() != null) return;
            if (!(entity.method_73183() instanceof class_638)) return;
            class_638 world = (class_638) entity.method_73183();

            final int FRAME_SKIP_HEAD = 40;         // 每 X 时间刻染一次
            final int MAX_HEAD_PARTICLES = 6;      // 每次最多生成 X 个粒子
            long ticks = class_310.method_1551().field_1705.method_1738();
            if (ticks % FRAME_SKIP_HEAD != 0) return;

            // 粒子位置
            double baseX = entity.method_23317();
            double baseY = entity.method_23318() + 0.8;
            double baseZ = entity.method_23321();

            for (int i = 0; i < MAX_HEAD_PARTICLES; i++) {
                double offsetX = (Math.random() - 0.5) * 0.4;
                double offsetY = (Math.random() - 0.5) * 0.2;
                double offsetZ = (Math.random() - 0.5) * 0.4;
                double px = baseX + offsetX;
                double py = baseY + offsetY;
                double pz = baseZ + offsetZ;

                try {
                    world.method_8406(class_2398.field_17741, px, py, pz, 0.0, 0.0, 0.0);
                } catch (Throwable e) {
                    try { world.method_8406(class_2398.field_11240, px, py, pz, 0.0, 0.0, 0.0); }
                    catch (Throwable ignored) {}
                }
            }
        } catch (Throwable ex) {
            System.out.println("mctrains: head particle error: " + ex);
        }
    }
}
