/*
 * Decompiled with CFR 0.152.
 */
package de.larsensmods.mctrains.mixin;

import de.larsensmods.mctrains.interfaces.IChainable;
import de.larsensmods.mctrains.networking.ClientboundSyncMinecartTrainPacket;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1688;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Debug(export=true)
@Mixin(value={class_1688.class})
public abstract class AbstractMinecartEntityMixin
extends class_1297
implements IChainable {
    @Unique
    @Nullable
    private UUID parentUUID;
    @Unique
    @Nullable
    private UUID childUUID;
    @Unique
    private int parentClientID;
    @Unique
    private int childClientID;

    public AbstractMinecartEntityMixin(class_1299<?> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void mctrains$tick(CallbackInfo info) {
        class_1937 world = this.field_6002;
        if (!world.method_8608()) {
            if (this.getChainedParent() != null) {
                double distance = this.getChainedParent().method_5739((class_1297)this) - 1.0f;
                if (distance <= 4.0) {
                    class_243 directionToParent = this.getChainedParent().method_19538().method_1020(this.method_19538()).method_1029();
                    if (distance > 1.0) {
                        class_243 parentVelocity = this.getChainedParent().method_18798();
                        if (parentVelocity.method_1033() == 0.0) {
                            this.method_18799(directionToParent.method_1021(0.05));
                        } else {
                            this.method_18799(directionToParent.method_1021(parentVelocity.method_1033()));
                            this.method_18799(this.method_18798().method_1021(distance));
                        }
                    } else if (distance < 0.8) {
                        this.method_18799(directionToParent.method_1021(-0.05));
                    } else {
                        this.method_18799(class_243.field_1353);
                    }
                } else {
                    IChainable.unsetChainedParentChild((IChainable)this.getChainedParent(), this);
                    ((class_1688)this).method_5775(new class_1799((class_1935)class_1802.field_23983));
                    return;
                }
                if (this.getChainedParent().method_31481()) {
                    IChainable.unsetChainedParentChild((IChainable)this.getChainedParent(), this);
                }
            }
            if (this.getChainedChild() != null && this.getChainedChild().method_31481()) {
                IChainable.unsetChainedParentChild(this, (IChainable)this.getChainedChild());
            }
            for (class_1297 otherEntity : world.method_8333((class_1297)this, this.method_5829().method_1014(0.1), arg_0 -> ((AbstractMinecartEntityMixin)this).method_30949(arg_0))) {
                if (!(otherEntity instanceof class_1688)) continue;
                class_1688 otherCart = (class_1688)otherEntity;
                if (this.getChainedParent() == null || otherCart.equals((Object)this.getChainedChild())) continue;
                otherCart.method_18799(this.method_18798());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public class_1688 getChainedParent() {
        world = this.field_6002;
        if (!(world instanceof class_3218)) ** GOTO lbl-1000
        sWorld = (class_3218)world;
        if (this.parentUUID != null) {
            v0 = sWorld.method_14190(this.parentUUID);
        } else lbl-1000:
        // 2 sources

        {
            v0 = world.method_8469(this.parentClientID);
        }
        entity = v0;
        return entity instanceof class_1688 != false ? (minecart = (class_1688)entity) : null;
    }

    @Override
    public void setChainedParent(@Nullable class_1688 newParent) {
        if (newParent != null) {
            this.parentUUID = newParent.method_5667();
            this.parentClientID = newParent.method_5628();
        } else {
            this.parentUUID = null;
            this.parentClientID = -1;
        }
        class_1937 world = this.field_6002;
        if (!world.method_8608()) {
            PlayerLookup.tracking((class_1297)this).forEach(player -> {
                class_2540 buf = new class_2540(Unpooled.buffer());
                new ClientboundSyncMinecartTrainPacket(this.getChainedParent() != null ? this.getChainedParent().method_5628() : -1, this.method_5628()).write(buf);
                ServerPlayNetworking.send((class_3222)player, (class_2960)ClientboundSyncMinecartTrainPacket.ID, (class_2540)buf);
            });
        }
    }

    @Override
    public void setClientChainedParent(int entityId) {
        this.parentClientID = entityId;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public class_1688 getChainedChild() {
        world = this.field_6002;
        if (!(world instanceof class_3218)) ** GOTO lbl-1000
        sWorld = (class_3218)world;
        if (this.childUUID != null) {
            v0 = sWorld.method_14190(this.childUUID);
        } else lbl-1000:
        // 2 sources

        {
            v0 = world.method_8469(this.childClientID);
        }
        entity = v0;
        return entity instanceof class_1688 != false ? (minecart = (class_1688)entity) : null;
    }

    @Override
    public void setChainedChild(@Nullable class_1688 newChild) {
        if (newChild != null) {
            this.childUUID = newChild.method_5667();
            this.childClientID = newChild.method_5628();
        } else {
            this.childUUID = null;
            this.childClientID = -1;
        }
    }

    @Override
    public void setClientChainedChild(int entityId) {
        this.childClientID = entityId;
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    public void mctrains$writeData(class_2487 writeView, CallbackInfo ci) {
        writeView.method_10544("ParentUUIDMost", this.parentUUID != null ? this.parentUUID.getMostSignificantBits() : 0L);
        writeView.method_10544("ParentUUIDLeast", this.parentUUID != null ? this.parentUUID.getLeastSignificantBits() : 0L);
        writeView.method_10544("ChildUUIDMost", this.childUUID != null ? this.childUUID.getMostSignificantBits() : 0L);
        writeView.method_10544("ChildUUIDLeast", this.childUUID != null ? this.childUUID.getLeastSignificantBits() : 0L);
        writeView.method_10569("ParentClientID", this.parentClientID);
        writeView.method_10569("ChildClientID", this.childClientID);
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    public void mctrains$readData(class_2487 nbt, CallbackInfo ci) {
        long parentMost = 0L;
        long parentLeast = 0L;
        if (nbt.method_10545("ParentUUIDMost") && nbt.method_10545("ParentUUIDLeast")) {
            parentMost = nbt.method_10537("ParentUUIDMost");
            parentLeast = nbt.method_10537("ParentUUIDLeast");
        }
        this.parentUUID = parentMost != 0L || parentLeast != 0L ? new UUID(parentMost, parentLeast) : null;
        long childMost = 0L;
        long childLeast = 0L;
        if (nbt.method_10545("ChildUUIDMost") && nbt.method_10545("ChildUUIDLeast")) {
            childMost = nbt.method_10537("ChildUUIDMost");
            childLeast = nbt.method_10537("ChildUUIDLeast");
        }
        this.childUUID = childMost != 0L || childLeast != 0L ? new UUID(childMost, childLeast) : null;
        this.parentClientID = nbt.method_10545("ParentClientID") ? nbt.method_10550("ParentClientID") : -1;
        this.childClientID = nbt.method_10545("ChildClientID") ? nbt.method_10550("ChildClientID") : -1;
    }
}

