package de.larsensmods.mctrains.mixin;

import de.larsensmods.mctrains.interfaces.IChainable;
import de.larsensmods.mctrains.networking.ClientboundSyncMinecartTrainPacket;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1688;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_8836;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.UUID;

@Debug(export = true)
@Mixin(class_1688.class)
public abstract class AbstractMinecartEntityMixin extends class_8836 implements IChainable {

    @Unique private @Nullable UUID parentUUID;
    @Unique private @Nullable UUID childUUID;
    @Unique private int parentClientID;
    @Unique private int childClientID;

    public AbstractMinecartEntityMixin(class_1299<?> entityType, class_1937 world) {super(entityType, world);}

    @Inject(method = "tick", at = @At("HEAD"))
    private void mctrains$tick(CallbackInfo info) {
        if (!method_37908().method_8608()) {
            if(getChainedParent() != null) {
                double distance = getChainedParent().method_5739(this) - 1;

                if(distance <= 4) {
                    class_243 directionToParent = getChainedParent().method_19538().method_1020(method_19538()).method_1029();

                    if(distance > 1) {
                        class_243 parentVelocity = getChainedParent().method_18798();

                        if(parentVelocity.method_1033() == 0) {
                            method_18799(directionToParent.method_1021(0.05));
                        } else {
                            method_18799(directionToParent.method_1021(parentVelocity.method_1033()));
                            method_18799(method_18798().method_1021(distance));
                        }
                    } else if(distance < 0.8) {
                        method_18799(directionToParent.method_1021(-0.05));
                    }else {
                        method_18799(class_243.field_1353);
                    }
                } else {
                    IChainable.unsetChainedParentChild(getChainedParent(), this);
                    ((class_1688)(Object)this).method_5775(new class_1799(class_1802.field_23983));
                    return;
                }

                if(getChainedParent().method_31481()) {
                    IChainable.unsetChainedParentChild(getChainedParent(), this);
                }
            }

            if(getChainedChild() != null && getChainedChild().method_31481()) {
                IChainable.unsetChainedParentChild(this, getChainedChild());
            }

            for(class_1297 otherEntity : method_37908().method_8333(this, method_5829().method_1014(0.1), this::method_30949)) {
                if(otherEntity instanceof class_1688 otherCart && getChainedParent() != null && !otherCart.equals(getChainedChild())) {
                    otherCart.method_18799(method_18798());
                }
            }
        }
    }

    @Override
    public @Nullable class_1688 getChainedParent() {
        class_1297 entity = this.method_37908() instanceof class_3218 sWorld && this.parentUUID != null ? sWorld.method_14190(this.parentUUID) : this.method_37908().method_8469(this.parentClientID);
        return entity instanceof class_1688 minecart ? minecart : null;
    }

    @Override
    public void setChainedParent(@Nullable class_1688 newParent) {
        if(newParent != null) {
            this.parentUUID = newParent.method_5667();
            this.parentClientID = newParent.method_5628();
        } else {
            this.parentUUID = null;
            this.parentClientID = -1;
        }
        if(!this.method_37908().method_8608()) {
            PlayerLookup.tracking(this).forEach(player -> ServerPlayNetworking.send(player, new ClientboundSyncMinecartTrainPacket(getChainedParent() != null ? getChainedParent().method_5628() : -1, method_5628())));
        }
    }

    @Override
    public void setClientChainedParent(int entityId) {
        this.parentClientID = entityId;
    }

    @Override
    public @Nullable class_1688 getChainedChild() {
        class_1297 entity = this.method_37908() instanceof class_3218 sWorld && this.childUUID != null ? sWorld.method_14190(this.childUUID) : this.method_37908().method_8469(this.childClientID);
        return entity instanceof class_1688 minecart ? minecart : null;
    }

    @Override
    public void setChainedChild(@Nullable class_1688 newChild) {
        if(newChild != null) {
            this.childUUID = newChild.method_5667();
            this.childClientID = newChild.method_5628();
        } else {
            this.childUUID = null;
            this.childClientID = -1;
        }
    }

    @Override
    public void setClientChainedChild(int entityId) {
        this.childClientID = entityId;
    }

    //DATA STORAGE NBT
    @Inject(method = "writeCustomDataToNbt", at = @At("TAIL"))
    public void mctrains$writeData(class_2487 writeView, CallbackInfo ci) {
        writeView.method_10544("ParentUUIDMost", parentUUID != null ? parentUUID.getMostSignificantBits() : 0L);
        writeView.method_10544("ParentUUIDLeast", parentUUID != null ? parentUUID.getLeastSignificantBits() : 0L);

        writeView.method_10544("ChildUUIDMost", childUUID != null ? childUUID.getMostSignificantBits() : 0L);
        writeView.method_10544("ChildUUIDLeast", childUUID != null ? childUUID.getLeastSignificantBits() : 0L);

        writeView.method_10569("ParentClientID", parentClientID);
        writeView.method_10569("ChildClientID", childClientID);
    }

    // NBT Data Adapted for version 1.21.4
    @Inject(method = "readCustomDataFromNbt", at = @At("TAIL"))
    public void mctrains$readData(class_2487 nbt, CallbackInfo ci) {
        long parentMost = 0L;
        long parentLeast = 0L;
        if (nbt.method_10545("ParentUUIDMost") && nbt.method_10545("ParentUUIDLeast")) {
            parentMost = nbt.method_10537("ParentUUIDMost");
            parentLeast = nbt.method_10537("ParentUUIDLeast");
        }
        this.parentUUID = (parentMost != 0L || parentLeast != 0L) ? new UUID(parentMost, parentLeast) : null;

        long childMost = 0L;
        long childLeast = 0L;
        if (nbt.method_10545("ChildUUIDMost") && nbt.method_10545("ChildUUIDLeast")) {
            childMost = nbt.method_10537("ChildUUIDMost");
            childLeast = nbt.method_10537("ChildUUIDLeast");
        }
        this.childUUID = (childMost != 0L || childLeast != 0L) ? new UUID(childMost, childLeast) : null;

        if (nbt.method_10545("ParentClientID")) this.parentClientID = nbt.method_10550("ParentClientID");
        else this.parentClientID = -1;

        if (nbt.method_10545("ChildClientID")) this.childClientID = nbt.method_10550("ChildClientID");
        else this.childClientID = -1;
    }

}
