package de.larsensmods.mctrains.mixin;

import de.larsensmods.mctrains.networking.ClientboundSyncMinecartTrainPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1688;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3231.class)
public abstract class EntityTrackerEntryMixin {

    @Shadow
    @Final
    private class_1297 entity;

    @Inject(method = "startTracking(Lnet/minecraft/server/network/ServerPlayerEntity;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/Entity;onStartedTrackingBy(Lnet/minecraft/server/network/ServerPlayerEntity;)V"))
    public void minecarttweaks$sendLinkingInitData(class_3222 player, CallbackInfo ci) {
        if(this.entity instanceof class_1688 minecart) {
            ServerPlayNetworking.send(player, new ClientboundSyncMinecartTrainPacket(minecart.getChainedParent() != null ? minecart.getChainedParent().method_5628() : -1, entity.method_5628()));
            ServerPlayNetworking.send(player, new ClientboundSyncMinecartTrainPacket(entity.method_5628(), minecart.getChainedChild() != null ? minecart.getChainedChild().method_5628() : -1));
        }
    }

}
