package de.larsensmods.mctrains.mixin;

import de.larsensmods.mctrains.interfaces.IChainable;
import de.larsensmods.mctrains.networking.ClientboundSyncMinecartTrainPacket;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1688;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import io.netty.buffer.Unpooled;

import java.util.UUID;

@Debug(export = false)
@Mixin(class_1688.class)
public abstract class AbstractMinecartEntityMixin extends class_1297 implements IChainable {

    @Unique private @Nullable UUID parentUUID;
    @Unique private @Nullable UUID childUUID;
    @Unique private int parentClientID = -1;
    @Unique private int childClientID = -1;

    public AbstractMinecartEntityMixin(class_1299<?> entityType, class_1937 world) {
        super(entityType, world);
    }

    // ------------------------
    // tick logic (uses IChainable at compile-time)
    // ------------------------
    @Inject(method = "tick", at = @At("HEAD"))
    private void mctrains$tick(CallbackInfo info) {
        class_1937 world = this.method_37908();
        if (world.method_8608()) return;

        // treat this as IChainable at runtime
        IChainable selfChain = (this instanceof IChainable) ? (IChainable) this : null;
        if (selfChain == null) return;

        IChainable parentChain = selfChain.getChainedParent();
        if (parentChain != null) {
            class_1688 parent = parentChain.asMinecart();
            class_1688 selfMinecart = selfChain.asMinecart();
            if (parent == null || selfMinecart == null) return;

            double distance = parent.method_5739(selfMinecart) - 1;

            if (distance <= 4) {
                class_243 directionToParent = parent.method_19538().method_1020(selfMinecart.method_19538()).method_1029();

                if (distance > 1) {
                    class_243 parentVelocity = parent.method_18798();

                    if (parentVelocity.method_1033() == 0) {
                        selfMinecart.method_18799(directionToParent.method_1021(0.05));
                    } else {
                        selfMinecart.method_18799(directionToParent.method_1021(parentVelocity.method_1033()));
                        selfMinecart.method_18799(selfMinecart.method_18798().method_1021(distance));
                    }
                } else if (distance < 0.8) {
                    selfMinecart.method_18799(directionToParent.method_1021(-0.05));
                } else {
                    selfMinecart.method_18799(class_243.field_1353);
                }
            } else {
                // disconnect and drop chain
                IChainable.unsetChainedParentChild(parentChain, selfChain);
                selfMinecart.method_5775(new class_1799(class_1802.field_23983));
                return;
            }

            class_1297 parentEntity = parentChain.asEntity();
            if (parentEntity == null || parentEntity.method_31481()) {
                IChainable.unsetChainedParentChild(parentChain, selfChain);
            }
        }

        IChainable childChain = selfChain.getChainedChild();
        if (childChain != null) {
            class_1297 childEntity = childChain.asEntity();
            if (childEntity == null || childEntity.method_31481()) {
                IChainable.unsetChainedParentChild(selfChain, childChain);
            }
        }

        // propagate velocity to nearby carts (use Entity methods; adjust getOtherEntities signature by mappings)
        for (class_1297 otherEntity : world.method_8333((class_1297)(Object)this, method_5829().method_1014(0.1), this::method_30949)) {
            if (otherEntity instanceof class_1688 otherCart) {
                IChainable selfParent = selfChain.getChainedParent();
                IChainable selfChild  = selfChain.getChainedChild();
                class_1297 childEntity = (selfChild != null) ? selfChild.asEntity() : null;
                if (selfParent != null && !otherCart.equals(childEntity)) {
                    otherCart.method_18799(((class_1297)(Object)this).method_18798());
                }
            }
        }
    }

    // ------------------------
    // IChainable implementations (interface-level types)
    // ------------------------
    @Override
    public @Nullable IChainable getChainedParent() {
        class_1937 world = this.method_37908();
        class_1297 entity = null;
        try {
            if (world instanceof class_3218 sWorld && this.parentUUID != null) {
                entity = sWorld.method_14190(this.parentUUID);
            } else {
                // defensive: if client or server but uuid absent, try client id
                if (this.parentClientID >= 0) entity = world.method_8469(this.parentClientID);
            }
        } catch (Throwable ignored) {}
        return (entity instanceof IChainable) ? (IChainable) entity : null;
    }

    @Override
    public void setChainedParent(@Nullable IChainable newParent) {
        if (newParent != null) {
            class_1297 e = newParent.asEntity();
            if (e != null) {
                this.parentUUID = e.method_5667();
                // use getEntityId/getId depending on mappings; try to call getEntityId if available
                try { this.parentClientID = e.method_5628(); } catch (Throwable ex) { try { this.parentClientID = e.method_5628(); } catch (Throwable ignored) { this.parentClientID = -1; } }
            } else {
                this.parentUUID = null;
                this.parentClientID = -1;
            }
        } else {
            this.parentUUID = null;
            this.parentClientID = -1;
        }

        class_1937 world = this.method_37908();
        if (!world.method_8608()) {
            PlayerLookup.tracking((class_1297)(Object)this).forEach(player -> {
                class_2540 buf = new class_2540(Unpooled.buffer());
                int parentId = (getChainedParent() != null) ? (getChainedParent().asEntity() != null ? safeGetEntityId(getChainedParent().asEntity()) : -1) : -1;
                int selfId   = safeGetEntityId((class_1297)(Object)this);
                new ClientboundSyncMinecartTrainPacket(parentId, selfId).write(buf);
                ServerPlayNetworking.send(player, ClientboundSyncMinecartTrainPacket.ID, buf);
            });
        }
    }

    @Override
    public void setClientChainedParent(int entityId) {
        this.parentClientID = entityId;
    }

    @Override
    public @Nullable IChainable getChainedChild() {
        class_1937 world = this.method_37908();
        class_1297 entity = null;
        try {
            if (world instanceof class_3218 sWorld && this.childUUID != null) {
                entity = sWorld.method_14190(this.childUUID);
            } else {
                if (this.childClientID >= 0) entity = world.method_8469(this.childClientID);
            }
        } catch (Throwable ignored) {}
        return (entity instanceof IChainable) ? (IChainable) entity : null;
    }

    @Override
    public void setChainedChild(@Nullable IChainable newChild) {
        if (newChild != null) {
            class_1297 e = newChild.asEntity();
            if (e != null) {
                this.childUUID = e.method_5667();
                try { this.childClientID = e.method_5628(); } catch (Throwable ex) { try { this.childClientID = e.method_5628(); } catch (Throwable ignored) { this.childClientID = -1; } }
            } else {
                this.childUUID = null;
                this.childClientID = -1;
            }
        } else {
            this.childUUID = null;
            this.childClientID = -1;
        }
    }

    @Override
    public void setClientChainedChild(int entityId) {
        this.childClientID = entityId;
    }

    // ------------------------
    // IChainable entity accessors
    // ------------------------
    @Override
    public @Nullable class_1297 asEntity() {
        return (class_1297)(Object)this;
    }

    @Override
    public @Nullable class_1688 asMinecart() {
        class_1297 e = asEntity();
        return (e instanceof class_1688) ? (class_1688) e : null;
    }

    // ------------------------
    // NBT persistence hooks (injects)
    // ------------------------
    @Inject(method = "writeCustomDataToNbt", at = @At("TAIL"))
    public void mctrains$writeData(class_2487 writeView, CallbackInfo ci) {
        writeView.method_10544("ParentUUIDMost", parentUUID != null ? parentUUID.getMostSignificantBits() : 0L);
        writeView.method_10544("ParentUUIDLeast", parentUUID != null ? parentUUID.getLeastSignificantBits() : 0L);

        writeView.method_10544("ChildUUIDMost", childUUID != null ? childUUID.getMostSignificantBits() : 0L);
        writeView.method_10544("ChildUUIDLeast", childUUID != null ? childUUID.getLeastSignificantBits() : 0L);

        writeView.method_10569("ParentClientID", parentClientID);
        writeView.method_10569("ChildClientID", childClientID);
    }

    @Inject(method = "readCustomDataFromNbt", at = @At("TAIL"))
    public void mctrains$readData(class_2487 nbt, CallbackInfo ci) {
        long parentMost = 0L;
        long parentLeast = 0L;
        if (nbt.method_10545("ParentUUIDMost") && nbt.method_10545("ParentUUIDLeast")) {
            parentMost = nbt.method_10537("ParentUUIDMost");
            parentLeast = nbt.method_10537("ParentUUIDLeast");
        }
        this.parentUUID = (parentMost != 0L || parentLeast != 0L) ? new UUID(parentMost, parentLeast) : null;

        long childMost = 0L;
        long childLeast = 0L;
        if (nbt.method_10545("ChildUUIDMost") && nbt.method_10545("ChildUUIDLeast")) {
            childMost = nbt.method_10537("ChildUUIDMost");
            childLeast = nbt.method_10537("ChildUUIDLeast");
        }
        this.childUUID = (childMost != 0L || childLeast != 0L) ? new UUID(childMost, childLeast) : null;

        if (nbt.method_10545("ParentClientID")) this.parentClientID = nbt.method_10550("ParentClientID");
        else this.parentClientID = -1;

        if (nbt.method_10545("ChildClientID")) this.childClientID = nbt.method_10550("ChildClientID");
        else this.childClientID = -1;
    }

    // ------------------------
    // Utility: safe get entity id across mappings
    // ------------------------
    @Unique
    private static int safeGetEntityId(@Nullable class_1297 e) {
        if (e == null) return -1;
        try { return e.method_5628(); } catch (Throwable ex) {
            try { return e.method_5628(); } catch (Throwable ignored) { return -1; }
        }
    }
}