package de.larsensmods.mctrains.mixin;

import de.larsensmods.mctrains.interfaces.IChainable;
import de.larsensmods.mctrains.networking.ClientboundSyncMinecartTrainPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1688;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import io.netty.buffer.Unpooled;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3231.class)
public abstract class EntityTrackerEntryMixin {

    @Shadow
    @Final
    private class_1297 entity;

    @Inject(method = "startTracking(Lnet/minecraft/server/network/ServerPlayerEntity;)V",
        at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/Entity;onStartedTrackingBy(Lnet/minecraft/server/network/ServerPlayerEntity;)V"))
    public void minecarttweaks$sendLinkingInitData(class_3222 player, CallbackInfo ci) {
        class_1297 maybe = this.entity;
        if (maybe instanceof class_1688 && maybe instanceof IChainable minecartChain) {
            // 获取 parent/child 的 IChainable 引用（如果存在）
            IChainable parentChain = minecartChain.getChainedParent();
            IChainable childChain  = minecartChain.getChainedChild();

            // 取得对应实体 id（若无法取得实体则用 -1）
            int parentId = -1;
            if (parentChain != null) {
                class_1297 parentEntity = parentChain.asEntity(); // 需要接口实现返回底层实体
                if (parentEntity instanceof class_1688 am) parentId = am.method_5628();
            }

            int childId = -1;
            if (childChain != null) {
                class_1297 childEntity = childChain.asEntity();
                if (childEntity instanceof class_1688 am) childId = am.method_5628();
            }

            // parent -> child
            class_2540 buf1 = new class_2540(Unpooled.buffer());
            new ClientboundSyncMinecartTrainPacket(parentId, maybe.method_5628()).write(buf1);
            ServerPlayNetworking.send(player, ClientboundSyncMinecartTrainPacket.ID, buf1);

            // child -> parent
            class_2540 buf2 = new class_2540(Unpooled.buffer());
            new ClientboundSyncMinecartTrainPacket(maybe.method_5628(), childId).write(buf2);
            ServerPlayNetworking.send(player, ClientboundSyncMinecartTrainPacket.ID, buf2);
        }
}
}