/*
 * Decompiled with CFR 0.152.
 */
package de.larsensmods.mctrains;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.larsensmods.mctrains.config.MCTConfig;
import de.larsensmods.mctrains.interfaces.IChainable;
import de.larsensmods.mctrains.networking.ClientboundSyncMinecartTrainPacket;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1688;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinecartTrains
implements ModInitializer {
    public static final String MOD_ID = "minecart-trains";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"minecart-trains");
    public static MCTConfig CONFIG;
    public static final class_9331<UUID> PARENT_ID;

    public void onInitialize() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File configFile = new File("config", "minecart-trains.json");
        boolean createNewConfig = false;
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                CONFIG = (MCTConfig)gson.fromJson((Reader)reader, MCTConfig.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (JsonIOException | JsonSyntaxException e) {
                LOGGER.warn("Error reading config file", e);
                if (!configFile.renameTo(new File("config", "minecart-trains.json.bak"))) {
                    throw new RuntimeException("Couldn't access broken config file, aborting...", e);
                }
                createNewConfig = true;
            }
        } else {
            createNewConfig = true;
        }
        if (createNewConfig) {
            CONFIG = new MCTConfig();
            configFile.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(configFile);){
                gson.toJson((Object)CONFIG, (Appendable)writer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        PayloadTypeRegistry.playS2C().register(ClientboundSyncMinecartTrainPacket.TYPE, ClientboundSyncMinecartTrainPacket.CODEC);
        class_2378.method_10230((class_2378)class_7923.field_49658, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"parent_id"), PARENT_ID);
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            if (entity instanceof class_1688) {
                class_1688 cart = (class_1688)entity;
                class_1799 stack = player.method_5998(hand);
                if (player.method_5715() && stack.method_31574(class_1802.field_23983) && CONFIG.enableCartChaining()) {
                    if (world instanceof class_3218) {
                        class_3218 server = (class_3218)world;
                        UUID uuid = (UUID)stack.method_58694(PARENT_ID);
                        if (uuid != null && !cart.method_5667().equals(uuid)) {
                            class_1297 patt0$temp = server.method_66347(uuid);
                            if (patt0$temp instanceof class_1688) {
                                class_1688 nextChainedParent;
                                class_1688 parent = (class_1688)patt0$temp;
                                HashSet<class_1688> train = new HashSet<class_1688>();
                                train.add(parent);
                                while ((nextChainedParent = parent.getChainedParent()) != null && !train.contains(nextChainedParent)) {
                                    train.add(nextChainedParent);
                                }
                                if (train.contains(cart) || parent.getChainedChild() != null) {
                                    player.method_7353((class_2561)class_2561.method_43471((String)"minecart-trains.invalid_chaining").method_27692(class_124.field_1061), true);
                                } else {
                                    if (cart.getChainedParent() != null) {
                                        IChainable.unsetChainedParentChild((IChainable)cart, (IChainable)cart.getChainedParent());
                                    }
                                    IChainable.setChainedParentChild((IChainable)parent, (IChainable)cart);
                                }
                            } else {
                                stack.method_57381(PARENT_ID);
                            }
                            world.method_43128(null, cart.method_23317(), cart.method_23318(), cart.method_23321(), class_3417.field_24063, class_3419.field_15254, 1.0f, 1.1f);
                            if (!player.method_68878()) {
                                stack.method_7934(1);
                            }
                            stack.method_57381(PARENT_ID);
                        } else {
                            stack.method_57379(PARENT_ID, (Object)cart.method_5667());
                            world.method_43128(null, cart.method_23317(), cart.method_23318(), cart.method_23321(), class_3417.field_24062, class_3419.field_15254, 1.0f, 1.1f);
                        }
                    }
                    return class_1269.field_5812;
                }
            }
            return class_1269.field_5811;
        });
    }

    static {
        PARENT_ID = class_9331.method_57873().method_57881(RecordCodecBuilder.create(uuidInstance -> uuidInstance.group((App)Codec.LONG.fieldOf("most_sig_bits").forGetter(UUID::getMostSignificantBits), (App)Codec.LONG.fieldOf("least_sig_bits").forGetter(UUID::getLeastSignificantBits)).apply((Applicative)uuidInstance, UUID::new))).method_57882(class_9139.method_56435((class_9139)class_9135.field_48551, UUID::getMostSignificantBits, (class_9139)class_9135.field_48551, UUID::getLeastSignificantBits, UUID::new)).method_57880();
    }
}

