/*
 * Decompiled with CFR 0.152.
 */
package world.anhgelus.architectsland.daycounterenhanced.client;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.minecraft.class_1132;
import net.minecraft.class_2596;
import net.minecraft.class_2799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3445;
import net.minecraft.class_3468;
import net.minecraft.class_638;
import net.minecraft.class_746;
import world.anhgelus.architectsland.daycounterenhanced.Config;
import world.anhgelus.architectsland.daycounterenhanced.DayCounterEnhanced;

@Environment(value=EnvType.CLIENT)
public class DayCounterEnhancedClient
implements ClientModInitializer {
    private long connectedAt = -1L;
    private long timeAlreadyPassed = 0L;
    private boolean firstUpdateDone = false;
    public final class_2960 HUD_ID = class_2960.method_60655((String)"daycounterenhanced", (String)"hud");

    public void onInitializeClient() {
        class_3445 playTimeStat = class_3468.field_15419.method_14956((Object)class_3468.field_15417);
        HudElementRegistry.addLast((class_2960)this.HUD_ID, (context, tickCounter) -> {
            long time;
            if (!class_310.method_1498() || !Config.enabled) {
                return;
            }
            class_310 client = class_310.method_1551();
            if (!Config.displayWhenF3 && client.field_1705 != null && client.method_53526().method_53536()) {
                return;
            }
            class_746 player = client.field_1724;
            class_638 world = client.field_1687;
            if (world == null || player == null) {
                return;
            }
            if (!client.method_1496()) {
                if (!this.firstUpdateDone) {
                    this.timeAlreadyPassed = client.field_1724.method_3143().method_15025(playTimeStat);
                    this.firstUpdateDone = true;
                }
                time = this.timeConnected();
            } else {
                class_1132 server = client.method_1576();
                if (server == null) {
                    return;
                }
                class_3222 serverPlayer = server.method_3760().method_14602(player.method_5667());
                assert (serverPlayer != null);
                serverPlayer.method_14248().method_14914();
                time = serverPlayer.method_14248().method_15025(playTimeStat);
            }
            this.draw(client.field_1772, context, Math.floorDiv(time, 24000) + 1L);
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            if (client.method_1496()) {
                return;
            }
            this.timeAlreadyPassed = 0L;
            DayCounterEnhanced.LOGGER.info("Fetching time passed...");
            handler.method_52787((class_2596)new class_2799(class_2799.class_2800.field_12775));
            this.connectedAt = System.currentTimeMillis();
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            if (client.method_1496()) {
                return;
            }
            if (this.connectedAt == -1L) {
                DayCounterEnhanced.LOGGER.warn("Connected at was not set");
            }
            this.connectedAt = -1L;
            this.timeAlreadyPassed = 0L;
            this.firstUpdateDone = false;
        });
    }

    private void draw(class_327 textRenderer, class_332 context, long day) {
        int x = 5;
        int y = 5;
        int xDecal = 33 + (int)Math.floor(Math.log10(day)) * 5;
        switch (Config.position) {
            case TOP_RIGHT: {
                x = context.method_51421() - xDecal;
                break;
            }
            case BOTTOM_LEFT: {
                y = context.method_51443() - 15;
                break;
            }
            case BOTTOM_RIGHT: {
                x = context.method_51421() - xDecal;
                y = context.method_51443() - 15;
            }
        }
        context.method_25303(textRenderer, "Day " + day, x, y, -1);
    }

    private long timeConnected() {
        return Math.floorDiv(System.currentTimeMillis() - this.connectedAt, 50) + this.timeAlreadyPassed;
    }
}

