/*
 * Decompiled with CFR 0.152.
 */
package local.ytk.questmod;

import com.mojang.brigadier.CommandDispatcher;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import local.ytk.questmod.Util;
import local.ytk.questmod.quests.QuestCommand;
import local.ytk.questmod.quests.QuestData;
import local.ytk.questmod.quests.QuestInstance;
import local.ytk.questmod.quests.QuestList;
import local.ytk.questmod.quests.QuestLoader;
import local.ytk.questmod.quests.QuestPayload;
import local.ytk.questmod.quests.QuestReward;
import local.ytk.questmod.quests.QuestStatus;
import local.ytk.questmod.quests.QuestSubmitPayload;
import local.ytk.questmod.quests.QuestTarget;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleFactory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_274;
import net.minecraft.class_2960;
import net.minecraft.class_2995;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9014;
import net.minecraft.class_9015;
import net.minecraft.class_9020;
import net.minecraft.class_9022;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestMod
implements ModInitializer {
    public static final String MOD_ID = "questmod";
    public static final class_1928.class_4313<class_1928.class_4310> ENABLE_QUESTS = GameRuleRegistry.register((String)"enableQuests", (class_1928.class_5198)class_1928.class_5198.field_24100, (class_1928.class_4314)GameRuleFactory.createBooleanRule((boolean)true));
    public static final class_1928.class_4313<class_1928.class_4310> ENABLE_DEATH_QUESTS = GameRuleRegistry.register((String)"enableDeathQuests", (class_1928.class_5198)class_1928.class_5198.field_24100, (class_1928.class_4314)GameRuleFactory.createBooleanRule((boolean)true));
    public static final class_1928.class_4313<class_1928.class_4310> ENABLE_PVP_QUESTS = GameRuleRegistry.register((String)"enablePvpQuests", (class_1928.class_5198)class_1928.class_5198.field_24100, (class_1928.class_4314)GameRuleFactory.createBooleanRule((boolean)false));
    public static final class_1928.class_4313<class_1928.class_4312> NEW_QUEST_DELAY = GameRuleRegistry.register((String)"newQuestDelay", (class_1928.class_5198)class_1928.class_5198.field_24100, (class_1928.class_4314)GameRuleFactory.createIntRule((int)1200));
    public static final class_6862<class_1792> QUEST_ITEM_TARGET = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)QuestMod.id("quest_item_target"));
    public static final class_6862<class_1792> UNCRAFTABLE = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)QuestMod.id("uncraftable"));
    public static final class_6862<class_1792> KNOWN_CRAFTABLE = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)QuestMod.id("known_craftable"));
    public static final class_6862<class_1792> CREATIVE_ONLY_ITEM = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)QuestMod.id("creative_only"));
    public static final class_6862<class_2248> CREATIVE_ONLY_BLOCK = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)QuestMod.id("creative_only"));
    public static final QuestLoader QUEST_LOADER = new QuestLoader();
    private static final Logger LOGGER = LoggerFactory.getLogger(QuestMod.class);

    public void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTING.register(QuestList::initCraftableItemsIfNeeded);
        ServerLifecycleEvents.START_DATA_PACK_RELOAD.register((server, resourceManager) -> {
            QuestList.initCraftableItemsIfNeeded(server);
            QUEST_LOADER.method_14491((class_3300)resourceManager);
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, access, env) -> QuestCommand.register((CommandDispatcher<class_2168>)dispatcher));
        ServerTickEvents.END_SERVER_TICK.register(QuestMod::createQuestIfNeeded);
        PayloadTypeRegistry.playS2C().register(QuestPayload.PAYLOAD_ID, QuestPayload.PACKET_CODEC);
        PayloadTypeRegistry.playC2S().register(QuestPayload.PAYLOAD_ID, QuestPayload.PACKET_CODEC);
        PayloadTypeRegistry.playC2S().register(QuestSubmitPayload.PAYLOAD_ID, QuestSubmitPayload.PACKET_CODEC);
        ServerPlayNetworking.registerGlobalReceiver(QuestPayload.PAYLOAD_ID, QuestMod::receiveQuestPayload);
        ServerPlayNetworking.registerGlobalReceiver(QuestSubmitPayload.PAYLOAD_ID, QuestMod::receiveQuestSubmitPayload);
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    private static void createQuestIfNeeded(MinecraftServer server) {
        long time = server.method_30002().method_8510();
        QuestData state = QuestData.getServerState(server);
        if (time > state.lastQuestTick + (long)server.method_3767().method_8356(NEW_QUEST_DELAY)) {
            QuestMod.createQuest(server);
            state.lastQuestTick = time;
        }
    }

    private static void receiveQuestPayload(QuestPayload payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        QuestMod.updateQuests(player);
    }

    public static void receiveQuestSubmitPayload(QuestSubmitPayload payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        int id = payload.id();
        QuestMod.completeQuest(player, id, false);
    }

    public static boolean createQuest(MinecraftServer server) {
        if (QUEST_LOADER.questLists() == null) {
            QUEST_LOADER.method_14491(server.method_34864());
        }
        QuestList.initCraftableItemsIfNeeded(server);
        QuestInstance quest = QuestMod.QUEST_LOADER.questMaker.createNewQuest(server);
        if (quest == null) {
            return false;
        }
        QuestMod.createQuestScore(server, quest);
        QuestData.getActiveQuests(server).put(quest.id(), (Object)quest);
        return true;
    }

    public static void updateQuests(class_3222 player) {
        Int2ObjectMap<QuestInstance> quests = QuestData.getActiveQuests(player.method_5682());
        QuestData.PlayerQuestData data = QuestData.getPlayerState((class_1657)player);
        Int2IntMap startingValues = data.questStartingValues();
        ArrayList<QuestStatus> statuses = new ArrayList<QuestStatus>(quests.size());
        IntIterator intIterator = quests.keySet().iterator();
        while (intIterator.hasNext()) {
            int id = (Integer)intIterator.next();
            QuestInstance quest = (QuestInstance)quests.get(id);
            int start = startingValues.get(id);
            QuestTarget type = quest.target();
            int current = QuestMod.getQuestScore(player, id);
            int total = current - start;
            int count = type.count();
            float progress = Math.clamp((float)total / (float)count, 0.0f, 1.0f);
            QuestStatus status = new QuestStatus(quest, total, count, progress);
            statuses.add(status);
        }
        QuestPayload payload = new QuestPayload(statuses);
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
    }

    public static boolean checkQuest(class_3222 player, int id) {
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return false;
        }
        Int2ObjectMap<QuestInstance> activeQuests = QuestData.getActiveQuests(server);
        return QuestMod.getQuestIfComplete(player, id, false, activeQuests) != null;
    }

    public static boolean completeQuest(class_3222 player, int id, boolean noCheck) {
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return false;
        }
        Int2ObjectMap<QuestInstance> activeQuests = QuestData.getActiveQuests(server);
        QuestInstance quest = QuestMod.getQuestIfComplete(player, id, noCheck, activeQuests);
        if (quest == null) {
            return false;
        }
        QuestReward reward = quest.reward();
        player.method_64399(reward.item());
        player.method_7255(reward.xp());
        activeQuests.remove(id);
        class_2561 playerText = player.method_5476();
        class_5250 questText = Util.getQuestName(quest);
        server.method_43496((class_2561)class_2561.method_43469((String)"chat.type.quest", (Object[])new Object[]{playerText, questText}));
        return true;
    }

    @Nullable
    private static QuestInstance getQuestIfComplete(class_3222 player, int id, boolean noCheck, Int2ObjectMap<QuestInstance> activeQuests) {
        QuestData.PlayerQuestData data = QuestData.getPlayerState((class_1657)player);
        int score = QuestMod.getQuestScore(player, id);
        int start = data.questStartingValues().get(id);
        QuestInstance quest = (QuestInstance)activeQuests.get(id);
        if (quest == null) {
            return null;
        }
        int count = quest.target().count();
        if (score - start < count && !noCheck) {
            return null;
        }
        return quest;
    }

    public static void createQuestScore(MinecraftServer server, QuestInstance quest) {
        int id = quest.id();
        String name = "QUESTS.id_" + Integer.toHexString(id);
        class_5250 displayName = Util.getQuestName(quest);
        class_2995 scoreboard = server.method_3845();
        scoreboard.method_1168(name, quest.target().score(), (class_2561)displayName, class_274.class_275.field_1472, false, (class_9022)class_9020.field_47557);
        QuestData.getPlayerData(server).forEach((playerId, data) -> {
            class_3222 player = server.method_3760().method_14602(playerId);
            if (player == null) {
                return;
            }
            data.questStartingValues().put(id, QuestMod.getQuestScore(player, id));
        });
    }

    public static int getQuestScore(class_3222 player, int id) {
        String name = "QUESTS.id_" + Integer.toHexString(id);
        class_269 scoreboard = player.method_7327();
        class_266 nullableObjective = scoreboard.method_1170(name);
        if (nullableObjective == null) {
            MinecraftServer server = player.method_5682();
            if (server == null) {
                LOGGER.error("Could not get server from player {}", (Object)player.method_5477().getString());
                return 0;
            }
            QuestInstance quest = (QuestInstance)QuestData.getActiveQuests(server).get(id);
            QuestMod.createQuestScore(server, quest);
            return 0;
        }
        class_9014 score = scoreboard.method_1180((class_9015)player, nullableObjective);
        return score != null ? score.method_55409() : 0;
    }
}

