/*
 * Decompiled with CFR 0.152.
 */
package local.ytk.questmod;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import local.ytk.questmod.quests.QuestInstance;
import local.ytk.questmod.quests.QuestReward;
import local.ytk.questmod.quests.QuestTarget;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_274;
import net.minecraft.class_2960;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_3468;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger LOGGER = LoggerFactory.getLogger(Util.class);

    public static int getJsonInt(JsonObject json, String key, int defaultValue) {
        JsonPrimitive p;
        JsonElement jsonElement = json.get(key);
        return jsonElement instanceof JsonPrimitive && (p = (JsonPrimitive)jsonElement).isNumber() ? p.getAsInt() : defaultValue;
    }

    public static float getJsonFloat(JsonObject json, String key, float defaultValue) {
        JsonPrimitive p;
        JsonElement jsonElement = json.get(key);
        return jsonElement instanceof JsonPrimitive && (p = (JsonPrimitive)jsonElement).isNumber() ? p.getAsFloat() : defaultValue;
    }

    public static boolean getJsonBoolean(JsonObject json, String key, boolean defaultValue) {
        JsonPrimitive p;
        JsonElement jsonElement = json.get(key);
        return jsonElement instanceof JsonPrimitive && (p = (JsonPrimitive)jsonElement).isBoolean() ? p.getAsBoolean() : defaultValue;
    }

    public static String getJsonString(JsonObject json, String key, String defaultValue) {
        String string;
        JsonElement jsonElement = json.get(key);
        if (jsonElement instanceof JsonPrimitive) {
            JsonPrimitive p = (JsonPrimitive)jsonElement;
            string = p.getAsString();
        } else {
            string = defaultValue;
        }
        return string;
    }

    public static <T> T getAndRemoveRandom(List<T> list, class_5819 random) {
        if (list.isEmpty()) {
            return null;
        }
        int index = random.method_43048(list.size());
        return list.remove(index);
    }

    public static <T> T getWeightedRandom(List<T> list, ToIntFunction<T> weightGetter, class_5819 random) {
        int[] weights = new int[list.size()];
        weights[0] = weightGetter.applyAsInt(list.getFirst());
        for (int i = 1; i < weights.length; ++i) {
            weights[i] = weights[i - 1] + weightGetter.applyAsInt(list.get(i));
        }
        int n = random.method_43048(weights[weights.length - 1]);
        for (int i = 0; i < weights.length; ++i) {
            if (n >= weights[i]) continue;
            return list.get(i);
        }
        return list.getLast();
    }

    public static <T> Optional<T> cast(Object value, Class<T> type) {
        return type.isInstance(value) ? Optional.of(type.cast(value)) : Optional.empty();
    }

    public static <T> Stream<T> castToStream(Object value, Class<T> type) {
        return type.isInstance(value) ? Stream.of(type.cast(value)) : Stream.empty();
    }

    @Nullable
    public static <T> T castOrNull(Object value, Class<T> type) {
        return type.isInstance(value) ? (T)type.cast(value) : null;
    }

    public static <T> Predicate<T> filterEqual(T other) {
        return t -> Objects.equals(t, other);
    }

    public static <T> List<T> filtered(Collection<T> collection, Predicate<T> filter) {
        return collection.stream().filter(filter).toList();
    }

    public static <T> class_2561 getStatName(class_3445<T> stat, int count) {
        class_3448 type = stat.method_14949();
        class_2960 typeId = class_7923.field_41193.method_10221((Object)type);
        if (typeId == null) {
            throw new IllegalStateException("Stat target '" + type.method_30739().getString() + "' has no ID");
        }
        if (type.equals(class_3468.field_15419)) {
            class_2960 statId = (class_2960)stat.method_14951();
            return class_2561.method_43469((String)statId.method_42093("quest.custom"), (Object[])new Object[]{count});
        }
        String typeKey = typeId.method_42093("quest.target");
        class_2378 registry = type.method_14959();
        String prefix = registry.method_46765().method_29177().method_12832();
        if (Objects.equals(prefix, "entity_type")) {
            prefix = "entity";
        }
        class_2960 value = registry.method_10221(stat.method_14951());
        assert (value != null);
        String valueKey = value.method_42093(prefix);
        class_5250 valueText = class_2561.method_43471((String)valueKey);
        return class_2561.method_43469((String)typeKey, (Object[])new Object[]{valueText, count});
    }

    @NotNull
    public static class_2561 getScoreName(class_274 score, int count) {
        if (score instanceof class_3445) {
            class_3445 stat = (class_3445)score;
            return Util.getStatName(stat, count);
        }
        String name = score.method_1225();
        String key = "quest.score." + name;
        return class_2561.method_43469((String)key, (Object[])new Object[]{count});
    }

    @NotNull
    public static class_5250 getQuestName(QuestInstance quest) {
        QuestTarget target = quest.target();
        class_2561 targetText = Util.getScoreName(target.score(), target.count());
        QuestReward reward = quest.reward();
        class_1799 rewardItem = reward.item();
        class_5250 rewardText = class_2561.method_43469((String)"commands.quest.reward", (Object[])new Object[]{rewardItem.method_7947(), rewardItem.method_7954(), reward.xp()});
        return class_2561.method_43469((String)"commands.quest.get", (Object[])new Object[]{quest.id(), targetText, rewardText});
    }
}

