/*
 * Decompiled with CFR 0.152.
 */
package local.ytk.questmod.client.gui;

import java.util.List;
import java.util.function.Supplier;
import local.ytk.questmod.Util;
import local.ytk.questmod.client.QuestModClient;
import local.ytk.questmod.client.gui.QuestListWidget;
import local.ytk.questmod.quests.QuestStatus;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_274;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class QuestListEntry
extends class_4265.class_4266<QuestListEntry> {
    final class_310 client = class_310.method_1551();
    final QuestListWidget container;
    final class_327 textRenderer;
    final class_4185 claimButton;
    final List<class_6379> buttons;
    final List<class_364> elements;
    final class_1735 rewardSlot;
    final QuestStatus quest;
    final int questId;
    final class_274 score;
    final int total;
    final int count;
    final float progress;
    final class_1799 rewardItem;
    final int rewardXp;
    int currentX;
    int currentY;

    public QuestListEntry(QuestStatus quest, QuestListWidget container) {
        this.textRenderer = this.client.field_1772;
        this.container = container;
        this.claimButton = new QuestClaimButtonWidget(140, 4, 50, 20, quest.progress() >= 1.0f);
        this.rewardSlot = new class_1735(null, 0, 0, 0){

            public boolean method_7680(class_1799 stack) {
                return false;
            }

            public boolean method_7674(class_1657 playerEntity) {
                return false;
            }

            public class_1799 method_7677() {
                return QuestListEntry.this.rewardItem;
            }
        };
        this.buttons = List.of(this.claimButton);
        this.elements = List.of(this.claimButton);
        this.quest = quest;
        this.questId = quest.quest().id();
        this.score = quest.quest().target().score();
        this.total = quest.total();
        this.count = quest.count();
        this.progress = quest.progress();
        this.rewardItem = quest.quest().reward().item().method_7972();
        this.rewardXp = quest.quest().reward().xp();
    }

    public List<? extends class_6379> method_37025() {
        return this.buttons;
    }

    public List<? extends class_364> method_25396() {
        return this.elements;
    }

    public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickProgress) {
        this.currentX = x;
        this.currentY = y;
        context.method_49601(x, y, entryWidth, entryHeight, -1);
        class_2561 name = this.getName(this.count);
        context.method_65179(this.textRenderer, (class_5348)name, x + 5, y + 4, 130, -1);
        this.drawReward(context, y, x, entryWidth, entryHeight, mouseX, mouseY);
        this.claimButton.method_25394(context, mouseX, mouseY, tickProgress);
    }

    private void drawReward(class_332 context, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY) {
        int x1 = x + entryWidth - 20;
        int y1 = y + entryHeight / 2 - 9;
        context.method_51427(this.rewardItem, x1, y1);
        context.method_51431(this.textRenderer, this.rewardItem, x1, y1);
        if (mouseX >= x1 - 1 && mouseX < x1 + 16 + 1 && mouseY >= y1 - 1 && mouseY < y1 + 16 + 1) {
            class_1792.class_9635 tooltipContext = class_1792.class_9635.method_59528((class_1937)this.client.field_1687);
            class_1836.class_1837 tooltipType = this.client.field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070;
            List tooltip = this.rewardItem.method_7950(tooltipContext, (class_1657)this.client.field_1724, (class_1836)tooltipType);
            context.method_51437(this.textRenderer, tooltip, this.rewardItem.method_32347(), mouseX, mouseY, (class_2960)this.rewardItem.method_58694(class_9334.field_54198));
        }
    }

    public class_2561 getName(int count) {
        return Util.getScoreName(this.score, count);
    }

    public void claim(class_4185 buttonWidget) {
        if (!buttonWidget.field_22763) {
            return;
        }
        QuestModClient.claimQuest(this.questId);
        this.container.removeEntry(this);
    }

    @Environment(value=EnvType.CLIENT)
    private class QuestClaimButtonWidget
    extends class_4185 {
        final int xOffset;
        final int yOffset;

        public QuestClaimButtonWidget(int x, int y, int w, int h, boolean complete) {
            super(x, y, w, h, (class_2561)class_2561.method_43471((String)"gui.quests.claim"), QuestListEntry.this::claim, Supplier::get);
            this.xOffset = x;
            this.yOffset = y;
            this.field_22763 = complete;
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float deltaTicks) {
            super.method_48579(context, mouseX, mouseY, deltaTicks);
            this.method_48229(this.xOffset + QuestListEntry.this.currentX, this.yOffset + QuestListEntry.this.currentY);
        }
    }
}

