/*
 * Decompiled with CFR 0.152.
 */
package local.ytk.questmod.quests;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.concurrent.CompletableFuture;
import local.ytk.questmod.QuestMod;
import local.ytk.questmod.Util;
import local.ytk.questmod.quests.QuestData;
import local.ytk.questmod.quests.QuestInstance;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class QuestCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"quest").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"create").requires(source -> source.method_9259(2))).executes(QuestCommand::create))).then(class_2170.method_9247((String)"list").executes(QuestCommand::get))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"get").executes(QuestCommand::get)).then(class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer((int)0)).suggests(QuestCommand::getIdSuggestions).executes(QuestCommand::get)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"check").executes(QuestCommand::check)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(source -> source.method_9259(2))).executes(QuestCommand::check)).then(class_2170.method_9247((String)"*").executes(QuestCommand::check))).then(class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer((int)0)).suggests(QuestCommand::getIdSuggestions).executes(QuestCommand::check)))).then(class_2170.method_9247((String)"*").executes(QuestCommand::check))).then(class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer((int)0)).suggests(QuestCommand::getIdSuggestions).executes(QuestCommand::check)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"claim").executes(QuestCommand::claim)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(source -> source.method_9259(2))).executes(QuestCommand::claim)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"*").executes(QuestCommand::claim)).then(class_2170.method_9244((String)"check", (ArgumentType)BoolArgumentType.bool()).executes(QuestCommand::claim)))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer((int)0)).suggests(QuestCommand::getIdSuggestions).executes(QuestCommand::claim)).then(class_2170.method_9244((String)"check", (ArgumentType)BoolArgumentType.bool()).executes(QuestCommand::claim))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"*").executes(QuestCommand::claim)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"check", (ArgumentType)BoolArgumentType.bool()).requires(source -> source.method_9259(2))).executes(QuestCommand::claim)))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer((int)0)).suggests(QuestCommand::getIdSuggestions).executes(QuestCommand::claim)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"check", (ArgumentType)BoolArgumentType.bool()).requires(source -> source.method_9259(2))).executes(QuestCommand::claim))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"id", (ArgumentType)IntegerArgumentType.integer((int)0)).suggests(QuestCommand::getIdSuggestions).executes(QuestCommand::remove)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").requires(source -> source.method_9259(2))).executes(QuestCommand::clear))).then(class_2170.method_9247((String)"menu").executes(QuestCommand::menu)));
    }

    private static int create(CommandContext<class_2168> context) {
        boolean success = QuestMod.createQuest(((class_2168)context.getSource()).method_9211());
        Int2ObjectLinkedOpenHashMap<QuestInstance> activeQuests = QuestData.getServerState((MinecraftServer)((class_2168)context.getSource()).method_9211()).activeQuests;
        QuestInstance quest = (QuestInstance)activeQuests.get(activeQuests.lastIntKey());
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.quest.create", (Object[])new Object[]{Util.getQuestName(quest)}), false);
        return success ? 1 : 0;
    }

    private static int get(CommandContext<class_2168> context) {
        Int2ObjectMap<QuestInstance> activeQuests = QuestCommand.getActiveQuests(context);
        try {
            int id = (Integer)context.getArgument("id", Integer.class);
            QuestInstance quest = (QuestInstance)activeQuests.get(id);
            if (quest == null) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"commands.quest.error", (Object[])new Object[]{id}));
                return 0;
            }
            QuestCommand.getQuest(context, quest);
            return 1;
        }
        catch (Exception e) {
            IntIterator intIterator = activeQuests.keySet().iterator();
            while (intIterator.hasNext()) {
                int id = (Integer)intIterator.next();
                QuestInstance quest = (QuestInstance)activeQuests.get(id);
                QuestCommand.getQuest(context, quest);
            }
            return activeQuests.size();
        }
    }

    private static void getQuest(CommandContext<class_2168> context, QuestInstance quest) {
        class_5250 text = Util.getQuestName(quest);
        ((class_2168)context.getSource()).method_9226(() -> text, false);
    }

    private static int check(CommandContext<class_2168> context) throws CommandSyntaxException {
        int completable = 0;
        try {
            context.getArgument("player", class_3222.class);
        }
        catch (IllegalArgumentException e) {
            ((class_2168)context.getSource()).method_9207();
        }
        try {
            int id = (Integer)context.getArgument("id", Integer.class);
            completable = QuestCommand.check(context, id) ? 1 : 0;
        }
        catch (Exception e) {
            IntIterator intIterator = QuestCommand.getActiveQuests(context).keySet().iterator();
            while (intIterator.hasNext()) {
                int id = (Integer)intIterator.next();
                completable += QuestCommand.check(context, id) ? 1 : 0;
            }
        }
        return completable;
    }

    private static boolean check(CommandContext<class_2168> context, int id) throws CommandSyntaxException {
        class_3222 player;
        QuestInstance quest = (QuestInstance)QuestCommand.getActiveQuests(context).get(id);
        if (quest == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"commands.quest.error", (Object[])new Object[]{id}));
            return false;
        }
        try {
            player = (class_3222)context.getArgument("player", class_3222.class);
        }
        catch (IllegalArgumentException e) {
            player = ((class_2168)context.getSource()).method_9207();
        }
        boolean canComplete = QuestMod.checkQuest(player, id);
        class_5250 text = class_2561.method_43469((String)("commands.quest.check." + canComplete), (Object[])new Object[]{player.method_5477(), Util.getQuestName(quest)});
        ((class_2168)context.getSource()).method_9226(() -> text, false);
        return canComplete;
    }

    private static int claim(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            context.getArgument("player", class_3222.class);
        }
        catch (IllegalArgumentException e) {
            ((class_2168)context.getSource()).method_9207();
        }
        int completed = 0;
        try {
            int id = (Integer)context.getArgument("id", Integer.class);
            completed = QuestCommand.claim(context, id) ? 1 : 0;
        }
        catch (Exception e) {
            IntIterator intIterator = QuestCommand.getActiveQuests(context).keySet().iterator();
            while (intIterator.hasNext()) {
                int id = (Integer)intIterator.next();
                completed += QuestCommand.claim(context, id) ? 1 : 0;
            }
        }
        return completed;
    }

    private static boolean claim(CommandContext<class_2168> context, int id) throws CommandSyntaxException {
        class_3222 player;
        QuestInstance quest = (QuestInstance)QuestCommand.getActiveQuests(context).get(id);
        if (quest == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"commands.quest.error", (Object[])new Object[]{id}));
            return false;
        }
        try {
            player = (class_3222)context.getArgument("player", class_3222.class);
        }
        catch (IllegalArgumentException e) {
            player = ((class_2168)context.getSource()).method_9207();
        }
        boolean check = true;
        try {
            check = (Boolean)context.getArgument("check", Boolean.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        boolean wasClaimed = QuestMod.completeQuest(player, id, !check);
        class_5250 text = class_2561.method_43469((String)("commands.quest.claim." + wasClaimed), (Object[])new Object[]{player.method_5477(), Util.getQuestName(quest)});
        ((class_2168)context.getSource()).method_9226(() -> text, false);
        return wasClaimed;
    }

    private static int remove(CommandContext<class_2168> context) {
        int id = (Integer)context.getArgument("id", Integer.class);
        QuestInstance quest = (QuestInstance)QuestCommand.getActiveQuests(context).remove(id);
        if (quest == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"commands.quest.error", (Object[])new Object[]{id}));
            return 0;
        }
        return 1;
    }

    private static int clear(CommandContext<class_2168> context) {
        QuestCommand.getActiveQuests(context).clear();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.quest.clear"), true);
        return 1;
    }

    private static int menu(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        QuestMod.updateQuests(player);
        return 1;
    }

    private static CompletableFuture<Suggestions> getIdSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        QuestCommand.getActiveQuests(context).keySet().intStream().filter(i -> Integer.toString(i).endsWith(builder.getRemaining())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static Int2ObjectMap<QuestInstance> getActiveQuests(CommandContext<class_2168> context) {
        return QuestData.getActiveQuests(((class_2168)context.getSource()).method_9211());
    }
}

