/*
 * Decompiled with CFR 0.152.
 */
package local.ytk.questmod.quests;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import local.ytk.questmod.quests.QuestInstance;
import net.minecraft.class_10741;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class QuestData
extends class_18 {
    public static final String QUESTS_DATA_ID = "quests";
    public static final Codec<QuestData> CODEC = class_2487.field_25128.xmap(QuestData::fromNbt, QuestData::toNbt);
    private static final class_10741<QuestData> TYPE = new class_10741("quests", QuestData::new, CODEC, null);
    public long lastQuestTick = 0L;
    public int nextQuestId = 1;
    public final Int2ObjectLinkedOpenHashMap<QuestInstance> activeQuests = new Int2ObjectLinkedOpenHashMap();
    public final HashMap<UUID, PlayerQuestData> players = new HashMap();

    public static int getNextQuestId(MinecraftServer server) {
        return QuestData.getServerState((MinecraftServer)server).nextQuestId++;
    }

    public static Int2ObjectMap<QuestInstance> getActiveQuests(MinecraftServer server) {
        return QuestData.getServerState((MinecraftServer)server).activeQuests;
    }

    public static HashMap<UUID, PlayerQuestData> getPlayerData(MinecraftServer server) {
        return QuestData.getServerState((MinecraftServer)server).players;
    }

    public class_2487 writeNbt(class_2487 nbt) {
        class_2487 questListTag = this.activeQuests.int2ObjectEntrySet().stream().flatMap(questEntry -> QuestInstance.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)((QuestInstance)questEntry.getValue())).map(e -> Pair.of((Object)Integer.toHexString(questEntry.getIntKey()), (Object)e)).result().stream()).collect(class_2487::new, (m, p) -> m.method_10566((String)p.getFirst(), (class_2520)p.getSecond()), (a, b) -> b.method_68561((arg_0, arg_1) -> ((class_2487)a).method_10566(arg_0, arg_1)));
        nbt.method_10566(QUESTS_DATA_ID, (class_2520)questListTag);
        class_2487 playerListTag = new class_2487();
        for (UUID uuid : this.players.keySet()) {
            class_2487 playerTag = new class_2487();
            playerTag.method_10566(QUESTS_DATA_ID, (class_2520)this.players.computeIfAbsent(uuid, PlayerQuestData::new).toNbt());
            playerListTag.method_10566(uuid == null ? "PLAYER" : uuid.toString(), (class_2520)playerTag);
        }
        nbt.method_10566("players", (class_2520)playerListTag);
        nbt.method_10569("nextQuestId", this.nextQuestId);
        nbt.method_10544("lastQuestTick", this.lastQuestTick);
        return nbt;
    }

    public class_2487 toNbt() {
        return this.writeNbt(new class_2487());
    }

    public static QuestData fromNbt(class_2487 nbt) {
        QuestData state = new QuestData();
        class_2487 questListTag = nbt.method_68568(QUESTS_DATA_ID);
        for (String key : questListTag.method_10541()) {
            class_2487 compound;
            Optional quest;
            class_2520 element = questListTag.method_10580(key);
            if (!(element instanceof class_2487) || (quest = QuestInstance.CODEC.decode((DynamicOps)class_2509.field_11560, (Object)(compound = (class_2487)element)).map(Pair::getFirst).result()).isEmpty()) continue;
            state.activeQuests.put(Integer.parseUnsignedInt(key, 16), (Object)((QuestInstance)quest.get()));
        }
        class_2487 playerListTag = nbt.method_68568("players");
        for (String key : playerListTag.method_10541()) {
            UUID uuid = key.equals("PLAYER") ? null : UUID.fromString(key);
            class_2487 playerTag = nbt.method_68568(key);
            PlayerQuestData playerState = PlayerQuestData.fromNbt(playerTag);
            state.players.put(uuid, playerState);
        }
        nbt.method_10550("nextQuestId").ifPresent(i -> {
            state.nextQuestId = i;
        });
        nbt.method_10537("lastQuestTick").ifPresent(l -> {
            state.lastQuestTick = l;
        });
        return state;
    }

    public static QuestData getServerState(MinecraftServer server) {
        class_3218 world = server.method_30002();
        QuestData state = (QuestData)world.method_17983().method_17924(TYPE);
        state.method_80();
        return state;
    }

    public static PlayerQuestData getPlayerState(class_1657 player) {
        assert (player != null);
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return new PlayerQuestData(player.method_5667());
        }
        HashMap<UUID, PlayerQuestData> playerData = QuestData.getPlayerData(server);
        PlayerQuestData playerState = playerData.computeIfAbsent(player.method_5667(), uuid -> playerData.computeIfAbsent(null, PlayerQuestData::new));
        if (server.method_3724()) {
            playerData.put(null, playerState);
        }
        return playerState;
    }

    public record PlayerQuestData(Int2IntMap questStartingValues) {
        public PlayerQuestData(UUID uuid) {
            this((Int2IntMap)new Int2IntOpenHashMap());
        }

        public class_2487 toNbt() {
            class_2487 tag = new class_2487();
            this.questStartingValues.forEach((k, v) -> tag.method_10569(Integer.toHexString(k), v.intValue()));
            return tag;
        }

        public static PlayerQuestData fromNbt(class_2487 nbt) {
            Int2IntOpenHashMap questStartingValues = new Int2IntOpenHashMap();
            nbt.method_68561((arg_0, arg_1) -> PlayerQuestData.lambda$fromNbt$1((Int2IntMap)questStartingValues, arg_0, arg_1));
            return new PlayerQuestData((Int2IntMap)questStartingValues);
        }

        private static /* synthetic */ void lambda$fromNbt$1(Int2IntMap questStartingValues, String k, class_2520 v) {
            questStartingValues.put(Integer.parseUnsignedInt(k, 16), v.method_68602().orElse(0).intValue());
        }
    }
}

