/*
 * Decompiled with CFR 0.152.
 */
package local.ytk.questmod.quests;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import local.ytk.questmod.QuestMod;
import local.ytk.questmod.Util;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1839;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_274;
import net.minecraft.class_2960;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_3481;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class QuestList {
    public static final int DEFAULT_WEIGHT = 1000;
    public final class_2960 id;
    int weight;
    static Set<class_1792> craftableItems;
    List<Target<?>> targets = new ArrayList();
    List<Reward> rewards = new ArrayList<Reward>();
    BlockModifiers blockModifiers;
    ItemModifiers itemModifiers;

    public QuestList(class_2960 id) {
        this(id, 1000);
    }

    public QuestList(class_2960 id, int weight) {
        this.id = id;
        this.weight = weight;
    }

    public static void initCraftableItemsIfNeeded(MinecraftServer server) {
        if (craftableItems == null) {
            QuestList.initCraftableItems(server);
        }
    }

    static void initCraftableItems(MinecraftServer server) {
        craftableItems = Stream.concat(server.method_3772().method_8126().stream().map(class_8786::comp_1933).map(recipe -> {
            try {
                return recipe.method_8116(null, null);
            }
            catch (Exception e) {
                return null;
            }
        }).flatMap(Stream::ofNullable).map(class_1799::method_7909), class_7923.field_41178.method_10220().filter(item -> item.method_7854().method_31573(QuestMod.KNOWN_CRAFTABLE))).collect(Collectors.toSet());
    }

    public void addTarget(Target<?> target) {
        this.targets.add(target);
    }

    public void addReward(Reward reward) {
        this.rewards.add(reward);
    }

    public int weight() {
        return this.weight;
    }

    public static QuestList select(Collection<QuestList> lists, class_5819 random) {
        return Util.getWeightedRandom(List.copyOf(lists), QuestList::weight, random);
    }

    @FunctionalInterface
    public static interface TargetFactory<T> {
        public Target<T> create(QuestList var1, class_3448<T> var2, T var3);

        public static <T> class_2960 getId(class_3448<T> statType, T statValue) {
            return statType.method_14959().method_10221(statValue);
        }
    }

    public record ItemModifiers(int commonBase, int common, int uncommonBase, int uncommon, int rareBase, int rare, int epicBase, int epic) {
    }

    public record BlockModifiers(int noTool, int wood, int stone, int iron, int diamond, int value, float hardnessMultiplier) {
        int getBlockToolLevel(class_2248 block) {
            class_2680 state = block.method_9564();
            if (!state.method_29291()) {
                return this.noTool;
            }
            if (state.method_26164(class_3481.field_33717)) {
                return this.diamond;
            }
            if (state.method_26164(class_3481.field_33718)) {
                return this.iron;
            }
            if (state.method_26164(class_3481.field_33719)) {
                return this.stone;
            }
            return this.wood;
        }
    }

    public record Reward(QuestList list, class_1792 item, int base, int value) {
    }

    public static final class EntityTarget
    extends Record
    implements Target<class_1299<?>> {
        private final QuestList list;
        private final class_3448<class_1299<?>> statType;
        private final class_1299<?> statValue;
        private final int base;
        private final int value;

        public EntityTarget(QuestList list, class_3448<class_1299<?>> statType, class_1299<?> statValue, int base, int value) {
            this.list = list;
            this.statType = statType;
            this.statValue = statValue;
            this.base = base;
            this.value = value;
        }

        static boolean canAttackPlayer(class_1299<?> entityType) {
            return true;
        }

        public <T extends class_1297> class_1299<T> castValue() {
            return this.statValue;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{EntityTarget.class, "list;statType;statValue;base;value", "list", "statType", "statValue", "base", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{EntityTarget.class, "list;statType;statValue;base;value", "list", "statType", "statValue", "base", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{EntityTarget.class, "list;statType;statValue;base;value", "list", "statType", "statValue", "base", "value"}, this, o);
        }

        @Override
        public QuestList list() {
            return this.list;
        }

        @Override
        public class_3448<class_1299<?>> statType() {
            return this.statType;
        }

        @Override
        public class_1299<?> statValue() {
            return this.statValue;
        }

        @Override
        public int base() {
            return this.base;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    public static final class ItemTarget
    extends Record
    implements Target<class_1792> {
        private final QuestList list;
        private final class_3448<class_1792> statType;
        private final class_1792 statValue;

        public ItemTarget(QuestList list, class_3448<class_1792> statType, class_1792 statValue) {
            this.list = list;
            this.statType = statType;
            this.statValue = statValue;
        }

        static boolean isCraftable(class_1792 item) {
            return craftableItems.contains(item);
        }

        static boolean isUsable(class_1792 item) {
            class_1799 stack = item.method_7854();
            return stack.method_7963() || stack.method_7976() != class_1839.field_8952 || stack.method_57826(class_9334.field_53964) || stack.method_57826(class_9334.field_50075) || stack.method_57826(class_9334.field_49651) || stack.method_57826(class_9334.field_50077) || stack.method_57826(class_9334.field_55878) || stack.method_57826(class_9334.field_52175) || stack.method_57826(class_9334.field_54274) || stack.method_57826(class_9334.field_53966) || stack.method_31573(QuestMod.QUEST_ITEM_TARGET);
        }

        @Override
        public int base() {
            ItemModifiers modifiers = this.list.itemModifiers;
            return switch (this.statValue.method_7854().method_7932()) {
                default -> throw new MatchException(null, null);
                case class_1814.field_8906 -> modifiers.commonBase;
                case class_1814.field_8907 -> modifiers.uncommonBase;
                case class_1814.field_8903 -> modifiers.rareBase;
                case class_1814.field_8904 -> modifiers.epicBase;
            };
        }

        @Override
        public int value() {
            ItemModifiers modifiers = this.list.itemModifiers;
            return switch (this.statValue.method_7854().method_7932()) {
                default -> throw new MatchException(null, null);
                case class_1814.field_8906 -> modifiers.common;
                case class_1814.field_8907 -> modifiers.uncommon;
                case class_1814.field_8903 -> modifiers.rare;
                case class_1814.field_8904 -> modifiers.epic;
            };
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ItemTarget.class, "list;statType;statValue", "list", "statType", "statValue"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ItemTarget.class, "list;statType;statValue", "list", "statType", "statValue"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ItemTarget.class, "list;statType;statValue", "list", "statType", "statValue"}, this, o);
        }

        @Override
        public QuestList list() {
            return this.list;
        }

        @Override
        public class_3448<class_1792> statType() {
            return this.statType;
        }

        @Override
        public class_1792 statValue() {
            return this.statValue;
        }
    }

    public static final class BlockTarget
    extends Record
    implements Target<class_2248> {
        private final QuestList list;
        private final class_3448<class_2248> statType;
        private final class_2248 statValue;

        public BlockTarget(QuestList list, class_3448<class_2248> statType, class_2248 statValue) {
            this.list = list;
            this.statType = statType;
            this.statValue = statValue;
        }

        @Override
        public int base() {
            return this.list.blockModifiers.getBlockToolLevel(this.statValue);
        }

        @Override
        public int value() {
            BlockModifiers modifiers = this.list.blockModifiers;
            return modifiers.value + (int)Math.ceil(this.statValue.method_36555() * modifiers.hardnessMultiplier);
        }

        static boolean isMineable(class_2248 block) {
            class_2680 state = block.method_9564();
            return !state.method_26164(QuestMod.CREATIVE_ONLY_BLOCK) && block.method_36555() >= 0.0f && !state.method_26227().method_15769();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BlockTarget.class, "list;statType;statValue", "list", "statType", "statValue"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BlockTarget.class, "list;statType;statValue", "list", "statType", "statValue"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BlockTarget.class, "list;statType;statValue", "list", "statType", "statValue"}, this, o);
        }

        @Override
        public QuestList list() {
            return this.list;
        }

        @Override
        public class_3448<class_2248> statType() {
            return this.statType;
        }

        @Override
        public class_2248 statValue() {
            return this.statValue;
        }
    }

    public record BaseTarget<T>(QuestList list, class_3448<T> statType, T statValue, int base, int value, boolean isDeathQuest, boolean isPvpQuest) implements Target<T>
    {
    }

    public record SimpleTarget(QuestList list, class_274 criterion, int base, int value, boolean isDeathQuest, boolean isPvpQuest) implements Target<class_274>
    {
        @Override
        public class_3448<class_274> statType() {
            return null;
        }

        @Override
        public class_274 statValue() {
            return this.criterion;
        }

        @Override
        public String statName() {
            return this.criterion.method_1225();
        }
    }

    public static interface Target<T> {
        public QuestList list();

        public class_3448<T> statType();

        public T statValue();

        public int base();

        public int value();

        default public boolean isDeathQuest() {
            return false;
        }

        default public boolean isPvpQuest() {
            return false;
        }

        default public String statName() {
            return class_3445.method_14950(this.statType(), this.statValue());
        }

        default public Optional<class_274> stat() {
            return class_3445.method_1224((String)this.statName());
        }
    }
}

