/*
 * Decompiled with CFR 0.152.
 */
package local.ytk.questmod.quests;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import local.ytk.questmod.QuestMod;
import local.ytk.questmod.Util;
import local.ytk.questmod.quests.QuestList;
import local.ytk.questmod.quests.QuestMaker;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_274;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3448;
import net.minecraft.class_3468;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestLoader
implements SimpleSynchronousResourceReloadListener {
    public static final Gson GSON = new Gson();
    private static final Logger LOGGER = LoggerFactory.getLogger(QuestLoader.class);
    public static final class_2960 DEFAULT = QuestMod.id("quests/default.json");
    public static class_2960 ID = QuestMod.id("quests");
    Map<class_2960, QuestList> questLists;
    public final QuestMaker questMaker = new QuestMaker();

    public class_2960 getFabricId() {
        return ID;
    }

    public void method_14491(class_3300 manager) {
        Map resources = manager.method_14488("quests", path -> path.method_12832().endsWith(".json"));
        this.questLists = resources.entrySet().stream().map(entry -> this.loadQuestList((class_2960)entry.getKey(), (class_3298)entry.getValue()).map(questList -> Map.entry((class_2960)entry.getKey(), questList))).flatMap(Optional::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Optional<QuestList> loadQuestList(class_2960 id, class_3298 resource) {
        QuestList questList = new QuestList(id);
        try (InputStream stream = resource.method_14482();){
            String content = new String(stream.readAllBytes());
            JsonObject json = (JsonObject)GSON.fromJson(content, JsonObject.class);
            if (json.has("weight")) {
                questList.weight = Util.getJsonInt(json, "weight", 1);
            }
            JsonObject types = json.getAsJsonObject("types");
            QuestLoader.loadQuestTypes(questList, types);
            QuestLoader.loadDefaults(questList, types, json);
            JsonArray rewardsArray = json.getAsJsonArray("rewards");
            for (JsonElement e : rewardsArray.asList()) {
                if (!(e instanceof JsonObject)) continue;
                JsonObject o = (JsonObject)e;
                QuestLoader.createReward(questList, o);
            }
            if (id.equals((Object)DEFAULT)) {
                this.questMaker.reload(json);
            }
        }
        catch (JsonSyntaxException | IOException | ClassCastException e) {
            return Optional.empty();
        }
        return Optional.of(questList);
    }

    private static void createReward(QuestList questList, JsonObject obj) {
        String itemId = Util.getJsonString(obj, "id", null);
        if (itemId == null) {
            return;
        }
        int value = Util.getJsonInt(obj, "value", -1);
        if (value < 0) {
            return;
        }
        class_2960 identifier = class_2960.method_12829((String)itemId);
        if (identifier == null) {
            return;
        }
        Optional item = class_7923.field_41178.method_10223(identifier);
        if (item.isEmpty()) {
            return;
        }
        int base = Util.getJsonInt(obj, "base", 0);
        QuestList.Reward reward = new QuestList.Reward(questList, (class_1792)((class_6880.class_6883)item.get()).comp_349(), base, value);
        questList.addReward(reward);
    }

    private static void loadDefaults(QuestList questList, JsonObject types, JsonObject json) {
        JsonObject killedBy;
        QuestLoader.createBlockList(questList, (class_3448<class_2248>)class_3468.field_15427, QuestList.BlockTarget::isMineable);
        QuestLoader.createItemList(questList, (class_3448<class_1792>)class_3468.field_15370, QuestList.ItemTarget::isCraftable);
        QuestLoader.createItemList(questList, (class_3448<class_1792>)class_3468.field_15372, QuestList.ItemTarget::isUsable);
        JsonObject killed = types.getAsJsonObject("minecraft:killed");
        if (killed != null) {
            QuestLoader.createEntityList(questList, class_3468.field_15403, Util.getJsonInt(killed, "defaultBase", 0), Util.getJsonInt(killed, "default", 0), killed.getAsJsonObject("overrides"));
        }
        if ((killedBy = types.getAsJsonObject("minecraft:killed_by")) != null) {
            QuestLoader.createEntityList(questList, class_3468.field_15411, Util.getJsonInt(killedBy, "defaultBase", 0), Util.getJsonInt(killedBy, "default", 0), killedBy.getAsJsonObject("overrides"), QuestList.EntityTarget::canAttackPlayer);
        }
    }

    private static void loadQuestTypes(QuestList list, JsonObject json) {
        json.asMap().forEach((k, v) -> {
            if (!(v instanceof JsonObject)) {
                return;
            }
            JsonObject obj = (JsonObject)v;
            String selector0$temp = k;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"*mined", "*crafted"}, (Object)selector0$temp, index$1)) {
                case 0: {
                    int noTool = obj.get("noTool").getAsInt();
                    int wood = obj.get("wood").getAsInt();
                    int stone = obj.get("stone").getAsInt();
                    int iron = obj.get("iron").getAsInt();
                    int diamond = obj.get("diamond").getAsInt();
                    int value = obj.get("value").getAsInt();
                    float hardnessMultiplier = obj.get("hardnessMultiplier").getAsFloat();
                    list.blockModifiers = new QuestList.BlockModifiers(noTool, wood, stone, iron, diamond, value, hardnessMultiplier);
                    break;
                }
                case 1: {
                    int commonBase = obj.get("commonBase").getAsInt();
                    int common = obj.get("common").getAsInt();
                    int uncommonBase = obj.get("uncommonBase").getAsInt();
                    int uncommon = obj.get("uncommon").getAsInt();
                    int rareBase = obj.get("rareBase").getAsInt();
                    int rare = obj.get("rare").getAsInt();
                    int epicBase = obj.get("epicBase").getAsInt();
                    int epic = obj.get("epic").getAsInt();
                    list.itemModifiers = new QuestList.ItemModifiers(commonBase, common, uncommonBase, uncommon, rareBase, rare, epicBase, epic);
                    break;
                }
                default: {
                    QuestLoader.loadStatTypeList(list, k, obj);
                }
            }
        });
    }

    public static void loadStatTypeList(QuestList list, String key, JsonObject json) {
        if (!json.has("type")) {
            Optional criterion = class_274.method_1224((String)key);
            if (criterion.isEmpty()) {
                LOGGER.warn("Criterion not found for key '{}'", (Object)key);
                return;
            }
            QuestList.SimpleTarget target = new QuestList.SimpleTarget(list, (class_274)criterion.get(), Util.getJsonInt(json, "base", 0), Util.getJsonInt(json, "value", 0), Util.getJsonBoolean(json, "death", false), Util.getJsonBoolean(json, "pvp", false));
            list.addTarget(target);
            return;
        }
        class_3448 statType = (class_3448)class_7923.field_41193.method_63535(class_2960.method_60654((String)key));
        if (json.has("overrides")) {
            return;
        }
        JsonObject values = json.getAsJsonObject("values");
        if (statType == null) {
            LOGGER.warn("Stat target not found for key '{}'", (Object)key);
            return;
        }
        values.asMap().forEach((k, v) -> {
            if (!(v instanceof JsonObject)) {
                return;
            }
            JsonObject obj = (JsonObject)v;
            Object value = statType.method_14959().method_63535(class_2960.method_60654((String)k));
            list.targets.add(new QuestList.BaseTarget<Object>(list, statType, value, Util.getJsonInt(obj, "base", Integer.MIN_VALUE), Util.getJsonInt(obj, "value", Integer.MIN_VALUE), Util.getJsonBoolean(obj, "death", false), Util.getJsonBoolean(obj, "pvp", false)));
        });
    }

    private static <T> void loadQuestType(QuestList list, class_3448<T> statType, class_2960 id, JsonObject json) {
        Object statValue = statType.method_14959().method_63535(id);
        if (statValue == null) {
            LOGGER.warn("Stat value '{}' not in registry '{}' for target '{}'", new Object[]{id, statType.method_14959().method_46765(), statType.method_30739().getString()});
            return;
        }
        QuestList.BaseTarget<Object> type = new QuestList.BaseTarget<Object>(list, statType, statValue, Util.getJsonInt(json, "base", 0), Util.getJsonInt(json, "value", 0), Util.getJsonBoolean(json, "death", false), Util.getJsonBoolean(json, "pvp", false));
        list.addTarget(type);
    }

    public static void createBlockList(QuestList list, class_3448<class_2248> statType) {
        QuestLoader.createList(list, statType, QuestList.BlockTarget::new);
    }

    public static void createItemList(QuestList list, class_3448<class_1792> statType) {
        QuestLoader.createList(list, statType, QuestList.ItemTarget::new);
    }

    public static void createBlockList(QuestList list, class_3448<class_2248> statType, Predicate<class_2248> filter) {
        QuestLoader.createList(list, statType, QuestList.BlockTarget::new, filter);
    }

    public static void createItemList(QuestList list, class_3448<class_1792> statType, Predicate<class_1792> filter) {
        QuestLoader.createList(list, statType, QuestList.ItemTarget::new, filter);
    }

    public static void createEntityList(QuestList list, class_3448<class_1299<?>> statType, int defaultBase, int defaultValue, JsonObject overrides) {
        QuestLoader.createEntityList(list, statType, defaultBase, defaultValue, overrides, null);
    }

    public static void createEntityList(QuestList list, class_3448<class_1299<?>> statType, int defaultBase, int defaultValue, JsonObject overrides, Predicate<class_1299<?>> filter) {
        QuestLoader.createList(list, statType, (l, t, v) -> {
            class_2960 id = QuestList.TargetFactory.getId(t, v);
            int base = defaultBase;
            int value = defaultValue;
            if (overrides.has(id.toString())) {
                JsonElement patt2$temp;
                JsonPrimitive p;
                JsonElement patt0$temp = overrides.get("exclude");
                if (patt0$temp instanceof JsonPrimitive && (p = (JsonPrimitive)patt0$temp).isBoolean() && p.getAsBoolean()) {
                    return null;
                }
                JsonElement patt1$temp = overrides.get("base");
                if (patt1$temp instanceof JsonPrimitive && (p = (JsonPrimitive)patt1$temp).isNumber()) {
                    base = p.getAsInt();
                }
                if ((patt2$temp = overrides.get("value")) instanceof JsonPrimitive && (p = (JsonPrimitive)patt2$temp).isNumber()) {
                    value = p.getAsInt();
                }
            }
            return new QuestList.EntityTarget(l, (class_3448<class_1299<?>>)t, (class_1299<?>)v, base, value);
        }, filter);
    }

    public static <T> void createList(QuestList list, class_3448<T> statType, QuestList.TargetFactory<T> factory) {
        class_2378 registry = statType.method_14959();
        registry.forEach(value -> {
            QuestList.Target<Object> result = factory.create(list, statType, value);
            if (result == null) {
                return;
            }
            list.addTarget(result);
        });
    }

    public static <T> void createList(QuestList list, class_3448<T> statType, QuestList.TargetFactory<T> factory, Predicate<T> filter) {
        if (filter == null) {
            QuestLoader.createList(list, statType, factory);
            return;
        }
        class_2378 registry = statType.method_14959();
        registry.forEach(value -> {
            if (!filter.test(value)) {
                return;
            }
            QuestList.Target<Object> result = factory.create(list, statType, value);
            if (result == null) {
                return;
            }
            list.addTarget(result);
        });
    }

    public Map<class_2960, QuestList> questLists() {
        return this.questLists;
    }
}

