/*
 * Decompiled with CFR 0.152.
 */
package local.ytk.questmod.quests;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import local.ytk.questmod.QuestMod;
import local.ytk.questmod.Util;
import local.ytk.questmod.quests.QuestData;
import local.ytk.questmod.quests.QuestInstance;
import local.ytk.questmod.quests.QuestList;
import local.ytk.questmod.quests.QuestReward;
import local.ytk.questmod.quests.QuestTarget;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_274;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class QuestMaker {
    public static final class_2960 ID = QuestMod.id("quest_maker");
    private int minStart;
    private float minTimeMod;
    private int minLimit;
    private int maxStart;
    private float maxTimeMod;
    private int maxLimit;
    private int midStart;
    private float midTimeMod;
    private int midLimit;
    private boolean prioritizeCloser;
    private float threshold;
    private float xpMultiplier = 1.0f;
    private int maxCount = 64;
    private float maxShrink = 0.25f;
    private float maxXpRatio = 1.0f;

    public void reload(JsonObject json) {
        JsonObject config = json.getAsJsonObject("config");
        this.minStart = Util.getJsonInt(config, "min", 0);
        this.minTimeMod = Util.getJsonFloat(config, "min_time_mod", 0.0f);
        this.minLimit = Util.getJsonInt(config, "min_limit", 0);
        this.midStart = Util.getJsonInt(config, "mid", 0);
        this.midTimeMod = Util.getJsonFloat(config, "mid_time_mod", 0.0f);
        this.midLimit = Util.getJsonInt(config, "mid_limit", 0);
        this.maxStart = Util.getJsonInt(config, "max", 1);
        this.maxTimeMod = Util.getJsonFloat(config, "max_time_mod", 0.0f);
        this.maxLimit = Util.getJsonInt(config, "max_limit", 0);
        JsonObject targetConfig = json.getAsJsonObject("targetConfig");
        this.prioritizeCloser = Util.getJsonBoolean(targetConfig, "prioritize_closer", true);
        this.threshold = Util.getJsonFloat(targetConfig, "threshold", 0.1f);
        JsonObject rewardConfig = json.getAsJsonObject("rewardConfig");
        this.xpMultiplier = Util.getJsonFloat(rewardConfig, "xp_multiplier", 1.0f);
        this.maxCount = Util.getJsonInt(rewardConfig, "max_count", 64);
        this.maxShrink = Util.getJsonFloat(rewardConfig, "max_shrink", 0.25f);
        this.maxXpRatio = Util.getJsonFloat(rewardConfig, "max_xp_ratio", 1.0f);
    }

    public QuestInstance createNewQuest(MinecraftServer server) {
        boolean enablePvpQuests;
        boolean enableQuests = server.method_3767().method_8355(QuestMod.ENABLE_QUESTS);
        if (!enableQuests) {
            return null;
        }
        long time = server.method_30002().method_8510();
        int value = this.getValue(time);
        class_5819 random = server.method_30002().method_52168().method_51843(ID);
        if (QuestMod.QUEST_LOADER.questLists == null || QuestMod.QUEST_LOADER.questLists.isEmpty()) {
            return null;
        }
        QuestList list = QuestList.select(QuestMod.QUEST_LOADER.questLists.values(), random);
        if (list == null || list.targets.isEmpty() || list.rewards.isEmpty()) {
            return null;
        }
        boolean enableDeathQuests = server.method_3767().method_8355(QuestMod.ENABLE_DEATH_QUESTS);
        QuestTarget target = this.selectTarget(list, value, random, enableDeathQuests, enablePvpQuests = server.method_3767().method_8355(QuestMod.ENABLE_PVP_QUESTS));
        if (target == null) {
            return null;
        }
        QuestReward reward = this.selectReward(list, value, random);
        int id = QuestData.getNextQuestId(server);
        return new QuestInstance(id, target, reward);
    }

    private QuestTarget selectTarget(QuestList list, int value, class_5819 random, boolean enableDeathQuests, boolean enablePvpQuests) {
        Pair pair;
        QuestList.Target targetType;
        Optional<class_274> criterion;
        List<QuestList.Target> validTargets = Util.filtered(list.targets, t -> t.base() + t.value() <= value);
        if (validTargets.isEmpty()) {
            return null;
        }
        ArrayList<Pair> targetValues = new ArrayList<Pair>();
        for (QuestList.Target target : validTargets) {
            if (!enableDeathQuests && target.isDeathQuest() || !enablePvpQuests && target.isPvpQuest()) continue;
            int singleValue = target.value();
            int base = target.base();
            int count = (value - base) / singleValue;
            int actualValue = count * singleValue + base;
            Pair pair2 = Pair.of((Object)target, (Object)actualValue);
            targetValues.add(pair2);
        }
        targetValues.sort(Comparator.comparingInt(a -> Math.abs((Integer)a.getSecond() - value)));
        Predicate<Pair> targetFilter = t -> (float)Math.abs((Integer)t.getSecond() - value) / (float)value <= this.threshold;
        if (!this.prioritizeCloser && targetValues.stream().anyMatch(targetFilter)) {
            targetValues.removeIf(targetFilter.negate());
        } else {
            int minimumValue = (Integer)((Pair)targetValues.getFirst()).getSecond();
            targetValues.removeIf(t -> (Integer)t.getSecond() > minimumValue);
        }
        do {
            pair = (Pair)Util.getAndRemoveRandom(targetValues, random);
            assert (pair != null);
        } while ((criterion = (targetType = (QuestList.Target)pair.getFirst()).stat()).isEmpty());
        return new QuestTarget(criterion.get(), (Integer)pair.getSecond());
    }

    @NotNull
    private QuestReward selectReward(QuestList list, int value, class_5819 random) {
        int rewardValue;
        int rewardCount;
        float actualRewardValue;
        float b;
        List<QuestList.Reward> validRewards = Util.filtered(list.rewards, t -> t.base() + t.value() <= value);
        QuestList.Reward rewardType = (QuestList.Reward)class_156.method_32309(validRewards, (class_5819)random);
        int singleRewardValue = rewardType.value();
        int rewardBase = rewardType.base();
        int rewardMaxCount = (value - rewardBase) / singleRewardValue;
        int actualMaxValue = rewardMaxCount * singleRewardValue + rewardBase;
        float a = (float)actualMaxValue * (1.0f - this.maxShrink);
        int minValue = Math.round(Math.max(a, b = (float)value / (1.0f + this.maxXpRatio)));
        if (minValue > actualMaxValue) {
            minValue = actualMaxValue;
        }
        float xpValue = (actualRewardValue = (float)((rewardCount = Math.clamp((long)(((rewardValue = random.method_39332(minValue, actualMaxValue)) - rewardBase) / singleRewardValue), 1, this.maxCount)) * singleRewardValue + rewardBase)) <= (float)value ? (float)value - actualRewardValue : 0.0f;
        int xp = (int)Math.ceil(xpValue * this.xpMultiplier);
        class_1799 stack = new class_1799((class_1935)rewardType.item(), rewardCount);
        return new QuestReward(stack, xp);
    }

    private int getValue(long time) {
        long timeValue = (long)Math.sqrt(time);
        int min = Math.min(this.minLimit, (int)((float)this.minStart + (float)timeValue * this.minTimeMod));
        int mid = Math.min(this.midLimit, (int)((float)this.midStart + (float)timeValue * this.midTimeMod));
        int max = Math.min(this.maxLimit, (int)((float)this.maxStart + (float)timeValue * this.maxTimeMod));
        return QuestMaker.pickTriangular(min, mid, max);
    }

    private static int pickTriangular(int min, int mode, int max) {
        double value;
        int range;
        int minToMid;
        double f;
        if (min == max) {
            return min;
        }
        if (min > max) {
            int temp = min;
            min = max;
            max = temp;
        }
        mode = Math.clamp((long)mode, min, max);
        double random = Math.random();
        if (random < (f = (double)(minToMid = mode - min) / (double)(range = max - min))) {
            double inc = random * (double)range * (double)minToMid;
            value = (double)min + Math.sqrt(inc);
        } else {
            int midToMax = max - mode;
            double dec = (1.0 - random) * (double)range * (double)midToMax;
            value = (double)max - Math.sqrt(dec);
        }
        return (int)Math.round(value);
    }
}

