/*
 * Decompiled with CFR 0.152.
 */
package crimsonedgehope.minecraft.fabric.socksproxyclient;

import com.google.common.net.InetAddresses;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\u0005\u0010\tJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fR \u0010\u0011\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u0012\u0004\b\u0015\u0010\u0003\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lcrimsonedgehope/minecraft/fabric/socksproxyclient/BaseUtils;", "", "<init>", "()V", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "", "prefix", "(Ljava/lang/String;)Lorg/slf4j/Logger;", "Ljava/net/InetAddress;", "ip", "cidr", "", "isIpInCidr", "(Ljava/net/InetAddress;Ljava/lang/String;)Z", "Ljava/util/concurrent/ScheduledExecutorService;", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "getScheduler", "()Ljava/util/concurrent/ScheduledExecutorService;", "getScheduler$annotations", "SocksProxyClient_base"})
@SourceDebugExtension(value={"SMAP\nBaseUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseUtils.kt\ncrimsonedgehope/minecraft/fabric/socksproxyclient/BaseUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,69:1\n739#2,9:70\n37#3:79\n36#3,3:80\n*S KotlinDebug\n*F\n+ 1 BaseUtils.kt\ncrimsonedgehope/minecraft/fabric/socksproxyclient/BaseUtils\n*L\n33#1:70,9\n33#1:79\n33#1:80,3\n*E\n"})
public final class BaseUtils {
    @NotNull
    public static final BaseUtils INSTANCE = new BaseUtils();
    @Environment(value=EnvType.CLIENT)
    @NotNull
    private static final ScheduledExecutorService scheduler;

    private BaseUtils() {
    }

    @JvmStatic
    @Environment(value=EnvType.CLIENT)
    @NotNull
    public static final Logger getLogger() {
        Logger logger = LoggerFactory.getLogger((String)"SocksProxyClient");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        return logger;
    }

    @JvmStatic
    @Environment(value=EnvType.CLIENT)
    @NotNull
    public static final Logger getLogger(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Logger logger = LoggerFactory.getLogger((String)("SocksProxyClient/" + prefix));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        return logger;
    }

    @NotNull
    public static final ScheduledExecutorService getScheduler() {
        return scheduler;
    }

    @JvmStatic
    public static /* synthetic */ void getScheduler$annotations() {
    }

    @JvmStatic
    @Environment(value=EnvType.CLIENT)
    public static final boolean isIpInCidr(@NotNull InetAddress ip, @NotNull String cidr) {
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        Intrinsics.checkNotNullParameter((Object)cidr, (String)"cidr");
        try {
            int mask;
            byte[] netBytes;
            List list;
            CharSequence charSequence = cidr;
            Regex regex = new Regex("/");
            int n = 0;
            List $this$dropLastWhile$iv = regex.split(charSequence, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] parts = thisCollection$iv.toArray(new String[0]);
            InetAddress network = InetAddresses.forString((String)parts[0]);
            if (network instanceof Inet6Address) {
                return false;
            }
            int prefixLength = Integer.parseInt(parts[1]);
            byte[] ipBytes = ip.getAddress();
            if (ipBytes.length != (netBytes = network.getAddress()).length) {
                return false;
            }
            int fullBytes = prefixLength / 8;
            int remainingBits = prefixLength % 8;
            for (int i = 0; i < fullBytes; ++i) {
                if (ipBytes[i] == netBytes[i]) continue;
                return false;
            }
            return remainingBits <= 0 || (ipBytes[fullBytes] & (mask = 255 << 8 - remainingBits & 0xFF)) == (netBytes[fullBytes] & mask);
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(10);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newScheduledThreadPool(...)");
        scheduler = scheduledExecutorService;
    }
}

