/*
 * Decompiled with CFR 0.152.
 */
package crimsonedgehope.minecraft.fabric.socksproxyclient.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.SocksProxyClientConfig;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.entry.ProxyEntry;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.entry.SocksProxyClientConfigEntry;
import crimsonedgehope.minecraft.fabric.socksproxyclient.socks.SocksVersion;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public final class BaseConfig
extends SocksProxyClientConfig {
    private static final BaseConfig INSTANCE = new BaseConfig();
    public static final String CATEGORY = "base";
    private static final SocksProxyClientConfigEntry<List<ProxyEntry>> proxies = new SocksProxyClientConfigEntry(INSTANCE.getClass(), "proxies", class_2561.method_43471((String)"socksproxyclient.config.base.proxies"), class_2561.method_43471((String)"socksproxyclient.config.base.proxies.tooltip"), new ArrayList());
    private static final SocksProxyClientConfigEntry<List<String>> httpTestSubjects = new SocksProxyClientConfigEntry<1>((Class<SocksProxyClientConfig>)INSTANCE.getClass(), "httpTestSubjects", class_2561.method_43471((String)"socksproxyclient.config.base.proxy.test.httpSubjects"), class_2561.method_43471((String)"socksproxyclient.config.base.proxy.test.httpSubjects.tooltip"), new ArrayList<String>(){
        {
            this.add("https://ipinfo.io");
            this.add("http://connectivitycheck.gstatic.com/generate_204");
        }
    });
    private static final SocksProxyClientConfigEntry<List<String>> minecraftTestSubjects = new SocksProxyClientConfigEntry<2>((Class<SocksProxyClientConfig>)INSTANCE.getClass(), "minecraftTestSubjects", class_2561.method_43471((String)"socksproxyclient.config.base.proxy.test.minecraftSubjects"), class_2561.method_43469((String)"socksproxyclient.config.base.proxy.test.minecraftSubjects.tooltip", (Object[])new Object[]{class_2561.method_43471((String)"socksproxyclient.config.proxy.proxyMinecraft")}), new ArrayList<String>(){
        {
            this.add("play.cubecraft.net");
        }
    });

    public BaseConfig() {
        super("base.json");
    }

    @Override
    public JsonObject defaultEntries() {
        JsonObject obj = new JsonObject();
        JsonArray proxyJsonArray = new JsonArray();
        proxies.getDefaultValue().forEach(entry -> {
            JsonObject proxyObj = new JsonObject();
            proxyObj.addProperty("version", entry.getVersion().name());
            proxyObj.addProperty("host", ((InetSocketAddress)entry.getProxy().address()).getHostString());
            proxyObj.addProperty("port", (Number)((InetSocketAddress)entry.getProxy().address()).getPort());
            proxyObj.addProperty("username", entry.getSocksProxyCredential().getUsername());
            proxyObj.addProperty("password", entry.getSocksProxyCredential().getPassword());
            proxyJsonArray.add((JsonElement)proxyObj);
        });
        obj.add(proxies.getJsonEntry(), (JsonElement)proxyJsonArray);
        JsonArray httpTestSubjectJsonArray = new JsonArray();
        httpTestSubjects.getDefaultValue().forEach(arg_0 -> ((JsonArray)httpTestSubjectJsonArray).add(arg_0));
        obj.add(httpTestSubjects.getJsonEntry(), (JsonElement)httpTestSubjectJsonArray);
        JsonArray minecraftTestSubjectJsonArray = new JsonArray();
        minecraftTestSubjects.getDefaultValue().forEach(arg_0 -> ((JsonArray)minecraftTestSubjectJsonArray).add(arg_0));
        obj.add(minecraftTestSubjects.getJsonEntry(), (JsonElement)minecraftTestSubjectJsonArray);
        return obj;
    }

    @Override
    public void fromJsonObject(JsonObject entries) {
        ArrayList<ProxyEntry> proxyEntryArrayList = new ArrayList<ProxyEntry>();
        JsonArray array = (JsonArray)entries.get(proxies.getJsonEntry());
        for (JsonElement element : array) {
            String password;
            String username;
            int port;
            SocksVersion version;
            JsonObject proxyObj = (JsonObject)element;
            try {
                version = SocksVersion.valueOf(proxyObj.get("version").getAsString());
            }
            catch (Exception e) {
                version = SocksVersion.SOCKS5;
            }
            String host = proxyObj.get("host").getAsString();
            if (host == null) {
                host = "localhost";
            }
            try {
                port = proxyObj.get("port").getAsInt();
            }
            catch (Exception e) {
                port = 1080;
            }
            try {
                username = proxyObj.get("username").getAsString();
            }
            catch (Exception e) {
                username = null;
            }
            try {
                password = proxyObj.get("password").getAsString();
            }
            catch (Exception e) {
                password = null;
            }
            proxyEntryArrayList.add(new ProxyEntry(version, new InetSocketAddress(host, port), username, password));
        }
        proxies.setValue(proxyEntryArrayList);
        ArrayList<String> httpTestSubjectArrayList = new ArrayList<String>();
        array = (JsonArray)entries.get(httpTestSubjects.getJsonEntry());
        for (JsonElement element : array) {
            httpTestSubjectArrayList.add(element.getAsString());
        }
        httpTestSubjects.setValue(httpTestSubjectArrayList);
        ArrayList<String> minecraftTestSubjectArrayList = new ArrayList<String>();
        array = (JsonArray)entries.get(minecraftTestSubjects.getJsonEntry());
        for (JsonElement element : array) {
            minecraftTestSubjectArrayList.add(element.getAsString());
        }
        minecraftTestSubjects.setValue(minecraftTestSubjectArrayList);
    }

    @Override
    public JsonObject toJsonObject() {
        JsonObject obj = new JsonObject();
        JsonArray proxyJsonArray = new JsonArray();
        proxies.getValue().forEach(entry -> {
            JsonObject proxyObj = new JsonObject();
            proxyObj.addProperty("version", entry.getVersion().name());
            proxyObj.addProperty("host", ((InetSocketAddress)entry.getProxy().address()).getHostString());
            proxyObj.addProperty("port", (Number)((InetSocketAddress)entry.getProxy().address()).getPort());
            proxyObj.addProperty("username", entry.getSocksProxyCredential().getUsername());
            proxyObj.addProperty("password", entry.getSocksProxyCredential().getPassword());
            proxyJsonArray.add((JsonElement)proxyObj);
        });
        obj.add(proxies.getJsonEntry(), (JsonElement)proxyJsonArray);
        JsonArray httpTestSubjectJsonArray = new JsonArray();
        httpTestSubjects.getValue().forEach(arg_0 -> ((JsonArray)httpTestSubjectJsonArray).add(arg_0));
        obj.add(httpTestSubjects.getJsonEntry(), (JsonElement)httpTestSubjectJsonArray);
        JsonArray minecraftTestSubjectJsonArray = new JsonArray();
        minecraftTestSubjects.getValue().forEach(arg_0 -> ((JsonArray)minecraftTestSubjectJsonArray).add(arg_0));
        obj.add(minecraftTestSubjects.getJsonEntry(), (JsonElement)minecraftTestSubjectJsonArray);
        return obj;
    }

    public static List<ProxyEntry> getProxyEntries() {
        return List.copyOf((Collection)proxies.getValue());
    }

    public static List<String> getHTTPTestSubjects() {
        return List.copyOf((Collection)httpTestSubjects.getValue());
    }

    public static List<String> getMinecraftTestSubjects() {
        return List.copyOf((Collection)minecraftTestSubjects.getValue());
    }
}

