/*
 * Decompiled with CFR 0.152.
 */
package crimsonedgehope.minecraft.fabric.socksproxyclient.config.yacl;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import crimsonedgehope.minecraft.fabric.socksproxyclient.BaseUtils;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.BaseConfig;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.ConfigUtils;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.ProxyConfig;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.entry.ProxyEntry;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.entry.SocksProxyClientConfigEntry;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.yacl.YACLAccess;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.yacl.YACLCategory;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.yacl.controller.ProxyEntryControllerBuilder;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.yacl.controller.ValidStringControllerBuilder;
import crimsonedgehope.minecraft.fabric.socksproxyclient.http.HttpUtils;
import crimsonedgehope.minecraft.fabric.socksproxyclient.injection.MixinUtilsYacl;
import crimsonedgehope.minecraft.fabric.socksproxyclient.screen.ProxyEntryEditScreen;
import crimsonedgehope.minecraft.fabric.socksproxyclient.socks.SocksSelection;
import crimsonedgehope.minecraft.fabric.socksproxyclient.socks.SocksVersion;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.gui.YACLScreen;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_437;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.util.TriConsumer;

@Environment(value=EnvType.CLIENT)
public final class BaseConfigCategory
extends YACLCategory<BaseConfig> {
    private SocksProxyClientConfigEntry<List> proxies;
    private SocksProxyClientConfigEntry<List> httpTestSubjects;
    private SocksProxyClientConfigEntry<List> minecraftTestSubjects;
    private static Long testTime = 0L;

    public BaseConfigCategory() {
        this(null);
    }

    public BaseConfigCategory(YACLAccess yacl) {
        super(yacl, BaseConfig.class);
    }

    @Override
    public ConfigCategory buildConfigCategory() throws Exception {
        ConfigCategory.Builder categoryBuilder = ConfigCategory.createBuilder();
        categoryBuilder.name((class_2561)class_2561.method_43471((String)"socksproxyclient.config.base"));
        this.proxies = this.entryField("proxies", List.class);
        ListOption yaclProxies = ListOption.createBuilder().name((class_2561)this.proxies.getEntryTranslateKey()).description(OptionDescription.of((class_2561[])new class_2561[]{this.proxies.getDescriptionTranslateKey()})).initial((Object)new ProxyEntry(SocksVersion.SOCKS5, InetSocketAddress.createUnresolved("127.0.0.1", 1080))).binding(this.proxies.getDefaultValue(), this.proxies::getValue, this.proxies::setValue).collapsed(false).controller(opt -> ProxyEntryControllerBuilder.create((Option<ProxyEntry>)((Option)opt)).action((TriConsumer<YACLScreen, ProxyEntry, Runnable>)((TriConsumer)(screen, entry, callback) -> class_310.method_1551().method_1507((class_437)new ProxyEntryEditScreen((class_437)screen, (ProxyEntry)entry, (Runnable)callback))))).insertEntriesAtEnd(true).build();
        categoryBuilder.group((OptionGroup)yaclProxies);
        OptionGroup.Builder proxyGroupBuilder = OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"socksproxyclient.config.base.proxy"));
        ButtonOption yaclTestReachability = ButtonOption.createBuilder().name((class_2561)class_2561.method_43471((String)"socksproxyclient.config.base.proxy.test")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"socksproxyclient.config.base.proxy.test.tooltip")})).available(true).action((screen, opt) -> BaseConfigCategory.testProxy()).build();
        this.httpTestSubjects = this.entryField("httpTestSubjects", List.class);
        ListOption yaclHTTPTestSubjects = ListOption.createBuilder().name((class_2561)this.httpTestSubjects.getEntryTranslateKey()).description(OptionDescription.of((class_2561[])new class_2561[]{this.httpTestSubjects.getDescriptionTranslateKey()})).initial((Object)"").binding(this.httpTestSubjects.getDefaultValue(), this.httpTestSubjects::getValue, this.httpTestSubjects::setValue).collapsed(false).controller(opt -> StringControllerBuilder.create((Option)((Option)opt))).insertEntriesAtEnd(true).build();
        this.minecraftTestSubjects = this.entryField("minecraftTestSubjects", List.class);
        ListOption yaclMinecraftTestSubjects = ListOption.createBuilder().name((class_2561)this.minecraftTestSubjects.getEntryTranslateKey()).description(OptionDescription.of((class_2561[])new class_2561[]{this.minecraftTestSubjects.getDescriptionTranslateKey()})).initial((Object)"").binding(this.minecraftTestSubjects.getDefaultValue(), this.minecraftTestSubjects::getValue, this.minecraftTestSubjects::setValue).collapsed(false).controller(opt -> ValidStringControllerBuilder.create((Option<String>)((Option)opt)).validityPredication(ConfigUtils.minecraftAddressValidity)).insertEntriesAtEnd(true).build();
        if (this.proxies.getValue().isEmpty()) {
            yaclTestReachability.setAvailable(false);
            yaclHTTPTestSubjects.setAvailable(false);
            yaclMinecraftTestSubjects.setAvailable(false);
        } else {
            yaclTestReachability.setAvailable(true);
            yaclHTTPTestSubjects.setAvailable(true);
            yaclMinecraftTestSubjects.setAvailable(true);
        }
        yaclProxies.addListener((opt, v) -> {
            boolean b = v.isEmpty();
            if (b) {
                yaclTestReachability.setAvailable(false);
                yaclHTTPTestSubjects.setAvailable(false);
                yaclMinecraftTestSubjects.setAvailable(false);
            } else {
                yaclTestReachability.setAvailable(true);
                yaclHTTPTestSubjects.setAvailable(true);
                yaclMinecraftTestSubjects.setAvailable(true);
            }
        });
        proxyGroupBuilder.option((Option)yaclTestReachability);
        categoryBuilder.group(proxyGroupBuilder.build());
        categoryBuilder.group((OptionGroup)yaclHTTPTestSubjects);
        categoryBuilder.group((OptionGroup)yaclMinecraftTestSubjects);
        return categoryBuilder.build();
    }

    private static void testProxy() {
        if (System.currentTimeMillis() - testTime <= 5000L) {
            ConfigUtils.LOGGER.warn("NO TEST SPAMMING");
            return;
        }
        testTime = System.currentTimeMillis();
        List<String> httpSubjects = BaseConfig.getHTTPTestSubjects();
        for (String url : httpSubjects) {
            BaseUtils.getScheduler().submit(() -> BaseConfigCategory.testHTTP(url));
        }
        List<String> minecraftSubjects = BaseConfig.getMinecraftTestSubjects();
        for (String address : minecraftSubjects) {
            BaseUtils.getScheduler().submit(() -> BaseConfigCategory.testMinecraftPing(address));
        }
    }

    private static void testMinecraftPing(String target) {
        if (!ProxyConfig.shouldProxyMinecraft()) {
            return;
        }
        if (SocksSelection.filter.apply(target).booleanValue()) {
            ConfigUtils.LOGGER.warn("{} is in opt out list.", (Object)target);
            return;
        }
        try {
            BaseConfigCategory.showTestStart(target);
            MixinUtilsYacl.triggerPing(target, true, entry -> {
                BaseConfigCategory.showTestResult((class_3545<Boolean, Throwable>)new class_3545((Object)true, null), entry.field_3761);
                ConfigUtils.LOGGER.info("Pinged {}: Ping {}ms\n Version: {}\n Protocol version: {}\n Player count: {}", new Object[]{entry.field_3761, entry.field_3758, entry.field_3760.method_54160(), entry.field_3756, entry.field_3753.getString()});
            }, entry -> BaseConfigCategory.showTestResult((class_3545<Boolean, Throwable>)new class_3545((Object)false, null), entry.field_3761));
        }
        catch (Exception e) {
            BaseConfigCategory.showTestResult((class_3545<Boolean, Throwable>)new class_3545((Object)false, (Object)new RuntimeException("Failed to ping!", e)), target);
        }
    }

    private static void testHTTP(String target) {
        BaseConfigCategory.showTestStart(target);
        CompletableFuture<class_3545<Boolean, Throwable>> test = BaseConfigCategory.testHTTPFuture(target);
        BaseConfigCategory.showTestResult(test, target);
    }

    public static CompletableFuture<class_3545<Boolean, Throwable>> testHTTPFuture(String target) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                URL url = URI.create(target).toURL();
                Proxy httpProxy = HttpUtils.getProxyObject(true);
                if (httpProxy.equals(Proxy.NO_PROXY)) {
                    ConfigUtils.LOGGER.warn("No proxy to test.");
                    return new class_3545((Object)true, null);
                }
                HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection(httpProxy);
                urlConnection.setConnectTimeout(5000);
                urlConnection.setReadTimeout(5000);
                int res = urlConnection.getResponseCode();
                if (res != -1) {
                    if (res == 200 || res == 204) {
                        ConfigUtils.LOGGER.info("{} responded with {}", (Object)target, (Object)res);
                    } else {
                        ConfigUtils.LOGGER.warn("{} responded with {}", (Object)target, (Object)res);
                    }
                    if (res == 200) {
                        InputStream inputStream = urlConnection.getInputStream();
                        String result = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                        Gson gson = new Gson();
                        JsonObject jsonObject = (JsonObject)gson.fromJson(result, JsonObject.class);
                        ConfigUtils.LOGGER.info("{} response: {}", (Object)target, (Object)jsonObject.toString());
                    }
                    urlConnection.disconnect();
                } else {
                    ConfigUtils.LOGGER.warn("{} is not responding.", (Object)target);
                }
            }
            catch (JsonSyntaxException e) {
                return new class_3545((Object)true, (Object)new RuntimeException(target + " sent back no json.", e));
            }
            catch (IOException e) {
                return new class_3545((Object)false, (Object)new RuntimeException("IO failure!!", e));
            }
            return new class_3545((Object)true, null);
        });
    }

    private static void showTestStart(String target) {
        ConfigUtils.LOGGER.info("Testing connection to {}", (Object)target);
        class_310.method_1551().method_20493(() -> class_370.method_1990((class_374)class_310.method_1551().method_1566(), (class_370.class_9037)new class_370.class_9037(1000L), (class_2561)class_2561.method_43471((String)"socksproxyclient.config.base.proxy.testing"), (class_2561)class_2561.method_43470((String)target)));
    }

    private static void showTestResult(class_3545<Boolean, Throwable> res, String target) {
        class_310.method_1551().method_20493(() -> class_370.method_27024((class_374)class_310.method_1551().method_1566(), (class_370.class_9037)new class_370.class_9037(), (class_2561)class_2561.method_43471((String)((Boolean)res.method_15442() != false ? "socksproxyclient.config.base.proxy.test.success" : "socksproxyclient.config.base.proxy.test.failure")), (class_2561)class_2561.method_43470((String)target)));
        if (((Boolean)res.method_15442()).booleanValue()) {
            return;
        }
        Throwable t = (Throwable)res.method_15441();
        if (t != null && !(t instanceof JsonSyntaxException)) {
            ConfigUtils.LOGGER.error("Test not successful.", t);
        }
    }

    private static void showTestResult(CompletableFuture<class_3545<Boolean, Throwable>> test, String target) {
        test.thenApplyAsync(v -> {
            BaseConfigCategory.showTestResult((class_3545<Boolean, Throwable>)v, target);
            return null;
        });
    }
}

