/*
 * Decompiled with CFR 0.152.
 */
package crimsonedgehope.minecraft.fabric.socksproxyclient.config;

import com.google.common.net.HostAndPort;
import crimsonedgehope.minecraft.fabric.socksproxyclient.BaseUtils;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.SocksProxyClientConfig;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.entry.SocksProxyClientConfigEntry;
import java.lang.reflect.Field;
import java.net.IDN;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public final class ConfigUtils {
    public static final Logger LOGGER = BaseUtils.getLogger("Config");
    public static final Predicate<HostAndPort> hostAndPortValidity = hostAndPort -> {
        String string = hostAndPort.getHost();
        int port = hostAndPort.getPort();
        if (!string.isEmpty() && port > 0 && port <= 65535) {
            IDN.toASCII(string);
            return true;
        }
        return false;
    };
    public static final Predicate<String> minecraftAddressValidity = address -> hostAndPortValidity.test(HostAndPort.fromString((String)address).withDefaultPort(25565));
    public static final Predicate<String> addressValidity = address -> hostAndPortValidity.test(HostAndPort.fromString((String)address).withDefaultPort(0));

    public static <C extends SocksProxyClientConfig> C getConfigInstance(Class<C> clazz) throws Exception {
        Field field = clazz.getDeclaredField("INSTANCE");
        field.setAccessible(true);
        Object instance = field.get(null);
        if (instance == null) {
            field.set(null, clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            instance = field.get(null);
        }
        Objects.requireNonNull(instance);
        if (!clazz.isInstance(instance)) {
            instance = null;
        }
        return (C)((SocksProxyClientConfig)instance);
    }

    public static void loadAllConfig() throws Exception {
        ServiceLoader<SocksProxyClientConfig> serviceLoader = ServiceLoader.load(SocksProxyClientConfig.class, SocksProxyClientConfig.class.getClassLoader());
        for (SocksProxyClientConfig provider : serviceLoader) {
            Class<SocksProxyClientConfig> providerClass = provider.getClass().asSubclass(SocksProxyClientConfig.class);
            ConfigUtils.getConfigInstance(providerClass).load();
        }
    }

    public static void saveAllConfig() throws Exception {
        ServiceLoader<SocksProxyClientConfig> serviceLoader = ServiceLoader.load(SocksProxyClientConfig.class, SocksProxyClientConfig.class.getClassLoader());
        for (SocksProxyClientConfig provider : serviceLoader) {
            Class<SocksProxyClientConfig> providerClass = provider.getClass().asSubclass(SocksProxyClientConfig.class);
            ConfigUtils.getConfigInstance(providerClass).save();
        }
    }

    public static <T extends SocksProxyClientConfig> String getCategoryField(Class<T> clazz) throws Exception {
        String category = null;
        Field field = clazz.getDeclaredField("CATEGORY");
        field.setAccessible(true);
        category = (String)field.get(null);
        if (category == null) {
            category = clazz.getSimpleName();
        }
        return category;
    }

    public static SocksProxyClientConfigEntry<?> getEntryField(Class<? extends SocksProxyClientConfig> configClass, String fieldName) throws Exception {
        return ConfigUtils.getConfigInstance(configClass).getEntryField(fieldName);
    }

    public static <T> SocksProxyClientConfigEntry<T> getEntryField(Class<? extends SocksProxyClientConfig> configClass, String fieldName, Class<T> valueType) throws Exception {
        return ConfigUtils.getConfigInstance(configClass).getEntryField(fieldName, valueType);
    }

    @Generated
    private ConfigUtils() {
    }
}

