/*
 * Decompiled with CFR 0.152.
 */
package crimsonedgehope.minecraft.fabric.socksproxyclient.dns.doh;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.DNSConfig;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.DNSOverHTTPSConfig;
import crimsonedgehope.minecraft.fabric.socksproxyclient.dns.DNSUtils;
import crimsonedgehope.minecraft.fabric.socksproxyclient.dns.SocksProxyClientDNSResolver;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.DohResolver;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Lookup;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Record;
import java.time.Duration;
import java.util.List;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public final class DNSOverHTTPSResolver
implements SocksProxyClientDNSResolver {
    private static final String NAME = "DNS-Over-HTTPS";
    private static final Cache<String, List<Record>> cache = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofSeconds(DNSOverHTTPSConfig.cacheTTL())).build();

    @Override
    public List<Record> resolve(String hostname, int recordType) throws Exception {
        List<Record> res = null;
        if (recordType == 1 || recordType == 33) {
            res = (List<Record>)cache.getIfPresent((Object)hostname);
        }
        if (res != null) {
            if (res.isEmpty()) {
                cache.invalidate((Object)hostname);
            } else {
                DNSUtils.LOGGER.debug("Cache hit: {}", (Object)hostname);
                return res;
            }
        }
        DohResolver resolver = new DohResolver(DNSOverHTTPSConfig.getUrl(), 1, Duration.ofSeconds(2L));
        resolver.setUsePost(true);
        Lookup lookup2 = new Lookup(hostname, recordType);
        lookup2.setResolver(resolver);
        if (DNSConfig.shouldDismissSystemHosts()) {
            lookup2.setHostsFileParser(null);
        }
        if (!(res = DNSUtils.performLookup(lookup2)).isEmpty()) {
            cache.put((Object)hostname, res);
        }
        return res;
    }

    @Generated
    public DNSOverHTTPSResolver() {
    }
}

