/*
 * Decompiled with CFR 0.152.
 */
package crimsonedgehope.minecraft.fabric.socksproxyclient.http;

import crimsonedgehope.minecraft.fabric.socksproxyclient.BaseUtils;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.BaseConfig;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.entry.ProxyEntry;
import crimsonedgehope.minecraft.fabric.socksproxyclient.dns.NettyResolver;
import crimsonedgehope.minecraft.fabric.socksproxyclient.socks.SocksSelection;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.logging.LoggingHandler;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public class HttpProxy {
    public static final HttpProxy INSTANCE;
    public static final Logger LOGGER;
    private final String host;
    private int port;
    private Channel channel;
    private boolean fired = false;

    public HttpProxy() {
        this(0);
    }

    public HttpProxy(int port) {
        this("localhost", port);
    }

    public HttpProxy(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void fire() {
        this.fire((GenericFutureListener<Future<? super Void>>)((GenericFutureListener)f -> {}));
    }

    public void fire(GenericFutureListener<Future<? super Void>> firedCallback) {
        if (this.fired) {
            return;
        }
        new Thread(() -> {
            NioEventLoopGroup acceptorGroup = new NioEventLoopGroup(1);
            NioEventLoopGroup clientGroup = new NioEventLoopGroup();
            try {
                ServerBootstrap b = new ServerBootstrap();
                ChannelFuture future = ((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)acceptorGroup, (EventLoopGroup)clientGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler())).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(this){

                    public void initChannel(SocketChannel channel) {
                        channel.pipeline().addLast("http_aggre", (ChannelHandler)new HttpObjectAggregator(0xFA00000)).addLast("http_req_dec", (ChannelHandler)new HttpRequestDecoder()).addLast("opentunnel", (ChannelHandler)new HttpProxyClientInboundHandler());
                    }
                }).bind(this.host, this.port).sync();
                this.channel = future.addListener(f -> {
                    if (f.isSuccess()) {
                        this.port = ((InetSocketAddress)future.channel().localAddress()).getPort();
                        this.fired = true;
                        LOGGER.info("Internal http proxy listening on {}", (Object)future.channel().localAddress());
                    }
                }).addListener(firedCallback).channel();
                this.channel = this.channel.closeFuture().sync().addListener(f -> LOGGER.info("Internal http proxy shutting off!")).channel();
            }
            catch (Exception e) {
                LOGGER.error("Error starting internal http proxy!", (Throwable)e);
            }
            finally {
                this.cease();
                acceptorGroup.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
                clientGroup.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
            }
        }).start();
    }

    public void cease() {
        if (!this.fired) {
            return;
        }
        this.fired = false;
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public Channel getChannel() {
        return this.channel;
    }

    @Generated
    public boolean isFired() {
        return this.fired;
    }

    static {
        LOGGER = BaseUtils.getLogger("HttpProxy");
        INSTANCE = new HttpProxy();
    }

    @ChannelHandler.Sharable
    private static final class HttpProxyClientInboundHandler
    extends SimpleChannelInboundHandler<HttpRequest> {
        private Channel remote;
        private Channel client;
        private boolean connectMethod = false;
        private HttpVersion httpVersion;
        private String remoteHttpHost = null;
        private int remoteHttpPort = -1;
        private boolean parsed = false;

        private HttpProxyClientInboundHandler() {
        }

        public void channelActive(@NonNull ChannelHandlerContext ctx) {
            if (ctx == null) {
                throw new NullPointerException("ctx is marked non-null but is null");
            }
            this.client = ctx.channel();
        }

        public void channelRead0(ChannelHandlerContext ctx, HttpRequest msg) {
            if (!this.parsed) {
                this.connectMethod = msg.method().equals(HttpMethod.CONNECT);
                this.httpVersion = msg.protocolVersion();
                this.remoteHttpHost = Objects.requireNonNull(msg.headers().getAsString("host"));
                int k = this.remoteHttpHost.indexOf(":");
                if (k == -1) {
                    this.remoteHttpPort = this.connectMethod ? 443 : 80;
                } else {
                    this.remoteHttpPort = Integer.parseInt(Objects.requireNonNull(this.remoteHttpHost.substring(k + 1)));
                    this.remoteHttpHost = this.remoteHttpHost.substring(0, k);
                }
                this.parsed = true;
            }
            if (this.remote == null) {
                final List<ProxyEntry> entries = BaseConfig.getProxyEntries();
                Bootstrap b = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)this.client.eventLoop())).channel(this.client.getClass())).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                    public void initChannel(@NonNull SocketChannel channel) {
                        if (channel == null) {
                            throw new NullPointerException("channel is marked non-null but is null");
                        }
                        SocksSelection.fire(InetSocketAddress.createUnresolved(remoteHttpHost, remoteHttpPort), channel.pipeline(), () -> entries);
                        if (entries.isEmpty()) {
                            channel.pipeline().addFirst(new ChannelHandler[]{new ChannelDuplexHandler()});
                        }
                    }
                })).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
                b.resolver((AddressResolverGroup)new AddressResolverGroup<InetSocketAddress>(this){

                    protected AddressResolver<InetSocketAddress> newResolver(EventExecutor eventExecutor) {
                        return new NettyResolver(eventExecutor).asAddressResolver();
                    }
                });
                ChannelFuture future = b.connect(this.remoteHttpHost, this.remoteHttpPort);
                future.addListener(f -> {
                    if (f.isSuccess()) {
                        this.remote = future.channel();
                        if (this.connectMethod) {
                            this.client.pipeline().addLast("temp_http_res_enc", (ChannelHandler)new HttpResponseEncoder());
                            this.client.writeAndFlush((Object)new DefaultHttpResponse(this.httpVersion, new HttpResponseStatus(200, "Connection Established"))).addListener(f0 -> {
                                if (f0.isSuccess()) {
                                    this.client.pipeline().remove("temp_http_res_enc");
                                    this.channelRemoval();
                                    this.channelTakeover();
                                    LOGGER.info("Open tunnel to remote {}:{}", (Object)this.remoteHttpHost, (Object)this.remoteHttpPort);
                                }
                            }).addListeners(new GenericFutureListener[]{ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE, ChannelFutureListener.CLOSE_ON_FAILURE});
                        } else {
                            this.remote.pipeline().addLast("temp_http_req_enc", (ChannelHandler)new HttpRequestEncoder());
                            this.remote.writeAndFlush((Object)msg).addListener(f0 -> {
                                if (f0.isSuccess()) {
                                    this.remote.pipeline().remove("temp_http_req_enc");
                                    this.channelRemoval();
                                    this.channelTakeover();
                                    LOGGER.info("Open tunnel to remote {}:{}", (Object)this.remoteHttpHost, (Object)this.remoteHttpPort);
                                }
                            }).addListeners(new GenericFutureListener[]{ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE, ChannelFutureListener.CLOSE_ON_FAILURE});
                        }
                    } else {
                        this.shutOffActiveChannel(this.client);
                    }
                }).addListeners(new GenericFutureListener[]{ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE, ChannelFutureListener.CLOSE_ON_FAILURE});
                this.remote = future.channel();
                this.client = this.client.closeFuture().addListener(f -> {
                    if (f.isDone()) {
                        LOGGER.info("Closing tunnel to remote {}:{}", (Object)this.remoteHttpHost, (Object)this.remoteHttpPort);
                        this.shutOffActiveChannel(this.remote);
                    }
                }).channel();
                this.remote = this.remote.closeFuture().addListener(f -> {
                    if (f.isDone()) {
                        LOGGER.info("Tunnel to remote {}:{} closed.", (Object)this.remoteHttpHost, (Object)this.remoteHttpPort);
                        this.shutOffActiveChannel(this.client);
                    }
                }).channel();
            }
        }

        private void channelRemoval() {
            this.client.pipeline().remove("http_aggre");
            this.client.pipeline().remove("http_req_dec");
        }

        private void channelTakeover() {
            this.clientChannelTakeover();
            this.remoteChannelTakeover();
        }

        private void clientChannelTakeover() {
            this.client.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<ByteBuf>(){

                public void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
                    remote.writeAndFlush((Object)msg.retain()).addListeners(new GenericFutureListener[]{ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE, ChannelFutureListener.CLOSE_ON_FAILURE});
                }

                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                    LOGGER.error("Error in client channel!", cause);
                    this.shutOffActiveChannel(ctx.channel());
                }
            }});
        }

        private void remoteChannelTakeover() {
            this.remote.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<ByteBuf>(){

                public void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
                    client.writeAndFlush((Object)msg.retain()).addListeners(new GenericFutureListener[]{ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE, ChannelFutureListener.CLOSE_ON_FAILURE});
                }

                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                    LOGGER.error("Error in remote channel!", cause);
                    this.shutOffActiveChannel(ctx.channel());
                }
            }});
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            LOGGER.error("Error running internal http proxy!", cause);
            this.shutOffActiveChannel(ctx.channel());
        }

        public void channelInactive(@NonNull ChannelHandlerContext ctx) {
            if (ctx == null) {
                throw new NullPointerException("ctx is marked non-null but is null");
            }
            this.shutOffActiveChannel(this.remote);
        }

        private void shutOffActiveChannel(Channel channel) {
            if (channel != null && channel.isActive()) {
                channel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
    }
}

