/*
 * Decompiled with CFR 0.152.
 */
package crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS;

import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Address;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Compression;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.DNSInput;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.DNSOutput;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Name;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Record;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Tokenizer;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.WireParseException;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.utils.base16;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class APLRecord
extends Record {
    private List<Element> elements;

    APLRecord() {
    }

    private static boolean validatePrefixLength(int family, int prefixLength) {
        if (prefixLength < 0 || prefixLength >= 256) {
            return false;
        }
        return !(family == 1 && prefixLength > 32 || family == 2 && prefixLength > 128);
    }

    public APLRecord(Name name, int dclass, long ttl, List<Element> elements) {
        super(name, 42, dclass, ttl);
        this.elements = new ArrayList<Element>(elements.size());
        for (Element element : elements) {
            if (element.family != 1 && element.family != 2) {
                throw new IllegalArgumentException("unknown family");
            }
            this.elements.add(element);
        }
    }

    private static byte[] parseAddress(byte[] in, int length) throws WireParseException {
        if (in.length > length) {
            throw new WireParseException("invalid address length");
        }
        if (in.length == length) {
            return in;
        }
        byte[] out = new byte[length];
        System.arraycopy(in, 0, out, 0, in.length);
        return out;
    }

    @Override
    protected void rrFromWire(DNSInput in) throws IOException {
        this.elements = new ArrayList<Element>(1);
        while (in.remaining() != 0) {
            Element element;
            int family = in.readU16();
            int prefix = in.readU8();
            int length = in.readU8();
            boolean negative = (length & 0x80) != 0;
            byte[] data = in.readByteArray(length &= 0xFFFFFF7F);
            if (!APLRecord.validatePrefixLength(family, prefix)) {
                throw new WireParseException("invalid prefix length");
            }
            if (family == 1 || family == 2) {
                data = APLRecord.parseAddress(data, Address.addressLength(family));
                InetAddress addr = InetAddress.getByAddress(data);
                element = new Element(negative, addr, prefix);
            } else {
                element = new Element(family, negative, data, prefix);
            }
            this.elements.add(element);
        }
    }

    @Override
    protected void rdataFromString(Tokenizer st, Name origin) throws IOException {
        Tokenizer.Token t;
        this.elements = new ArrayList<Element>(1);
        while ((t = st.get()).isString()) {
            int prefix;
            int family;
            int colon;
            boolean negative = false;
            String s = t.value();
            int start = 0;
            if (s.startsWith("!")) {
                negative = true;
                start = 1;
            }
            if ((colon = s.indexOf(58, start)) < 0) {
                throw st.exception("invalid address prefix element");
            }
            int slash = s.indexOf(47, colon);
            if (slash < 0) {
                throw st.exception("invalid address prefix element");
            }
            String familyString = s.substring(start, colon);
            String addressString = s.substring(colon + 1, slash);
            String prefixString = s.substring(slash + 1);
            try {
                family = Integer.parseInt(familyString);
            }
            catch (NumberFormatException e) {
                throw st.exception("invalid family");
            }
            if (family != 1 && family != 2) {
                throw st.exception("unknown family");
            }
            try {
                prefix = Integer.parseInt(prefixString);
            }
            catch (NumberFormatException e) {
                throw st.exception("invalid prefix length");
            }
            if (!APLRecord.validatePrefixLength(family, prefix)) {
                throw st.exception("invalid prefix length");
            }
            byte[] bytes = Address.toByteArray(addressString, family);
            if (bytes == null) {
                throw st.exception("invalid IP address " + addressString);
            }
            InetAddress address = InetAddress.getByAddress(bytes);
            this.elements.add(new Element(negative, address, prefix));
        }
        st.unget();
    }

    @Override
    protected String rrToString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Element> it = this.elements.iterator();
        while (it.hasNext()) {
            Element element = it.next();
            sb.append(element);
            if (!it.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public List<Element> getElements() {
        return this.elements;
    }

    private static int addressLength(byte[] addr) {
        for (int i = addr.length - 1; i >= 0; --i) {
            if (addr[i] == 0) continue;
            return i + 1;
        }
        return 0;
    }

    @Override
    protected void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        for (Element element : this.elements) {
            int length;
            byte[] data;
            if (element.family == 1 || element.family == 2) {
                InetAddress addr = (InetAddress)element.address;
                data = addr.getAddress();
                length = APLRecord.addressLength(data);
            } else {
                data = (byte[])element.address;
                length = data.length;
            }
            int wlength = length;
            if (element.negative) {
                wlength |= 0x80;
            }
            out.writeU16(element.family);
            out.writeU8(element.prefixLength);
            out.writeU8(wlength);
            out.writeByteArray(data, 0, length);
        }
    }

    public static class Element {
        public final int family;
        public final boolean negative;
        public final int prefixLength;
        public final Object address;

        private Element(int family, boolean negative, Object address, int prefixLength) {
            this.family = family;
            this.negative = negative;
            this.address = address;
            this.prefixLength = prefixLength;
            if (!APLRecord.validatePrefixLength(family, prefixLength)) {
                throw new IllegalArgumentException("invalid prefix length");
            }
        }

        public Element(boolean negative, InetAddress address, int prefixLength) {
            this(Address.familyOf(address), negative, address, prefixLength);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.negative) {
                sb.append("!");
            }
            sb.append(this.family);
            sb.append(":");
            if (this.family == 1 || this.family == 2) {
                sb.append(((InetAddress)this.address).getHostAddress());
            } else {
                sb.append(base16.toString((byte[])this.address));
            }
            sb.append("/");
            sb.append(this.prefixLength);
            return sb.toString();
        }

        public boolean equals(Object arg) {
            if (!(arg instanceof Element)) {
                return false;
            }
            Element elt = (Element)arg;
            return this.family == elt.family && this.negative == elt.negative && this.prefixLength == elt.prefixLength && this.address.equals(elt.address);
        }

        public int hashCode() {
            return this.address.hashCode() + this.prefixLength + (this.negative ? 1 : 0);
        }
    }
}

