/*
 * Decompiled with CFR 0.152.
 */
package crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS;

import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Compression;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.DNSInput;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.DNSOutput;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.EDNSOption;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.ExtendedFlags;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Name;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Record;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Tokenizer;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Type;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class OPTRecord
extends Record {
    private List<EDNSOption> options;

    OPTRecord() {
    }

    public OPTRecord(int payloadSize, int xrcode, int version, int flags, EDNSOption ... options) {
        this(payloadSize, xrcode, version, flags);
        if (options != null) {
            this.options = new ArrayList<EDNSOption>(Arrays.asList(options));
        }
    }

    public OPTRecord(int payloadSize, int xrcode, int version, int flags, List<EDNSOption> options) {
        this(payloadSize, xrcode, version, flags);
        if (options != null) {
            this.options = new ArrayList<EDNSOption>(options);
        }
    }

    public OPTRecord(int payloadSize, int xrcode, int version, int flags) {
        super(Name.root, 41, payloadSize, 0L);
        OPTRecord.checkU16("payloadSize", payloadSize);
        OPTRecord.checkU8("xrcode", xrcode);
        OPTRecord.checkU8("version", version);
        OPTRecord.checkU16("flags", flags);
        this.ttl = ((long)xrcode << 24) + ((long)version << 16) + (long)flags;
    }

    public OPTRecord(int payloadSize, int xrcode, int version) {
        this(payloadSize, xrcode, version, 0);
    }

    @Override
    protected void rrFromWire(DNSInput in) throws IOException {
        if (in.remaining() > 0) {
            this.options = new ArrayList<EDNSOption>();
        }
        while (in.remaining() > 0) {
            EDNSOption option = EDNSOption.fromWire(in);
            this.options.add(option);
        }
    }

    @Override
    protected void rdataFromString(Tokenizer st, Name origin) throws IOException {
        throw st.exception("no text format defined for OPT");
    }

    @Override
    protected String rrToString() {
        StringBuilder sb = new StringBuilder();
        if (this.options != null) {
            sb.append(this.options);
            sb.append(" ");
        }
        sb.append(" ; payload ");
        sb.append(this.getPayloadSize());
        sb.append(", xrcode ");
        sb.append(this.getExtendedRcode());
        sb.append(", version ");
        sb.append(this.getVersion());
        sb.append(", flags ");
        sb.append(this.getFlags());
        return sb.toString();
    }

    @Override
    public String toString() {
        return Name.root + "\t\t\t\t" + Type.string(this.type) + "\t" + this.rrToString();
    }

    void printPseudoSection(StringBuilder sb) {
        sb.append(";; OPT PSEUDOSECTION: \n; EDNS: version: ");
        sb.append(this.getVersion());
        sb.append("; flags: ");
        for (int i = 0; i < 16; ++i) {
            if ((this.getFlags() & 1 << 15 - i) == 0) continue;
            sb.append(ExtendedFlags.stringFromBit(i));
            sb.append(" ");
        }
        sb.append("; udp: ").append(this.getPayloadSize());
        if (this.options != null) {
            for (EDNSOption o : this.options) {
                sb.append("\n; ").append(EDNSOption.Code.string(o.getCode())).append(": ").append(o.optionToString());
            }
        }
    }

    public int getPayloadSize() {
        return this.dclass;
    }

    public int getExtendedRcode() {
        return (int)(this.ttl >>> 24);
    }

    public int getVersion() {
        return (int)(this.ttl >>> 16 & 0xFFL);
    }

    public int getFlags() {
        return (int)(this.ttl & 0xFFFFL);
    }

    @Override
    protected void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        if (this.options == null) {
            return;
        }
        for (EDNSOption option : this.options) {
            option.toWire(out);
        }
    }

    public List<EDNSOption> getOptions() {
        if (this.options == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.options);
    }

    public List<EDNSOption> getOptions(int code) {
        if (this.options == null) {
            return Collections.emptyList();
        }
        ArrayList<EDNSOption> list = new ArrayList<EDNSOption>();
        for (EDNSOption opt : this.options) {
            if (opt.getCode() != code) continue;
            list.add(opt);
        }
        return list;
    }

    @Override
    public boolean equals(Object arg) {
        return super.equals(arg) && this.ttl == ((OPTRecord)arg).ttl;
    }

    @Override
    public int hashCode() {
        byte[] array = this.toWireCanonical();
        int code = 0;
        for (byte b : array) {
            code += (code << 3) + (b & 0xFF);
        }
        return code;
    }
}

