/*
 * Decompiled with CFR 0.152.
 */
package crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.dnssec;

import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.DNSKEYRecord;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.DNSSEC;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.NSEC3Record;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Name;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.NameTooLongException;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Record;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.TextParseException;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Type;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.dnssec.ByteArrayComparator;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.dnssec.JustifiedSecStatus;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.dnssec.KeyCache;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.dnssec.KeyEntry;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.dnssec.R;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.dnssec.SRRset;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.dnssec.SecurityStatus;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.utils.base32;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NSEC3ValUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NSEC3ValUtils.class);
    private static final Name ASTERISK_LABEL = Name.fromConstantString("*");
    private static final int MAX_ITERATION_COUNT = 65536;
    private final TreeMap<Integer, Integer> maxIterations = new TreeMap();

    NSEC3ValUtils() {
        this.maxIterations.put(1024, 150);
        this.maxIterations.put(2048, 500);
        this.maxIterations.put(4096, 2500);
    }

    void init(Properties config) {
        boolean first = true;
        for (Map.Entry<Object, Object> s : config.entrySet()) {
            String key = s.getKey().toString();
            if (!key.startsWith("dnsjava.dnssec.nsec3.iterations")) continue;
            int keySize = Integer.parseInt(key.substring(key.lastIndexOf(".") + 1));
            int iters = Integer.parseInt(s.getValue().toString());
            if (iters > 65536) {
                throw new IllegalArgumentException("Iteration count too high.");
            }
            if (first) {
                first = false;
                this.maxIterations.clear();
            }
            this.maxIterations.put(keySize, iters);
        }
    }

    private boolean supportsHashAlgorithm(int alg) {
        return alg == 1;
    }

    public void stripUnknownAlgNSEC3s(List<SRRset> nsec3s) {
        ListIterator<SRRset> i = nsec3s.listIterator();
        while (i.hasNext()) {
            NSEC3Record nsec3 = (NSEC3Record)i.next().first();
            if (this.supportsHashAlgorithm(nsec3.getHashAlgorithm())) continue;
            i.remove();
        }
    }

    private Name ceWildcard(Name closestEncloser) {
        try {
            return Name.concatenate(ASTERISK_LABEL, closestEncloser);
        }
        catch (NameTooLongException e) {
            return null;
        }
    }

    private Name nextClosest(Name qname, Name closestEncloser) {
        int strip = qname.labels() - closestEncloser.labels() - 1;
        return strip > 0 ? new Name(qname, strip) : qname;
    }

    private NSEC3Record findMatchingNSEC3(Name name, Name zonename, List<SRRset> nsec3s) {
        base32 b32 = new base32("0123456789ABCDEFGHIJKLMNOPQRSTUV=", false, false);
        for (SRRset set : nsec3s) {
            try {
                NSEC3Record nsec3 = (NSEC3Record)set.first();
                byte[] hash = nsec3.hashName(name);
                Name complete = new Name(b32.toString(hash), zonename);
                if (!complete.equals(nsec3.getName())) continue;
                return nsec3;
            }
            catch (TextParseException | NoSuchAlgorithmException e) {
                log.debug("Unrecognized NSEC3 in set: {}", (Object)set, (Object)e);
            }
        }
        return null;
    }

    private boolean nsec3Covers(NSEC3Record nsec3, Name zonename, byte[] hash) {
        if (!new Name(nsec3.getName(), 1).equals(zonename)) {
            return false;
        }
        byte[] owner = new base32("0123456789ABCDEFGHIJKLMNOPQRSTUV=", false, false).fromString(nsec3.getName().getLabelString(0));
        byte[] next = nsec3.getNext();
        if (ByteArrayComparator.compare(owner, hash) < 0 && ByteArrayComparator.compare(hash, next) < 0) {
            return true;
        }
        return ByteArrayComparator.compare(next, owner) <= 0 && (ByteArrayComparator.compare(hash, owner) > 0 || ByteArrayComparator.compare(hash, next) < 0);
    }

    private NSEC3Record findCoveringNSEC3(Name name, Name zonename, List<SRRset> nsec3s) {
        for (SRRset set : nsec3s) {
            try {
                byte[] hash;
                NSEC3Record nsec3 = (NSEC3Record)set.first();
                if (!this.nsec3Covers(nsec3, zonename, hash = nsec3.hashName(name))) continue;
                return nsec3;
            }
            catch (NoSuchAlgorithmException e) {
                log.debug("Unrecognized NSEC3 in set: {}", (Object)set, (Object)e);
            }
        }
        return null;
    }

    private CEResponse findClosestEncloser(Name name, Name zonename, List<SRRset> nsec3s) {
        while (name.labels() >= zonename.labels()) {
            NSEC3Record nsec3 = this.findMatchingNSEC3(name, zonename, nsec3s);
            if (nsec3 != null) {
                return new CEResponse(name, nsec3);
            }
            name = new Name(name, 1);
        }
        return null;
    }

    private CEResponse proveClosestEncloser(Name qname, Name zonename, List<SRRset> nsec3s) {
        CEResponse candidate = this.findClosestEncloser(qname, zonename, nsec3s);
        if (candidate == null) {
            log.debug("Could not find a candidate for the closest encloser");
            candidate = new CEResponse(Name.empty, null);
            candidate.status = SecurityStatus.BOGUS;
            return candidate;
        }
        if (candidate.closestEncloser.equals(qname)) {
            log.debug("Proved that qname existed!");
            candidate.status = SecurityStatus.BOGUS;
            return candidate;
        }
        if (candidate.ceNsec3.hasType(2) && !candidate.ceNsec3.hasType(6)) {
            if (!candidate.ceNsec3.hasType(43)) {
                candidate.status = SecurityStatus.INSECURE;
                return candidate;
            }
            log.debug("Closest encloser was a delegation!");
            candidate.status = SecurityStatus.BOGUS;
            return candidate;
        }
        if (candidate.ceNsec3.hasType(39)) {
            log.debug("Closest encloser was a DNAME!");
            candidate.status = SecurityStatus.BOGUS;
            return candidate;
        }
        Name nextClosest = this.nextClosest(qname, candidate.closestEncloser);
        candidate.ncNsec3 = this.findCoveringNSEC3(nextClosest, zonename, nsec3s);
        if (candidate.ncNsec3 == null) {
            log.debug("Could not find proof that the closest encloser was the closest encloser");
            candidate.status = SecurityStatus.BOGUS;
            return candidate;
        }
        candidate.status = SecurityStatus.SECURE;
        return candidate;
    }

    private boolean validIterations(SRRset nsec, KeyCache keyCache) {
        KeyEntry dnskeyRrset = keyCache.find(nsec.getSignerName(), nsec.getDClass());
        try {
            for (Record r : dnskeyRrset.rrs()) {
                int keysize;
                DNSKEYRecord dnskey = (DNSKEYRecord)r;
                switch (dnskey.getAlgorithm()) {
                    case 1: {
                        return false;
                    }
                    case 5: 
                    case 7: 
                    case 8: 
                    case 10: {
                        keysize = ((RSAPublicKey)dnskey.getPublicKey()).getModulus().bitLength();
                        break;
                    }
                    case 3: 
                    case 6: {
                        keysize = ((DSAPublicKey)dnskey.getPublicKey()).getParams().getP().bitLength();
                        break;
                    }
                    case 13: 
                    case 14: {
                        keysize = ((ECPublicKey)dnskey.getPublicKey()).getParams().getCurve().getField().getFieldSize();
                        break;
                    }
                    case 12: {
                        keysize = 512;
                        break;
                    }
                    case 15: {
                        keysize = 256;
                        break;
                    }
                    case 16: {
                        keysize = 456;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                Integer keyIters = this.maxIterations.floorKey(keysize);
                if (keyIters == null) {
                    keyIters = this.maxIterations.firstKey();
                }
                keyIters = this.maxIterations.get(keyIters);
                if (((NSEC3Record)nsec.first()).getIterations() <= keyIters) continue;
                return false;
            }
            return true;
        }
        catch (DNSSEC.DNSSECException e) {
            log.error("Could not get public key from NSEC3 record", (Throwable)e);
            return false;
        }
    }

    public boolean allNSEC3sIgnoreable(List<SRRset> nsec3s, KeyCache dnskeyRrset) {
        HashMap<Name, NSEC3Record> foundNsecs = new HashMap<Name, NSEC3Record>();
        for (SRRset set : nsec3s) {
            for (Record r : set.rrs()) {
                NSEC3Record current = (NSEC3Record)r;
                Name key = new Name(current.getName(), 1);
                NSEC3Record previous = (NSEC3Record)foundNsecs.get(key);
                if (previous != null) {
                    if (current.getHashAlgorithm() != previous.getHashAlgorithm()) {
                        return true;
                    }
                    if (current.getIterations() != previous.getIterations()) {
                        return true;
                    }
                    if (current.getSalt() == null ^ previous.getSalt() == null) {
                        return true;
                    }
                    if (current.getSalt() == null || ByteArrayComparator.compare(current.getSalt(), previous.getSalt()) == 0) continue;
                    return true;
                }
                foundNsecs.put(key, current);
            }
        }
        for (SRRset set : nsec3s) {
            if (!this.validIterations(set, dnskeyRrset)) continue;
            return false;
        }
        return true;
    }

    public SecurityStatus proveNameError(List<SRRset> nsec3s, Name qname, Name zonename) {
        if (nsec3s == null || nsec3s.isEmpty()) {
            return SecurityStatus.BOGUS;
        }
        CEResponse ce = this.proveClosestEncloser(qname, zonename, nsec3s);
        if (ce.status != SecurityStatus.SECURE) {
            log.debug("Failed to prove a closest encloser");
            return ce.status;
        }
        Name wc = this.ceWildcard(ce.closestEncloser);
        NSEC3Record nsec3 = this.findCoveringNSEC3(wc, zonename, nsec3s);
        if (nsec3 == null) {
            log.debug("Could not prove that the applicable wildcard did not exist");
            return SecurityStatus.BOGUS;
        }
        if ((ce.ncNsec3.getFlags() & 1) == 1) {
            log.debug("NSEC3 nameerror proof: nc has optout");
            return SecurityStatus.INSECURE;
        }
        return SecurityStatus.SECURE;
    }

    public JustifiedSecStatus proveNodata(List<SRRset> nsec3s, Name qname, int qtype, Name zonename) {
        if (nsec3s == null || nsec3s.isEmpty()) {
            return new JustifiedSecStatus(SecurityStatus.BOGUS, 12, R.get("failed.nsec3.none", new Object[0]));
        }
        NSEC3Record nsec3 = this.findMatchingNSEC3(qname, zonename, nsec3s);
        if (nsec3 != null) {
            if (nsec3.hasType(qtype)) {
                log.debug("Matching NSEC3 proved that type existed!");
                return new JustifiedSecStatus(SecurityStatus.BOGUS, 6, R.get("failed.nsec3.type_exists", new Object[0]));
            }
            if (nsec3.hasType(5)) {
                log.debug("Matching NSEC3 proved that a CNAME existed!");
                return new JustifiedSecStatus(SecurityStatus.BOGUS, 6, R.get("failed.nsec3.cname_exists", new Object[0]));
            }
            if (qtype == 43 && nsec3.hasType(6) && !Name.root.equals(qname)) {
                log.debug("Apex NSEC3 abused for no DS proof, bogus");
                return new JustifiedSecStatus(SecurityStatus.BOGUS, 6, R.get("failed.nsec3.apex_abuse", new Object[0]));
            }
            if (qtype != 43 && nsec3.hasType(2) && !nsec3.hasType(6)) {
                if (!nsec3.hasType(43)) {
                    log.debug("Matching NSEC3 is insecure delegation");
                    return new JustifiedSecStatus(SecurityStatus.INSECURE, -1, null);
                }
                log.debug("Matching NSEC3 is a delegation, bogus");
                return new JustifiedSecStatus(SecurityStatus.BOGUS, 6, R.get("failed.nsec3.delegation", new Object[0]));
            }
            return new JustifiedSecStatus(SecurityStatus.SECURE, -1, null);
        }
        CEResponse ce = this.proveClosestEncloser(qname, zonename, nsec3s);
        if (ce.status == SecurityStatus.BOGUS) {
            log.debug("Did not match qname, nor found a proven closest encloser");
            return new JustifiedSecStatus(SecurityStatus.BOGUS, 6, R.get("failed.nsec3.qname_ce", new Object[0]));
        }
        if (ce.status == SecurityStatus.INSECURE && qtype != 43) {
            log.debug("Closest NSEC3 is insecure delegation");
            return new JustifiedSecStatus(SecurityStatus.INSECURE, -1, null);
        }
        Name wc = this.ceWildcard(ce.closestEncloser);
        nsec3 = this.findMatchingNSEC3(wc, zonename, nsec3s);
        if (nsec3 != null) {
            if (nsec3.hasType(qtype)) {
                log.debug("Matching wildcard has qtype {}", (Object)Type.string(qtype));
                return new JustifiedSecStatus(SecurityStatus.BOGUS, 6, R.get("failed.nsec3.type_exists_wc", new Object[0]));
            }
            if (nsec3.hasType(5)) {
                log.debug("Matching wildcard has a CNAME, bogus");
                return new JustifiedSecStatus(SecurityStatus.BOGUS, 6, R.get("failed.nsec3.cname_exists_wc", new Object[0]));
            }
            if (qtype == 43 && qname.labels() != 1 && nsec3.hasType(6)) {
                log.debug("Matching wildcard for no DS proof has a SOA, bogus");
                return new JustifiedSecStatus(SecurityStatus.BOGUS, 6, R.get("failed.nsec3.wc_soa", new Object[0]));
            }
            if (qtype != 43 && nsec3.hasType(2) && !nsec3.hasType(6)) {
                log.debug("Matching wildcard is a delegation, bogus");
                return new JustifiedSecStatus(SecurityStatus.BOGUS, 6, R.get("failed.nsec3.delegation_wc", new Object[0]));
            }
            if (ce.ncNsec3 != null && (ce.ncNsec3.getFlags() & 1) == 1) {
                log.debug("Matching wildcard is in opt-out range, insecure");
                return new JustifiedSecStatus(SecurityStatus.INSECURE, -1, null);
            }
            return new JustifiedSecStatus(SecurityStatus.SECURE, -1, null);
        }
        if (ce.ncNsec3 == null) {
            log.debug("No next closer NSEC3");
            return new JustifiedSecStatus(SecurityStatus.BOGUS, 12, R.get("failed.nsec3.no_next", new Object[0]));
        }
        if ((ce.ncNsec3.getFlags() & 1) == 0) {
            if (qtype != 43) {
                log.debug("Covering NSEC3 was not opt-out in an opt-out DS NOERROR/NODATA case");
                return new JustifiedSecStatus(SecurityStatus.BOGUS, 6, R.get("failed.nsec3.not_optout", new Object[0]));
            }
            log.debug("Could not find matching NSEC3, nor matching wildcard, and qtype is not DS -- no more options");
            return new JustifiedSecStatus(SecurityStatus.BOGUS, 12, R.get("failed.nsec3.not_found", new Object[0]));
        }
        return new JustifiedSecStatus(SecurityStatus.INSECURE, -1, null);
    }

    public SecurityStatus proveWildcard(List<SRRset> nsec3s, Name qname, Name zonename, Name wildcard) {
        if (nsec3s == null || nsec3s.isEmpty() || qname == null || wildcard == null) {
            return SecurityStatus.BOGUS;
        }
        CEResponse candidate = new CEResponse(new Name(wildcard, 1), null);
        Name nextClosest = this.nextClosest(qname, candidate.closestEncloser);
        candidate.ncNsec3 = this.findCoveringNSEC3(nextClosest, zonename, nsec3s);
        if (candidate.ncNsec3 == null) {
            log.debug("did not find a covering NSEC3 that covered the next closer name to {} from {} (derived from wildcard {})", new Object[]{qname, candidate.closestEncloser, wildcard});
            return SecurityStatus.BOGUS;
        }
        if ((candidate.ncNsec3.getFlags() & 1) == 1) {
            return SecurityStatus.INSECURE;
        }
        return SecurityStatus.SECURE;
    }

    public SecurityStatus proveNoDS(List<SRRset> nsec3s, Name qname, Name zonename) {
        if (nsec3s == null || nsec3s.isEmpty()) {
            return SecurityStatus.BOGUS;
        }
        NSEC3Record nsec3 = this.findMatchingNSEC3(qname, zonename, nsec3s);
        if (nsec3 != null) {
            if (nsec3.hasType(6) || nsec3.hasType(43)) {
                return SecurityStatus.BOGUS;
            }
            if (!nsec3.hasType(2)) {
                return SecurityStatus.INDETERMINATE;
            }
            return SecurityStatus.SECURE;
        }
        CEResponse ce = this.proveClosestEncloser(qname, zonename, nsec3s);
        if (ce.status != SecurityStatus.SECURE) {
            return SecurityStatus.BOGUS;
        }
        if ((ce.ncNsec3.getFlags() & 1) != 1) {
            return SecurityStatus.BOGUS;
        }
        return SecurityStatus.INSECURE;
    }

    private static final class CEResponse {
        private final Name closestEncloser;
        private final NSEC3Record ceNsec3;
        private NSEC3Record ncNsec3;
        private SecurityStatus status = SecurityStatus.UNCHECKED;

        private CEResponse(Name ce, NSEC3Record nsec3) {
            this.closestEncloser = ce;
            this.ceNsec3 = nsec3;
        }
    }
}

