/*
 * Decompiled with CFR 0.152.
 */
package crimsonedgehope.minecraft.fabric.socksproxyclient.config.entry;

import crimsonedgehope.minecraft.fabric.socksproxyclient.socks.SocksProxyCredential;
import crimsonedgehope.minecraft.fabric.socksproxyclient.socks.SocksVersion;
import java.net.InetSocketAddress;
import java.net.Proxy;
import lombok.Generated;
import lombok.NonNull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ProxyEntry {
    private Proxy proxy;
    private SocksVersion version;
    private SocksProxyCredential socksProxyCredential;

    public ProxyEntry(@NonNull SocksVersion version, InetSocketAddress sa) {
        this(version, sa, null, null);
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
    }

    public ProxyEntry(@NonNull SocksVersion version, InetSocketAddress sa, @Nullable String username, @Nullable String password) {
        this(version, sa, new SocksProxyCredential(username, password));
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
    }

    public ProxyEntry(@NonNull SocksVersion version, InetSocketAddress sa, @NonNull SocksProxyCredential socksProxyCredential) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        if (socksProxyCredential == null) {
            throw new NullPointerException("socksProxyCredential is marked non-null but is null");
        }
        this.proxy = new Proxy(Proxy.Type.SOCKS, sa);
        this.version = version;
        this.socksProxyCredential = socksProxyCredential;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
        Validate.isTrue((boolean)proxy.type().equals((Object)Proxy.Type.SOCKS));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProxyEntry)) {
            return false;
        }
        ProxyEntry entry = (ProxyEntry)o;
        if (this.getVersion() != entry.getVersion()) {
            return false;
        }
        Proxy proxy0 = this.getProxy();
        Proxy proxy1 = entry.getProxy();
        if (!proxy0.type().equals((Object)proxy1.type())) {
            return false;
        }
        InetSocketAddress sa0 = (InetSocketAddress)proxy0.address();
        InetSocketAddress sa1 = (InetSocketAddress)proxy1.address();
        if (!this.compare(sa0.getHostString(), sa1.getHostString())) {
            return false;
        }
        if (sa0.getPort() != sa1.getPort()) {
            return false;
        }
        SocksProxyCredential c0 = this.getSocksProxyCredential();
        SocksProxyCredential c1 = entry.getSocksProxyCredential();
        if (!this.compare(c0.getUsername(), c1.getUsername())) {
            return false;
        }
        return this.compare(c0.getPassword(), c1.getPassword());
    }

    private boolean compare(String s1, String s2) {
        return !(s1 != null && s2 != null ? !s1.equals(s2) : s1 != null || s2 != null);
    }

    public int hashCode() {
        int result = this.getProxy().hashCode();
        result = 31 * result + this.getVersion().hashCode();
        result = 31 * result + this.getSocksProxyCredential().hashCode();
        return result;
    }

    @Generated
    public Proxy getProxy() {
        return this.proxy;
    }

    @Generated
    public SocksVersion getVersion() {
        return this.version;
    }

    @Generated
    public SocksProxyCredential getSocksProxyCredential() {
        return this.socksProxyCredential;
    }

    @Generated
    public void setVersion(SocksVersion version) {
        this.version = version;
    }

    @Generated
    public void setSocksProxyCredential(SocksProxyCredential socksProxyCredential) {
        this.socksProxyCredential = socksProxyCredential;
    }
}

