/*
 * Decompiled with CFR 0.152.
 */
package crimsonedgehope.minecraft.fabric.socksproxyclient.injection;

import com.google.common.collect.Sets;
import crimsonedgehope.minecraft.fabric.socksproxyclient.BaseUtils;
import crimsonedgehope.minecraft.fabric.socksproxyclient.injection.MixinUtilsProxy;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.version.VersionComparisonOperator;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

@Environment(value=EnvType.CLIENT)
public class SocksProxyClientMixinPlugin
implements IMixinConfigPlugin {
    public static final Logger LOGGER = BaseUtils.getLogger("Mixin");
    private static final HashSet<String> MY_POOR_CLASSES = Sets.newHashSet((Object[])new String[]{"crimsonedgehope.minecraft.fabric.socksproxyclient.injection.mixin.MixinMultiplayerServerListPingerNoLegacyPing", "crimsonedgehope.minecraft.fabric.socksproxyclient.injection.mixin.MixinServerEntry"});

    public void onLoad(String mixinPackage) {
        Optional viafabricplus = FabricLoader.getInstance().getModContainer("viafabricplus");
        if (viafabricplus.isEmpty()) {
            MixinUtilsProxy.viaFabricPlus(false);
            return;
        }
        ModMetadata viafabricplusMetadata = ((ModContainer)viafabricplus.get()).getMetadata();
        try {
            MixinUtilsProxy.viaFabricPlus(VersionComparisonOperator.GREATER_EQUAL.test(viafabricplusMetadata.getVersion(), Version.parse((String)"3.0.0")));
            if (MixinUtilsProxy.viaFabricPlus()) {
                LOGGER.warn("ViaFabricPlus detected");
            }
        }
        catch (VersionParsingException e) {
            throw new Error(e);
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        boolean ret = true;
        if (MixinUtilsProxy.viaFabricPlus() && MY_POOR_CLASSES.contains(mixinClassName)) {
            LOGGER.warn("Dismiss {} because of ViaFabricPlus", (Object)mixinClassName);
            ret = false;
        }
        return ret;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

