/*
 * Decompiled with CFR 0.152.
 */
package crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.dnssec;

import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.DNSKEYRecord;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.DNSSEC;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.RRSIGRecord;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.RRset;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Record;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Type;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.dnssec.JustifiedSecStatus;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.dnssec.R;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.dnssec.SRRset;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.dnssec.SecurityStatus;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.dnssec.ValUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DnsSecVerifier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DnsSecVerifier.class);

    DnsSecVerifier() {
    }

    private List<DNSKEYRecord> findKey(RRset dnskeyRrset, RRSIGRecord signature) {
        if (!signature.getSigner().equals(dnskeyRrset.getName())) {
            log.trace("Could not find appropriate key because incorrect keyset was supplied. Wanted: {}, got: {}", (Object)signature.getSigner(), (Object)dnskeyRrset.getName());
            return Collections.emptyList();
        }
        int keyid = signature.getFootprint();
        int alg = signature.getAlgorithm();
        ArrayList<DNSKEYRecord> res = new ArrayList<DNSKEYRecord>(dnskeyRrset.size());
        for (Record r : dnskeyRrset.rrs()) {
            DNSKEYRecord dnskey = (DNSKEYRecord)r;
            if (dnskey.getAlgorithm() != alg || dnskey.getFootprint() != keyid) continue;
            res.add(dnskey);
        }
        return res;
    }

    private JustifiedSecStatus verifySignature(SRRset rrset, RRSIGRecord sigrec, RRset keyRrset, Instant date) {
        if (!rrset.getName().subdomain(keyRrset.getName())) {
            log.debug("Signer name is off-tree");
            return new JustifiedSecStatus(SecurityStatus.BOGUS, 6, R.get("dnskey.key_offtree", keyRrset.getName(), rrset.getName()));
        }
        List<DNSKEYRecord> keys = this.findKey(keyRrset, sigrec);
        if (keys.isEmpty()) {
            log.trace("Could not find appropriate key");
            return new JustifiedSecStatus(SecurityStatus.BOGUS, 9, R.get("dnskey.no_key", sigrec.getSigner()));
        }
        Iterator<DNSKEYRecord> iterator = keys.iterator();
        if (iterator.hasNext()) {
            DNSKEYRecord key = iterator.next();
            try {
                DNSSEC.verify((RRset)rrset, sigrec, key, date);
                ValUtils.setCanonicalNsecOwner(rrset, sigrec);
                return new JustifiedSecStatus(SecurityStatus.SECURE, -1, null);
            }
            catch (DNSSEC.KeyMismatchException kme) {
                return new JustifiedSecStatus(SecurityStatus.BOGUS, 6, R.get("dnskey.no_match", new Object[0]));
            }
            catch (DNSSEC.SignatureExpiredException e) {
                return new JustifiedSecStatus(SecurityStatus.BOGUS, 7, R.get("dnskey.expired", new Object[0]));
            }
            catch (DNSSEC.SignatureNotYetValidException e) {
                return new JustifiedSecStatus(SecurityStatus.BOGUS, 8, R.get("dnskey.not_yet_valid", new Object[0]));
            }
            catch (DNSSEC.DNSSECException e) {
                log.error("Failed to validate RRset {}/{}", new Object[]{rrset.getName(), Type.string(rrset.getType()), e});
                return new JustifiedSecStatus(SecurityStatus.BOGUS, 6, R.get("dnskey.invalid", new Object[0]));
            }
        }
        return new JustifiedSecStatus(SecurityStatus.UNCHECKED, -1, null);
    }

    public JustifiedSecStatus verify(SRRset rrset, RRset keyRrset, Instant date) {
        List<RRSIGRecord> sigs = rrset.sigs();
        if (sigs.isEmpty()) {
            log.info("RRset failed to verify due to lack of signatures");
            return new JustifiedSecStatus(SecurityStatus.BOGUS, 10, R.get("validate.bogus.missingsig", new Object[0]));
        }
        JustifiedSecStatus res = new JustifiedSecStatus(SecurityStatus.BOGUS, 10, R.get("validate.bogus.missingsig", new Object[0]));
        for (RRSIGRecord sigrec : sigs) {
            res = this.verifySignature(rrset, sigrec, keyRrset, date);
            if (res.status != SecurityStatus.SECURE) continue;
            return res;
        }
        log.info("RRset failed to verify: all signatures were BOGUS");
        return res;
    }

    public JustifiedSecStatus verify(RRset rrset, DNSKEYRecord dnskey, Instant date) {
        List<RRSIGRecord> sigs = rrset.sigs();
        if (sigs.isEmpty()) {
            log.info("RRset failed to verify due to lack of signatures");
            return new JustifiedSecStatus(SecurityStatus.BOGUS, 10, R.get("dnskey.no_sigs", rrset.getName()));
        }
        DNSSEC.DNSSECException lastException = null;
        for (RRSIGRecord sigrec : sigs) {
            if (sigrec.getFootprint() != dnskey.getFootprint()) continue;
            try {
                DNSSEC.verify(rrset, sigrec, dnskey, date);
                return new JustifiedSecStatus(SecurityStatus.SECURE, -1, null);
            }
            catch (DNSSEC.DNSSECException e) {
                log.error("Failed to validate RRset", (Throwable)e);
                lastException = e;
            }
        }
        log.info("RRset failed to verify: all signatures were BOGUS");
        int edeReason = 6;
        String reason = "dnskey.invalid";
        if (lastException instanceof DNSSEC.SignatureExpiredException) {
            edeReason = 7;
        } else if (lastException instanceof DNSSEC.SignatureNotYetValidException) {
            edeReason = 8;
        }
        return new JustifiedSecStatus(SecurityStatus.BOGUS, edeReason, reason);
    }
}

