/*
 * Decompiled with CFR 0.152.
 */
package crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.dnssec;

import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Name;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.dnssec.KeyEntry;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

final class KeyCache {
    public static final String MAX_TTL_CONFIG = "dnsjava.dnssec.keycache.max_ttl";
    public static final String MAX_CACHE_SIZE_CONFIG = "dnsjava.dnssec.keycache.max_size";
    private static final int DEFAULT_MAX_TTL = 900;
    private static final int DEFAULT_MAX_CACHE_SIZE = 1000;
    private final Map<String, CacheEntry> cache;
    private final Clock clock;
    private long maxTtl = 900L;
    private int maxCacheSize = 1000;

    public KeyCache() {
        this(Clock.systemUTC());
    }

    public KeyCache(Clock clock) {
        this.clock = clock;
        this.cache = Collections.synchronizedMap(new LinkedHashMap<String, CacheEntry>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, CacheEntry> eldest) {
                return this.size() >= KeyCache.this.maxCacheSize;
            }
        });
    }

    public void init(Properties config) {
        if (config == null) {
            return;
        }
        String s = config.getProperty(MAX_TTL_CONFIG);
        if (s != null) {
            this.maxTtl = Long.parseLong(s);
        }
        if ((s = config.getProperty(MAX_CACHE_SIZE_CONFIG)) != null) {
            this.maxCacheSize = Integer.parseInt(s);
        }
    }

    public KeyEntry find(Name n, int dclass) {
        while (n.labels() > 0) {
            String k = this.key(n, dclass);
            KeyEntry entry = this.lookupEntry(k);
            if (entry != null) {
                return entry;
            }
            n = new Name(n, 1);
        }
        return null;
    }

    public void store(KeyEntry ke) {
        if (!ke.isGood() && !ke.isNull()) {
            return;
        }
        if (ke.getType() != 48) {
            return;
        }
        String k = this.key(ke.getName(), ke.getDClass());
        CacheEntry ce = new CacheEntry(ke, this.maxTtl);
        this.cache.put(k, ce);
    }

    private String key(Name n, int dclass) {
        return "K" + dclass + "/" + n;
    }

    private KeyEntry lookupEntry(String key) {
        CacheEntry centry = this.cache.get(key);
        if (centry == null) {
            return null;
        }
        if (centry.expiration.isBefore(this.clock.instant())) {
            this.cache.remove(key);
            return null;
        }
        return centry.keyEntry;
    }

    private class CacheEntry {
        private final Instant expiration;
        private final KeyEntry keyEntry;

        CacheEntry(KeyEntry keyEntry, long maxTtl) {
            long ttl = keyEntry.getTTL();
            if (ttl > maxTtl) {
                ttl = maxTtl;
            }
            this.expiration = KeyCache.this.clock.instant().plus(ttl, ChronoUnit.SECONDS);
            this.keyEntry = keyEntry;
        }
    }
}

