/*
 * Decompiled with CFR 0.152.
 */
package crimsonedgehope.minecraft.fabric.socksproxyclient.config;

import com.google.gson.JsonObject;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.SocksProxyClientConfig;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.entry.SocksProxyClientConfigEntry;
import crimsonedgehope.minecraft.fabric.socksproxyclient.dns.DNSUtils;
import crimsonedgehope.minecraft.fabric.socksproxyclient.dns.SocksProxyClientDNSResolver;
import crimsonedgehope.minecraft.fabric.socksproxyclient.dns.SystemResolver;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public final class DNSConfig
extends SocksProxyClientConfig {
    private static final DNSConfig INSTANCE = new DNSConfig();
    public static final String CATEGORY = "dns";
    private static final SocksProxyClientConfigEntry<Class<? extends SocksProxyClientDNSResolver>> resolver = new SocksProxyClientConfigEntry<Class<SystemResolver>>(INSTANCE.getClass(), "resolver", class_2561.method_43471((String)"socksproxyclient.config.dns.resolver"), class_2561.method_43471((String)"socksproxyclient.config.dns.resolver.tooltip"), SystemResolver.class);
    private static final SocksProxyClientConfigEntry<Boolean> shouldDismissSystemHosts = new SocksProxyClientConfigEntry<Boolean>(INSTANCE.getClass(), "shouldDismissSystemHosts", class_2561.method_43471((String)"socksproxyclient.config.dns.shouldDismissSystemHosts"), class_2561.method_43471((String)"socksproxyclient.config.dns.shouldDismissSystemHosts.tooltip"), false);

    public DNSConfig() {
        super("dns.json");
    }

    @Override
    public JsonObject defaultEntries() {
        JsonObject obj = new JsonObject();
        obj.addProperty(resolver.getJsonEntry(), resolver.getDefaultValue().getName());
        obj.addProperty(shouldDismissSystemHosts.getJsonEntry(), shouldDismissSystemHosts.getDefaultValue());
        return obj;
    }

    @Override
    public void fromJsonObject(JsonObject entries) {
        try {
            resolver.setValue(Class.forName(entries.get(resolver.getJsonEntry()).getAsString(), false, SocksProxyClientDNSResolver.class.getClassLoader()).asSubclass(SocksProxyClientDNSResolver.class));
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        shouldDismissSystemHosts.setValue(entries.get(shouldDismissSystemHosts.getJsonEntry()).getAsBoolean());
    }

    @Override
    public JsonObject toJsonObject() {
        JsonObject obj = new JsonObject();
        obj.addProperty(resolver.getJsonEntry(), resolver.getValue().getName());
        obj.addProperty(shouldDismissSystemHosts.getJsonEntry(), shouldDismissSystemHosts.getValue());
        return obj;
    }

    public static boolean shouldDismissSystemHosts() {
        return shouldDismissSystemHosts.getValue();
    }

    public static SocksProxyClientDNSResolver resolver() {
        try {
            DNSUtils.LOGGER.debug("Creating DNS resolver {}", (Object)resolver.getValue().getName());
            return resolver.getValue().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
    }
}

