/*
 * Decompiled with CFR 0.152.
 */
package crimsonedgehope.minecraft.fabric.socksproxyclient.config;

import com.google.gson.JsonObject;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.SocksProxyClientConfig;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.entry.SocksProxyClientConfigEntry;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.entry.SocksProxyClientInternalConfigEntry;
import crimsonedgehope.minecraft.fabric.socksproxyclient.dns.doh.DNSOverHTTPSProvider;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public final class DNSOverHTTPSConfig
extends SocksProxyClientConfig {
    private static final DNSOverHTTPSConfig INSTANCE = new DNSOverHTTPSConfig();
    public static final String CATEGORY = "doh";
    private static final SocksProxyClientConfigEntry<DNSOverHTTPSProvider> dohProvider = new SocksProxyClientConfigEntry<DNSOverHTTPSProvider>(INSTANCE.getClass(), "dohProvider", class_2561.method_43471((String)"socksproxyclient.config.doh.dohProvider"), DNSOverHTTPSProvider.CLOUDFLARE);
    private static final SocksProxyClientConfigEntry<String> customDohProvider = new SocksProxyClientConfigEntry<String>(INSTANCE.getClass(), "customDohProvider", class_2561.method_43471((String)"socksproxyclient.config.doh.customDohProvider"), DNSOverHTTPSProvider.CLOUDFLARE.getUrl());
    private static final SocksProxyClientInternalConfigEntry<Integer> cacheTTL = new SocksProxyClientInternalConfigEntry<Integer>(INSTANCE.getClass(), "cacheTTL", 120);

    public DNSOverHTTPSConfig() {
        super("doh.json");
    }

    @Override
    public JsonObject defaultEntries() {
        JsonObject obj = new JsonObject();
        obj.addProperty(dohProvider.getJsonEntry(), dohProvider.getDefaultValue().name());
        obj.addProperty(customDohProvider.getJsonEntry(), customDohProvider.getDefaultValue());
        obj.addProperty(cacheTTL.getJsonEntry(), (Number)cacheTTL.getDefaultValue());
        return obj;
    }

    @Override
    public JsonObject toJsonObject() {
        JsonObject obj = new JsonObject();
        obj.addProperty(dohProvider.getJsonEntry(), dohProvider.getValue().name());
        obj.addProperty(customDohProvider.getJsonEntry(), customDohProvider.getValue());
        obj.addProperty(cacheTTL.getJsonEntry(), (Number)cacheTTL.getValue());
        return obj;
    }

    @Override
    public void fromJsonObject(JsonObject object) {
        dohProvider.setValue(DNSOverHTTPSProvider.valueOf(object.get(dohProvider.getJsonEntry()).getAsString()));
        customDohProvider.setValue(object.get(customDohProvider.getJsonEntry()).getAsString());
        cacheTTL.setValue(object.get(cacheTTL.getJsonEntry()).getAsInt());
    }

    public static String getUrl() {
        if (dohProvider.getValue().equals((Object)DNSOverHTTPSProvider.CUSTOM)) {
            return customDohProvider.getValue();
        }
        return dohProvider.getValue().getUrl();
    }

    public static int cacheTTL() {
        int v = (Integer)cacheTTL.getValue();
        if (v < 60) {
            v = 60;
        }
        return v;
    }
}

