/*
 * Decompiled with CFR 0.152.
 */
package crimsonedgehope.minecraft.fabric.socksproxyclient.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.ConfigUtils;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.entry.SocksProxyClientConfigEntry;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import lombok.Generated;
import lombok.NonNull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class SocksProxyClientConfig {
    private static Path rootPath = null;
    private final File configFile;
    protected Predicate<Field> entryVariablesListFilter = field -> SocksProxyClientConfigEntry.class.isAssignableFrom(field.getType());

    public static void initRootPath(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (rootPath != null) {
            return;
        }
        rootPath = path;
        File file = path.toFile();
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    protected static Path configPathDir() {
        return rootPath;
    }

    protected SocksProxyClientConfig(String filename) {
        this(SocksProxyClientConfig.configPathDir().resolve(filename).toFile());
    }

    protected SocksProxyClientConfig(File configFile) {
        this.configFile = configFile;
    }

    public abstract JsonObject defaultEntries();

    public abstract JsonObject toJsonObject();

    public abstract void fromJsonObject(JsonObject var1);

    public void load() {
        ConfigUtils.LOGGER.info("Reading config file {}", (Object)this.configFile.getName());
        if (!this.configFile.exists()) {
            this.writeJson(this.defaultEntries());
        }
        try {
            FileReader reader = this.readFile(this.configFile);
            Gson gson = new Gson();
            JsonObject object = (JsonObject)gson.fromJson(new JsonReader((Reader)reader), JsonObject.class);
            this.parseJson(object);
        }
        catch (Exception e) {
            ConfigUtils.LOGGER.error("Error reading config file {}", (Object)this.configFile.getName(), (Object)e);
        }
    }

    public void save() {
        this.writeJson(this.toJsonObject());
    }

    private FileReader readFile(File file) throws IOException {
        return this.readFile(file, StandardCharsets.UTF_8);
    }

    private FileReader readFile(File file, Charset charset) throws IOException {
        return new FileReader(file, charset);
    }

    private FileWriter writeFile(File file, boolean append) throws IOException {
        return new FileWriter(file, append);
    }

    private FileWriter writeFile(File file, String content) throws IOException {
        return this.writeFile(file, content, false);
    }

    private FileWriter writeFile(File file, String content, boolean append) throws IOException {
        FileWriter writer = this.writeFile(file, append);
        writer.write(content);
        return writer;
    }

    protected void resetToDefault() {
        try {
            List<SocksProxyClientConfigEntry<?>> entries = this.entryFields();
            entries.forEach(SocksProxyClientConfigEntry::reset);
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    private void parseJson(JsonObject object) {
        this.resetToDefault();
        JsonObject defaults = this.defaultEntries();
        if (object == null || object.size() == 0) {
            this.writeJson(defaults);
            this.load();
            return;
        }
        ConfigUtils.LOGGER.info("Parsing config json {}", (Object)this.configFile.getName());
        boolean reload = false;
        try {
            for (Map.Entry entry : defaults.entrySet()) {
                if (object.has((String)entry.getKey())) continue;
                object.add((String)entry.getKey(), (JsonElement)entry.getValue());
                reload = true;
            }
            if (reload) {
                this.writeJson(object);
                this.load();
                return;
            }
        }
        catch (Exception e) {
            ConfigUtils.LOGGER.error("Error reading config json {}", (Object)this.configFile.getName(), (Object)e);
        }
        this.fromJsonObject(object);
    }

    private void writeJson(JsonObject entries) {
        try (FileWriter writer = this.writeFile(this.configFile, false);){
            ConfigUtils.LOGGER.info("Writing config to file {}", (Object)this.configFile.getName());
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            writer.write(gson.toJson((JsonElement)entries));
        }
        catch (Exception e) {
            ConfigUtils.LOGGER.error("Error writing config to file {}", (Object)this.configFile.getName(), (Object)e);
        }
    }

    public List<SocksProxyClientConfigEntry<?>> entryFields(Predicate<Field> listFilter) throws Exception {
        ArrayList entries = new ArrayList();
        List<Field> fields = Arrays.stream(this.getClass().getDeclaredFields()).filter(listFilter).toList();
        for (Field field : fields) {
            SocksProxyClientConfigEntry entry = (SocksProxyClientConfigEntry)field.get(null);
            Class<?> clazz = entry.getDefaultValue().getClass();
            if (Integer.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz) || Enum.class.isAssignableFrom(clazz) || List.class.isAssignableFrom(clazz) || Class.class.isAssignableFrom(clazz)) {
                entries.add(entry);
                continue;
            }
            throw new UnsupportedOperationException("Not using \"" + clazz.getName() + "\"!");
        }
        return entries;
    }

    public SocksProxyClientConfigEntry<?> getEntryField(String fieldName) throws Exception {
        return this.entryFields(field -> this.entryVariablesListFilter.test((Field)field) && field.getName().equals(fieldName)).get(0);
    }

    public <T> SocksProxyClientConfigEntry<T> getEntryField(String fieldName, Class<T> valueType) throws Exception {
        return this.entryFields(field -> {
            try {
                field.setAccessible(true);
                return this.entryVariablesListFilter.test((Field)field) && field.getName().equals(fieldName) && valueType.isAssignableFrom(((SocksProxyClientConfigEntry)field.get(null)).getDefaultValue().getClass());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).get(0);
    }

    public List<SocksProxyClientConfigEntry<?>> entryFields() throws Exception {
        return this.entryFields(field -> {
            try {
                field.setAccessible(true);
                return this.entryVariablesListFilter.test((Field)field);
            }
            catch (Throwable t) {
                throw new Error(t);
            }
        });
    }

    @Generated
    public File getConfigFile() {
        return this.configFile;
    }
}

