/*
 * Decompiled with CFR 0.152.
 */
package crimsonedgehope.minecraft.fabric.socksproxyclient.dns;

import crimsonedgehope.minecraft.fabric.socksproxyclient.BaseUtils;
import crimsonedgehope.minecraft.fabric.socksproxyclient.dns.SocksProxyClientDNSResolver;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Lookup;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Record;
import java.lang.reflect.Field;
import java.net.UnknownHostException;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public final class DNSUtils {
    public static final Logger LOGGER = BaseUtils.getLogger("DNS");

    public static String getResolverName(Class<? extends SocksProxyClientDNSResolver> clazz) throws Exception {
        Field field = clazz.getDeclaredField("NAME");
        field.setAccessible(true);
        String name = (String)field.get(null);
        if (name == null) {
            name = clazz.getName();
        }
        return name;
    }

    public static List<Record> performLookup(@NonNull Lookup lookup2) throws UnknownHostException {
        if (lookup2 == null) {
            throw new NullPointerException("lookup is marked non-null but is null");
        }
        lookup2.setCache(null);
        for (int count = 0; count < 3; ++count) {
            lookup2.run();
            while (true) {
                try {
                    lookup2.getResult();
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
            Record[] records = lookup2.getAnswers();
            if (records == null || records.length == 0) {
                if (lookup2.getResult() == 2) {
                    continue;
                }
                throw new UnknownHostException("No result (" + lookup2.getResult() + ")");
            }
            return List.of(records);
        }
        throw new UnknownHostException("All 3 attempts failed");
    }

    @Generated
    private DNSUtils() {
    }
}

