/*
 * Decompiled with CFR 0.152.
 */
package crimsonedgehope.minecraft.fabric.socksproxyclient.dns;

import com.google.common.net.InetAddresses;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.DNSConfig;
import crimsonedgehope.minecraft.fabric.socksproxyclient.dns.DNSUtils;
import crimsonedgehope.minecraft.fabric.socksproxyclient.dns.SocksProxyClientDNSResolver;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.ARecord;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Record;
import io.netty.resolver.InetNameResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public final class NettyResolver
extends InetNameResolver {
    public NettyResolver(EventExecutor executor) {
        super(executor);
    }

    private List<InetAddress> getInetAddresses(String hostname) throws Exception {
        if (InetAddresses.isInetAddress((String)hostname)) {
            return List.of(InetAddress.getByName(hostname));
        }
        SocksProxyClientDNSResolver resolver = DNSConfig.resolver();
        DNSUtils.LOGGER.info("{}: Trying to resolve {}", (Object)DNSUtils.getResolverName(resolver.getClass()), (Object)hostname);
        List<Record> records = resolver.resolve(hostname, 1);
        InetAddress[] inets = new InetAddress[records.size()];
        for (int i = 0; i < records.size(); ++i) {
            inets[i] = InetAddress.getByAddress(hostname, ((ARecord)records.get(i)).getAddress().getAddress());
        }
        return List.of(inets);
    }

    protected void doResolve(String hostname, Promise<InetAddress> promise) throws Exception {
        try {
            promise.setSuccess((Object)this.getInetAddresses(hostname).get(0));
        }
        catch (UnknownHostException e) {
            promise.setFailure((Throwable)e);
        }
    }

    protected void doResolveAll(String hostname, Promise<List<InetAddress>> promise) throws Exception {
        try {
            promise.setSuccess(this.getInetAddresses(hostname));
        }
        catch (UnknownHostException e) {
            promise.setFailure((Throwable)e);
        }
    }
}

