/*
 * Decompiled with CFR 0.152.
 */
package crimsonedgehope.minecraft.fabric.socksproxyclient.injection.mixin;

import com.google.common.net.InetAddresses;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.DNSConfig;
import crimsonedgehope.minecraft.fabric.socksproxyclient.dns.DNSUtils;
import crimsonedgehope.minecraft.fabric.socksproxyclient.dns.SocksProxyClientDNSResolver;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.ARecord;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Record;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.SRVRecord;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_6368;
import net.minecraft.class_6369;
import net.minecraft.class_6370;
import net.minecraft.class_6371;
import net.minecraft.class_639;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_6370.class})
public class MixinAllowedAddressResolver {
    @Shadow
    @Final
    @Mutable
    private class_6369 field_33746;
    @Shadow
    @Final
    @Mutable
    private class_6371 field_33747;

    @Redirect(method={"<init>"}, at=@At(value="FIELD", target="Lnet/minecraft/client/network/AllowedAddressResolver;addressResolver:Lnet/minecraft/client/network/AddressResolver;", opcode=181))
    private void redirectGetAddressResolver(class_6370 instance, class_6369 originalAddressResolver) {
        this.field_33746 = serverAddress -> {
            try {
                if (InetAddresses.isInetAddress((String)serverAddress.method_2952())) {
                    return Optional.of(class_6368.method_36899((InetSocketAddress)new InetSocketAddress(serverAddress.method_2952(), serverAddress.method_2954())));
                }
                return this.addressResolver(serverAddress);
            }
            catch (Throwable e) {
                DNSUtils.LOGGER.error("Couldn't resolve {}", (Object)serverAddress.method_2952(), (Object)e);
                return Optional.empty();
            }
        };
    }

    @Redirect(method={"<init>"}, at=@At(value="FIELD", target="Lnet/minecraft/client/network/AllowedAddressResolver;redirectResolver:Lnet/minecraft/client/network/RedirectResolver;", opcode=181))
    private void redirectGetRedirectResolver(class_6370 instance, class_6371 originalRedirectResolver) {
        this.field_33747 = serverAddress -> {
            if (serverAddress.method_2954() == 25565) {
                try {
                    if (InetAddresses.isInetAddress((String)serverAddress.method_2952())) {
                        return Optional.of(new class_639(serverAddress.method_2952(), serverAddress.method_2954()));
                    }
                    return this.redirectResolver(serverAddress);
                }
                catch (Throwable e) {
                    DNSUtils.LOGGER.warn("Couldn't resolve _minecraft._tcp.{}: {}", (Object)serverAddress.method_2952(), (Object)e.getMessage());
                }
            }
            return Optional.empty();
        };
    }

    @Unique
    private List<Record> resolve(String hostname, int recordType) throws Exception {
        SocksProxyClientDNSResolver resolver = DNSConfig.resolver();
        DNSUtils.LOGGER.info("{}: Trying to resolve {}", (Object)DNSUtils.getResolverName(resolver.getClass()), (Object)hostname);
        return resolver.resolve(hostname, recordType);
    }

    @Unique
    private Optional<class_6368> addressResolver(class_639 serverAddress) throws Exception {
        List<Record> records = this.resolve(serverAddress.method_2952(), 1);
        ARecord arec = (ARecord)records.get(0);
        DNSUtils.LOGGER.debug("{}", (Object)arec);
        InetAddress inetAddress = InetAddress.getByAddress(serverAddress.method_2952(), arec.getAddress().getAddress());
        DNSUtils.LOGGER.info("Successfully resolve {} to {}", (Object)serverAddress.method_2952(), (Object)inetAddress.getHostAddress());
        return Optional.of(class_6368.method_36899((InetSocketAddress)new InetSocketAddress(inetAddress, serverAddress.method_2954())));
    }

    @Unique
    private Optional<class_639> redirectResolver(class_639 serverAddress) throws Exception {
        String addr0 = "_minecraft._tcp." + serverAddress.method_2952();
        List<Record> records = this.resolve(addr0, 33);
        SRVRecord srv = (SRVRecord)records.get(0);
        DNSUtils.LOGGER.debug("{}", (Object)srv);
        String host = srv.getTarget().toString(true);
        DNSUtils.LOGGER.info("Successfully resolve {} to {}:{}", new Object[]{addr0, host, srv.getPort()});
        return Optional.of(new class_639(host, srv.getPort()));
    }
}

