/*
 * Decompiled with CFR 0.152.
 */
package crimsonedgehope.minecraft.fabric.socksproxyclient.modmenu;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.terraformersmc.modmenu.api.UpdateChannel;
import com.terraformersmc.modmenu.api.UpdateChecker;
import com.terraformersmc.modmenu.api.UpdateInfo;
import com.terraformersmc.modmenu.util.HttpUtil;
import crimsonedgehope.minecraft.fabric.socksproxyclient.BaseUtils;
import crimsonedgehope.minecraft.fabric.socksproxyclient.config.ModConfig;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.version.VersionComparisonOperator;
import net.fabricmc.loader.impl.util.version.VersionParser;
import net.minecraft.class_155;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public final class SocksProxyClientUpdateChecker
implements UpdateChecker {
    private static final String METADATA_URL = "https://garment.warpedinnether.top/socksproxyclient";
    private static final Logger LOGGER = BaseUtils.getLogger("UpdateChecker");
    private static final HttpClient.Builder CLIENT = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL);
    private static final HttpRequest.Builder REQUEST = HttpRequest.newBuilder().GET().uri(URI.create("https://garment.warpedinnether.top/socksproxyclient"));
    private static final String USER_AGENT;

    public UpdateInfo checkForUpdates() {
        if (!ModConfig.shouldCheckUpdates()) {
            return null;
        }
        HttpClient client = CLIENT.build();
        try {
            REQUEST.setHeader("User-Agent", USER_AGENT);
            HttpResponse<String> response = client.send(REQUEST.build(), HttpResponse.BodyHandlers.ofString());
            int remoteResponseStatusCode = response.statusCode();
            if (remoteResponseStatusCode != 200) {
                throw new UnsupportedOperationException(String.format("Remote server returned %d. %d expected.", remoteResponseStatusCode, 200));
            }
            JsonObject remoteResponse = (JsonObject)new Gson().fromJson(response.body(), JsonObject.class);
            UpdateInfo updateInfo = SocksProxyClientUpdateChecker.check(remoteResponse);
            if (client != null) {
                client.close();
            }
            return updateInfo;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable t) {
                LOGGER.error("Failed to check for updates!", t);
                return null;
            }
        }
    }

    public static UpdateInfo check(JsonObject object) throws Exception {
        String currentModVersion;
        SemanticVersion parsedSemanticVersion;
        String currentModReleaseChannel;
        String currentMinecraftVersion;
        JsonObject knownGameVersions = object.get("versions").getAsJsonObject();
        if (!knownGameVersions.has(currentMinecraftVersion = class_155.method_16673().method_48019())) {
            throw new UnsupportedOperationException(String.format("No version found for \"%s\"", currentMinecraftVersion));
        }
        JsonObject knownReleaseChannels = knownGameVersions.getAsJsonObject(currentMinecraftVersion);
        if (!knownReleaseChannels.has(currentModReleaseChannel = (parsedSemanticVersion = VersionParser.parseSemantic((String)(currentModVersion = "11.4.0-alpha+1.21.4"))).getPrereleaseKey().orElse("release"))) {
            throw new UnsupportedOperationException(String.format("No release channel found for \"%s\"", currentModReleaseChannel));
        }
        JsonArray knownChannelModVersions = knownReleaseChannels.get(currentModReleaseChannel).getAsJsonArray();
        for (JsonElement element : knownChannelModVersions.asList()) {
            UpdateInfo res = SocksProxyClientUpdateChecker.compare(Version.parse((String)element.getAsString()), (Version)parsedSemanticVersion, currentModReleaseChannel);
            if (res == null) continue;
            return res;
        }
        LOGGER.info("You are on latest version!");
        return null;
    }

    public static UpdateInfo compare(Version newVersion, Version currrentVersion, final String releaseChannel) {
        if (VersionComparisonOperator.GREATER.test(newVersion, currrentVersion)) {
            return new UpdateInfo(){

                public boolean isUpdateAvailable() {
                    return true;
                }

                public String getDownloadLink() {
                    return "https://modrinth.com/mod/socksproxyclient";
                }

                public UpdateChannel getUpdateChannel() {
                    return switch (releaseChannel) {
                        case "alpha" -> UpdateChannel.ALPHA;
                        case "beta" -> UpdateChannel.BETA;
                        default -> UpdateChannel.RELEASE;
                    };
                }
            };
        }
        return null;
    }

    @Generated
    public SocksProxyClientUpdateChecker() {
    }

    static {
        try {
            Method method = HttpUtil.class.getDeclaredMethod("buildUserAgent", new Class[0]);
            method.setAccessible(true);
            USER_AGENT = (String)method.invoke(null, new Object[0]);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
    }
}

