/*
 * Decompiled with CFR 0.152.
 */
package crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS;

import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.WireParseException;
import java.nio.ByteBuffer;

public class DNSInput {
    private final ByteBuffer byteBuffer;
    private final int offset;
    private final int limit;
    private int savedPos;
    private int savedEnd;

    public DNSInput(byte[] input) {
        this(ByteBuffer.wrap(input));
    }

    public DNSInput(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
        this.offset = byteBuffer.position();
        this.limit = byteBuffer.limit();
        this.savedPos = -1;
        this.savedEnd = -1;
    }

    public int current() {
        return this.byteBuffer.position() - this.offset;
    }

    public int remaining() {
        return this.byteBuffer.remaining();
    }

    private void require(int n) throws WireParseException {
        if (n > this.remaining()) {
            throw new WireParseException("end of input");
        }
    }

    public void setActive(int len) {
        if (len > this.limit - this.byteBuffer.position()) {
            throw new IllegalArgumentException("cannot set active region past end of input");
        }
        this.byteBuffer.limit(this.byteBuffer.position() + len);
    }

    public void clearActive() {
        this.byteBuffer.limit(this.limit);
    }

    public int saveActive() {
        return this.byteBuffer.limit() - this.offset;
    }

    public void restoreActive(int pos) {
        if (pos + this.offset > this.limit) {
            throw new IllegalArgumentException("cannot set active region past end of input");
        }
        this.byteBuffer.limit(pos + this.offset);
    }

    public void jump(int index) {
        if (index + this.offset >= this.limit) {
            throw new IllegalArgumentException("cannot jump past end of input");
        }
        this.byteBuffer.position(this.offset + index);
        this.byteBuffer.limit(this.limit);
    }

    public void save() {
        this.savedPos = this.byteBuffer.position();
        this.savedEnd = this.byteBuffer.limit();
    }

    public void restore() {
        if (this.savedPos < 0) {
            throw new IllegalStateException("no previous state");
        }
        this.byteBuffer.position(this.savedPos);
        this.byteBuffer.limit(this.savedEnd);
        this.savedPos = -1;
        this.savedEnd = -1;
    }

    public int readU8() throws WireParseException {
        this.require(1);
        return this.byteBuffer.get() & 0xFF;
    }

    public int readU16() throws WireParseException {
        this.require(2);
        return this.byteBuffer.getShort() & 0xFFFF;
    }

    public long readU32() throws WireParseException {
        this.require(4);
        return (long)this.byteBuffer.getInt() & 0xFFFFFFFFL;
    }

    public void readByteArray(byte[] b, int off, int len) throws WireParseException {
        this.require(len);
        this.byteBuffer.get(b, off, len);
    }

    public byte[] readByteArray(int len) throws WireParseException {
        this.require(len);
        byte[] out = new byte[len];
        this.byteBuffer.get(out, 0, len);
        return out;
    }

    public byte[] readByteArray() {
        int len = this.remaining();
        byte[] out = new byte[len];
        this.byteBuffer.get(out, 0, len);
        return out;
    }

    public byte[] readCountedString() throws WireParseException {
        int len = this.readU8();
        return this.readByteArray(len);
    }
}

