/*
 * Decompiled with CFR 0.152.
 */
package crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS;

import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Compression;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.DNSInput;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.DNSOutput;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Name;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Record;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.TextParseException;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Tokenizer;
import java.io.IOException;

public class ISDNRecord
extends Record {
    private byte[] address;
    private byte[] subAddress;

    ISDNRecord() {
    }

    public ISDNRecord(Name name, int dclass, long ttl, String address, String subAddress) {
        super(name, 20, dclass, ttl);
        try {
            this.address = ISDNRecord.byteArrayFromString(address);
            if (subAddress != null) {
                this.subAddress = ISDNRecord.byteArrayFromString(subAddress);
            }
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    protected void rrFromWire(DNSInput in) throws IOException {
        this.address = in.readCountedString();
        if (in.remaining() > 0) {
            this.subAddress = in.readCountedString();
        }
    }

    @Override
    protected void rdataFromString(Tokenizer st, Name origin) throws IOException {
        try {
            this.address = ISDNRecord.byteArrayFromString(st.getString());
            Tokenizer.Token t = st.get();
            if (t.isString()) {
                this.subAddress = ISDNRecord.byteArrayFromString(t.value());
            } else {
                st.unget();
            }
        }
        catch (TextParseException e) {
            throw st.exception(e.getMessage());
        }
    }

    public String getAddress() {
        return ISDNRecord.byteArrayToString(this.address, false);
    }

    public String getSubAddress() {
        if (this.subAddress == null) {
            return null;
        }
        return ISDNRecord.byteArrayToString(this.subAddress, false);
    }

    @Override
    protected void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeCountedString(this.address);
        if (this.subAddress != null) {
            out.writeCountedString(this.subAddress);
        }
    }

    @Override
    protected String rrToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ISDNRecord.byteArrayToString(this.address, true));
        if (this.subAddress != null) {
            sb.append(" ");
            sb.append(ISDNRecord.byteArrayToString(this.subAddress, true));
        }
        return sb.toString();
    }
}

