/*
 * Decompiled with CFR 0.152.
 */
package crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS;

import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Compression;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.DNSInput;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.DNSOutput;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Name;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Options;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Record;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Tokenizer;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.utils.base64;
import java.io.IOException;

public class OPENPGPKEYRecord
extends Record {
    private byte[] cert;

    OPENPGPKEYRecord() {
    }

    public OPENPGPKEYRecord(Name name, int dclass, long ttl, byte[] cert) {
        super(name, 61, dclass, ttl);
        this.cert = cert;
    }

    @Override
    protected void rrFromWire(DNSInput in) {
        this.cert = in.readByteArray();
    }

    @Override
    protected void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.cert = st.getBase64();
    }

    @Override
    protected String rrToString() {
        StringBuilder sb = new StringBuilder();
        if (this.cert != null) {
            if (Options.check("multiline")) {
                sb.append("(\n");
                sb.append(base64.formatString(this.cert, 64, "\t", true));
            } else {
                sb.append(base64.toString(this.cert));
            }
        }
        return sb.toString();
    }

    public byte[] getCert() {
        return this.cert;
    }

    @Override
    protected void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeByteArray(this.cert);
    }
}

