/*
 * Decompiled with CFR 0.152.
 */
package crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.dnssec;

import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.DNSKEYRecord;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.DSRecord;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Name;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.Record;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.dnssec.SRRset;
import crimsonedgehope.minecraft.fabric.socksproxyclient.shadow.org.xbill.DNS.dnssec.SecurityStatus;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class TrustAnchorStore {
    private final Map<String, SRRset> map = new HashMap<String, SRRset>();

    public void store(SRRset rrset) {
        if (rrset.getType() != 43 && rrset.getType() != 48) {
            throw new IllegalArgumentException("Trust anchors can only be DS or DNSKEY records");
        }
        if (rrset.getType() == 48) {
            SRRset temp = new SRRset();
            for (Record r : rrset.rrs()) {
                DNSKEYRecord key = (DNSKEYRecord)r;
                DSRecord ds = new DSRecord(key.getName(), key.getDClass(), key.getTTL(), 4, key);
                temp.addRR(ds);
            }
            rrset = temp;
        }
        String k = this.key(rrset.getName(), rrset.getDClass());
        rrset.setSecurityStatus(SecurityStatus.SECURE);
        SRRset previous = this.map.put(k, rrset);
        if (previous != null) {
            previous.rrs().forEach(rrset::addRR);
        }
    }

    public SRRset find(Name name, int dclass) {
        while (name.labels() > 0) {
            String k = this.key(name, dclass);
            SRRset r = this.lookup(k);
            if (r != null) {
                return r;
            }
            name = new Name(name, 1);
        }
        return null;
    }

    public void clear() {
        this.map.clear();
    }

    public Collection<SRRset> items() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    private SRRset lookup(String key) {
        return this.map.get(key);
    }

    private String key(Name n, int dclass) {
        return "T" + dclass + "/" + n.canonicalize();
    }
}

